/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import junitparams.converters.Nullable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.ClientTaskQuery;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorker;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.indexer.RunnerTaskState;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.utils.Streams;
import org.easymock.EasyMock;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class CompactSegmentsTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final DruidCoordinatorConfig COORDINATOR_CONFIG = (DruidCoordinatorConfig)Mockito.mock(DruidCoordinatorConfig.class);
    private static final String DATA_SOURCE_PREFIX = "dataSource_";
    private static final int PARTITION_PER_TIME_INTERVAL = 4;
    private static final int TOTAL_BYTE_PER_DATASOURCE = 440;
    private static final int TOTAL_SEGMENT_PER_DATASOURCE = 44;
    private static final int TOTAL_INTERVAL_PER_DATASOURCE = 11;
    private static final int MAXIMUM_CAPACITY_WITH_AUTO_SCALE = 10;
    private final PartitionsSpec partitionsSpec;
    private final BiFunction<Integer, Integer, ShardSpec> shardSpecFactory;
    private Map<String, VersionedIntervalTimeline<String, DataSegment>> dataSources;
    Map<String, List<DataSegment>> datasourceToSegments = new HashMap<String, List<DataSegment>>();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        MutableInt nextRangePartitionBoundary = new MutableInt(0);
        return ImmutableList.of((Object)new Object[]{new DynamicPartitionsSpec(Integer.valueOf(300000), Long.valueOf(Long.MAX_VALUE)), NumberedShardSpec::new}, (Object)new Object[]{new HashedPartitionsSpec(null, Integer.valueOf(2), (List)ImmutableList.of((Object)"dim")), (bucketId, numBuckets) -> new HashBasedNumberedShardSpec(bucketId.intValue(), numBuckets.intValue(), bucketId, numBuckets, (List)ImmutableList.of((Object)"dim"), null, JSON_MAPPER)}, (Object)new Object[]{new SingleDimensionPartitionsSpec(Integer.valueOf(300000), null, "dim", false), (bucketId, numBuckets) -> new SingleDimensionShardSpec("dim", bucketId == 0 ? null : String.valueOf(nextRangePartitionBoundary.getAndIncrement()), bucketId.equals(numBuckets) ? null : String.valueOf(nextRangePartitionBoundary.getAndIncrement()), bucketId.intValue(), numBuckets)});
    }

    public CompactSegmentsTest(PartitionsSpec partitionsSpec, BiFunction<Integer, Integer, ShardSpec> shardSpecFactory) {
        this.partitionsSpec = partitionsSpec;
        this.shardSpecFactory = shardSpecFactory;
    }

    @Before
    public void setup() {
        ArrayList<DataSegment> allSegments = new ArrayList<DataSegment>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
                for (int k = 0; k < 4; ++k) {
                    List segmentForDatasource = this.datasourceToSegments.computeIfAbsent(dataSource, key -> new ArrayList());
                    DataSegment dataSegment = this.createSegment(dataSource, j, true, k);
                    allSegments.add(dataSegment);
                    segmentForDatasource.add(dataSegment);
                    dataSegment = this.createSegment(dataSource, j, false, k);
                    allSegments.add(dataSegment);
                    segmentForDatasource.add(dataSegment);
                }
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(allSegments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
        Mockito.when((Object)COORDINATOR_CONFIG.getCompactionSkipLockedIntervals()).thenReturn((Object)true);
    }

    private DataSegment createSegment(String dataSource, int startDay, boolean beforeNoon, int partition) {
        ShardSpec shardSpec = this.shardSpecFactory.apply(partition, 2);
        Interval interval = beforeNoon ? Intervals.of((String)StringUtils.format((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{startDay + 1, startDay + 1})) : Intervals.of((String)StringUtils.format((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{startDay + 1, startDay + 2}));
        return new DataSegment(dataSource, interval, "version", null, (List)ImmutableList.of(), (List)ImmutableList.of(), shardSpec, Integer.valueOf(0), 10L);
    }

    @Test
    public void testSerde() throws Exception {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        JSON_MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DruidCoordinatorConfig.class, (Object)COORDINATOR_CONFIG).addValue(ObjectMapper.class, (Object)JSON_MAPPER).addValue(IndexingServiceClient.class, (Object)indexingServiceClient));
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        String compactSegmentString = JSON_MAPPER.writeValueAsString((Object)compactSegments);
        CompactSegments serdeCompactSegments = (CompactSegments)JSON_MAPPER.readValue(compactSegmentString, CompactSegments.class);
        Assert.assertNotNull((Object)serdeCompactSegments);
        Assert.assertEquals((Object)COORDINATOR_CONFIG.getCompactionSkipLockedIntervals(), (Object)serdeCompactSegments.isSkipLockedIntervals());
        Assert.assertEquals((Object)indexingServiceClient, (Object)serdeCompactSegments.getIndexingServiceClient());
    }

    @Test
    public void testRun() {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        Supplier<String> expectedVersionSupplier = new Supplier<String>(){
            private int i = 0;

            @Override
            public String get() {
                return "newVersion_" + this.i++;
            }
        };
        int expectedCompactTaskCount = 1;
        int expectedRemainingSegments = 400;
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{9, 9}), expectedRemainingSegments, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{8, 9}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{8, 8}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{4, 5}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        for (int endDay = 4; endDay > 1; --endDay) {
            this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT00:00:00/2017-01-%02dT12:00:00", (Object[])new Object[]{endDay, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
            this.assertCompactSegments(compactSegments, Intervals.of((String)"2017-01-%02dT12:00:00/2017-01-%02dT00:00:00", (Object[])new Object[]{endDay - 1, endDay}), expectedRemainingSegments -= 40, expectedCompactTaskCount, expectedVersionSupplier);
        }
        this.assertLastSegmentNotCompacted(compactSegments);
    }

    @Test
    public void testMakeStats() {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 11; ++compactionRunCount) {
            this.doCompactionAndAssertCompactSegmentStatistics(compactSegments, compactionRunCount);
        }
        CoordinatorStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.getGlobalStat("compactTaskCount"));
        for (int i = 0; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        List<DataSourceCompactionConfig> removedOneConfig = this.createCompactionConfigs();
        removedOneConfig.remove(0);
        this.doCompactSegments(compactSegments, removedOneConfig);
        for (int i = 1; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        this.doCompactSegments(compactSegments, new ArrayList<DataSourceCompactionConfig>());
        Assert.assertEquals((long)0L, (long)stats.getGlobalStat("compactTaskCount"));
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().isEmpty());
        this.assertLastSegmentNotCompacted(compactSegments);
    }

    @Test
    public void testMakeStatsForDataSourceWithCompactedIntervalBetweenNonCompactedIntervals() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
            for (int k = 0; k < 4; ++k) {
                DataSegment beforeNoon = this.createSegment(dataSourceName, j, true, k);
                DataSegment afterNoon = this.createSegment(dataSourceName, j, false, k);
                if (j == 3) {
                    beforeNoon = beforeNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                    afterNoon = afterNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                }
                if (j == 1) {
                    afterNoon = afterNoon.withLastCompactionState(new CompactionState(this.partitionsSpec, null, null, null, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
                }
                segments.add(beforeNoon);
                segments.add(afterNoon);
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 8; ++compactionRunCount) {
            CoordinatorStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 320 - 40 * (compactionRunCount + 1), 120 + 40 * (compactionRunCount + 1), 40L, 8 - (compactionRunCount + 1), 3 + (compactionRunCount + 1), 1L, 32 - 4 * (compactionRunCount + 1), 16 + 2 * compactionRunCount, 4L);
        }
        CoordinatorStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.getGlobalStat("compactTaskCount"));
        this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 28L, 4L);
    }

    @Test
    public void testMakeStatsWithDeactivatedDatasource() {
        int i;
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 11; ++compactionRunCount) {
            this.doCompactionAndAssertCompactSegmentStatistics(compactSegments, compactionRunCount);
        }
        CoordinatorStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.getGlobalStat("compactTaskCount"));
        for (i = 0; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        this.dataSources.remove("dataSource_0");
        this.doCompactSegments(compactSegments);
        for (i = 1; i < 3; ++i) {
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 0L, 440L, 40L, 0L, 11L, 1L, 0L, 22L, 4L);
        }
        Assert.assertEquals((long)2L, (long)compactSegments.getAutoCompactionSnapshot().size());
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_1"));
        Assert.assertTrue((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_2"));
        Assert.assertFalse((boolean)compactSegments.getAutoCompactionSnapshot().containsKey("dataSource_0"));
    }

    @Test
    public void testMakeStatsForDataSourceWithSkipped() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        for (int j : new int[]{0, 1, 2, 3, 7, 8}) {
            for (int k = 0; k < 4; ++k) {
                DataSegment beforeNoon = this.createSegment(dataSourceName, j, true, k);
                DataSegment afterNoon = this.createSegment(dataSourceName, j, false, k);
                if (j == 3) {
                    beforeNoon = beforeNoon.withSize(100L);
                    afterNoon = afterNoon.withSize(100L);
                }
                if (j == 1) {
                    afterNoon = afterNoon.withSize(100L);
                }
                segments.add(beforeNoon);
                segments.add(afterNoon);
            }
        }
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        Assert.assertEquals((long)0L, (long)autoCompactionSnapshots.size());
        for (int compactionRunCount = 0; compactionRunCount < 8; ++compactionRunCount) {
            CoordinatorStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
            this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 320 - 40 * (compactionRunCount + 1), 40 * (compactionRunCount + 1), 1240L, 8 - (compactionRunCount + 1), compactionRunCount + 1, 4L, 32 - 4 * (compactionRunCount + 1), 4 + 2 * compactionRunCount, 16L);
        }
        CoordinatorStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)0L, (long)stats.getGlobalStat("compactTaskCount"));
        this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, dataSourceName, 0L, 320L, 1240L, 0L, 8L, 4L, 0L, 16L, 16L);
    }

    @Test
    public void testRunMultipleCompactionTaskSlots() {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        CoordinatorStats stats = this.doCompactSegments(compactSegments, 3);
        Assert.assertEquals((long)3L, (long)stats.getGlobalStat("availableCompactionTaskSlot"));
        Assert.assertEquals((long)3L, (long)stats.getGlobalStat("maxCompactionTaskSlot"));
        Assert.assertEquals((long)3L, (long)stats.getGlobalStat("compactTaskCount"));
    }

    @Test
    public void testRunMultipleCompactionTaskSlotsWithUseAutoScaleSlotsOverMaxSlot() {
        int maxCompactionSlot = 3;
        Assert.assertTrue((maxCompactionSlot < 10 ? 1 : 0) != 0);
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        CoordinatorStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(), maxCompactionSlot, true);
        Assert.assertEquals((long)maxCompactionSlot, (long)stats.getGlobalStat("availableCompactionTaskSlot"));
        Assert.assertEquals((long)maxCompactionSlot, (long)stats.getGlobalStat("maxCompactionTaskSlot"));
        Assert.assertEquals((long)maxCompactionSlot, (long)stats.getGlobalStat("compactTaskCount"));
    }

    @Test
    public void testRunMultipleCompactionTaskSlotsWithUseAutoScaleSlotsUnderMaxSlot() {
        int maxCompactionSlot = 100;
        Assert.assertFalse((maxCompactionSlot < 10 ? 1 : 0) != 0);
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        CoordinatorStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(), maxCompactionSlot, true);
        Assert.assertEquals((long)10L, (long)stats.getGlobalStat("availableCompactionTaskSlot"));
        Assert.assertEquals((long)10L, (long)stats.getGlobalStat("maxCompactionTaskSlot"));
        Assert.assertEquals((long)10L, (long)stats.getGlobalStat("compactTaskCount"));
    }

    @Test
    public void testCompactWithoutGranularitySpec() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)4L, (long)((List)segmentsCaptor.getValue()).size());
        Assert.assertNull((Object)((ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue()).getSegmentGranularity());
        Assert.assertNull((Object)((ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue()).getQueryGranularity());
        Assert.assertNull((Object)((ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue()).isRollup());
    }

    @Test
    public void testCompactWithNotNullIOConfig() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, new UserCompactionTaskIOConfig(Boolean.valueOf(true)), null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor dropExistingCapture = ArgumentCaptor.forClass(Boolean.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)dropExistingCapture.capture(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((Object)true, (Object)dropExistingCapture.getValue());
    }

    @Test
    public void testCompactWithNullIOConfig() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor dropExistingCapture = ArgumentCaptor.forClass(Boolean.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)dropExistingCapture.capture(), (Map)ArgumentMatchers.any());
        Assert.assertNull((Object)dropExistingCapture.getValue());
    }

    @Test
    public void testCompactWithGranularitySpec() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)this.datasourceToSegments.get("dataSource_0").size(), (long)((List)segmentsCaptor.getValue()).size());
        ClientCompactionTaskGranularitySpec actual = (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        ClientCompactionTaskGranularitySpec expected = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCompactWithDimensionSpec() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor dimensionsSpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskDimensionsSpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)dimensionsSpecArgumentCaptor.capture(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ClientCompactionTaskDimensionsSpec actual = (ClientCompactionTaskDimensionsSpec)dimensionsSpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo")), (Object)actual.getDimensions());
    }

    @Test
    public void testCompactWithoutDimensionSpec() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor dimensionsSpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskDimensionsSpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)dimensionsSpecArgumentCaptor.capture(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ClientCompactionTaskDimensionsSpec actual = (ClientCompactionTaskDimensionsSpec)dimensionsSpecArgumentCaptor.getValue();
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testCompactWithRollupInGranularitySpec() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, Boolean.valueOf(true)), null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)this.datasourceToSegments.get("dataSource_0").size(), (long)((List)segmentsCaptor.getValue()).size());
        ClientCompactionTaskGranularitySpec actual = (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        ClientCompactionTaskGranularitySpec expected = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, Boolean.valueOf(true));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCompactWithGranularitySpecConflictWithActiveCompactionTask() {
        String dataSource = "dataSource_0";
        String conflictTaskId = "taskIdDummy";
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        TaskStatusPlus runningConflictCompactionTask = new TaskStatusPlus("taskIdDummy", "groupId", "compact", DateTimes.EPOCH, DateTimes.EPOCH, TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(-1L), TaskLocation.unknown(), "dataSource_0", null);
        TaskPayloadResponse runningConflictCompactionTaskPayload = new TaskPayloadResponse("taskIdDummy", (ClientTaskQuery)new ClientCompactionTaskQuery("taskIdDummy", "dataSource_0", new ClientCompactionIOConfig(new ClientCompactionIntervalSpec(Intervals.of((String)"2000/2099"), "testSha256OfSortedSegmentIds"), null), null, new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null), null, null, null, null));
        Mockito.when((Object)mockIndexingServiceClient.getActiveTasks()).thenReturn((Object)ImmutableList.of((Object)runningConflictCompactionTask));
        Mockito.when((Object)mockIndexingServiceClient.getTaskPayload((String)ArgumentMatchers.eq((Object)"taskIdDummy"))).thenReturn((Object)runningConflictCompactionTaskPayload);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).cancelTask("taskIdDummy");
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)this.datasourceToSegments.get("dataSource_0").size(), (long)((List)segmentsCaptor.getValue()).size());
        ClientCompactionTaskGranularitySpec actual = (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        ClientCompactionTaskGranularitySpec expected = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testRunParallelCompactionMultipleCompactionTaskSlots() {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        CoordinatorStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(2), 4);
        Assert.assertEquals((long)4L, (long)stats.getGlobalStat("availableCompactionTaskSlot"));
        Assert.assertEquals((long)4L, (long)stats.getGlobalStat("maxCompactionTaskSlot"));
        Assert.assertEquals((long)2L, (long)stats.getGlobalStat("compactTaskCount"));
    }

    @Test
    public void testRunWithLockedIntervals() {
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        String datasource1 = "dataSource_1";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_1", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource2 = "dataSource_2";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_2", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource0 = "dataSource_0";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_0", k -> new ArrayList()).add(Intervals.of((String)"2017-01-01T13:00:00Z/2017-02-01"));
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        CoordinatorStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(2), 4);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
        Assert.assertEquals((long)1L, (long)leaderClient.submittedCompactionTasks.size());
        ClientCompactionTaskQuery compactionTask = (ClientCompactionTaskQuery)leaderClient.submittedCompactionTasks.get(0);
        Assert.assertEquals((Object)"dataSource_0", (Object)compactionTask.getDataSource());
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-01T00:00:00/2017-01-01T12:00:00"), (Object)compactionTask.getIoConfig().getInputSpec().getInterval());
    }

    @Test
    public void testCompactWithTransformSpec() {
        NullHandling.initializeForTests();
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, new UserCompactionTaskTransformConfig((DimFilter)new SelectorDimFilter("dim1", "foo", null)), null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor transformSpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskTransformSpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)transformSpecArgumentCaptor.capture(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ClientCompactionTaskTransformSpec actual = (ClientCompactionTaskTransformSpec)transformSpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertEquals((Object)new SelectorDimFilter("dim1", "foo", null), (Object)actual.getFilter());
    }

    @Test
    public void testCompactWithoutCustomSpecs() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor transformSpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskTransformSpec.class);
        ArgumentCaptor metricsSpecArgumentCaptor = ArgumentCaptor.forClass(AggregatorFactory[].class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])metricsSpecArgumentCaptor.capture(), (ClientCompactionTaskTransformSpec)transformSpecArgumentCaptor.capture(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        ClientCompactionTaskTransformSpec actualTransformSpec = (ClientCompactionTaskTransformSpec)transformSpecArgumentCaptor.getValue();
        Assert.assertNull((Object)actualTransformSpec);
        AggregatorFactory[] actualMetricsSpec = (AggregatorFactory[])metricsSpecArgumentCaptor.getValue();
        Assert.assertNull((Object)actualMetricsSpec);
    }

    @Test
    public void testCompactWithMetricsSpec() {
        NullHandling.initializeForTests();
        Object[] aggregatorFactories = new AggregatorFactory[]{new CountAggregatorFactory("cnt")};
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, (AggregatorFactory[])aggregatorFactories, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor metricsSpecArgumentCaptor = ArgumentCaptor.forClass(AggregatorFactory[].class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])metricsSpecArgumentCaptor.capture(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Object[] actual = (AggregatorFactory[])metricsSpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertArrayEquals((Object[])aggregatorFactories, (Object[])actual);
    }

    @Test
    public void testRunWithLockedIntervalsNoSkip() {
        Mockito.when((Object)COORDINATOR_CONFIG.getCompactionSkipLockedIntervals()).thenReturn((Object)false);
        TestDruidLeaderClient leaderClient = new TestDruidLeaderClient(JSON_MAPPER);
        leaderClient.start();
        HttpIndexingServiceClient indexingServiceClient = new HttpIndexingServiceClient(JSON_MAPPER, (DruidLeaderClient)leaderClient);
        String datasource0 = "dataSource_0";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_0", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource1 = "dataSource_1";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_1", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        String datasource2 = "dataSource_2";
        leaderClient.lockedIntervals.computeIfAbsent("dataSource_2", k -> new ArrayList()).add(Intervals.of((String)"2017/2018"));
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)indexingServiceClient);
        int maxTaskSlots = this.partitionsSpec instanceof SingleDimensionPartitionsSpec ? 5 : 3;
        CoordinatorStats stats = this.doCompactSegments(compactSegments, this.createCompactionConfigs(1), maxTaskSlots);
        Assert.assertEquals((long)3L, (long)stats.getGlobalStat("compactTaskCount"));
        Assert.assertEquals((long)3L, (long)leaderClient.submittedCompactionTasks.size());
        leaderClient.submittedCompactionTasks.forEach(task -> System.out.println(task.getDataSource() + " : " + task.getIoConfig().getInputSpec().getInterval()));
        HashMap datasourceToInterval = new HashMap();
        leaderClient.submittedCompactionTasks.forEach(task -> datasourceToInterval.put(task.getDataSource(), task.getIoConfig().getInputSpec().getInterval()));
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09T00:00:00Z/2017-01-09T12:00:00Z"), datasourceToInterval.get("dataSource_0"));
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09T00:00:00Z/2017-01-09T12:00:00Z"), datasourceToInterval.get("dataSource_1"));
        Assert.assertEquals((Object)Intervals.of((String)"2017-01-09T00:00:00Z/2017-01-09T12:00:00Z"), datasourceToInterval.get("dataSource_2"));
    }

    @Test
    public void testDetermineSegmentGranularityFromSegmentsToCompact() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(0, 2), Integer.valueOf(0), 10L));
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(1, 2), Integer.valueOf(0), 10L));
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig(dataSourceName, Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)2L, (long)((List)segmentsCaptor.getValue()).size());
        ClientCompactionTaskGranularitySpec actual = (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        ClientCompactionTaskGranularitySpec expected = new ClientCompactionTaskGranularitySpec(Granularities.DAY, null, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDetermineSegmentGranularityFromSegmentGranularityInCompactionConfig() {
        String dataSourceName = "dataSource_1";
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(0, 2), Integer.valueOf(0), 10L));
        segments.add(new DataSegment(dataSourceName, Intervals.of((String)"2017-01-01T00:00:00/2017-01-02T00:00:00"), "1", null, (List)ImmutableList.of(), (List)ImmutableList.of(), this.shardSpecFactory.apply(1, 2), Integer.valueOf(0), 10L));
        this.dataSources = DataSourcesSnapshot.fromUsedSegments(segments, (ImmutableMap)ImmutableMap.of()).getUsedSegmentsTimelinesPerDataSource();
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        compactionConfigs.add(new DataSourceCompactionConfig(dataSourceName, Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor segmentsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor granularitySpecArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskGranularitySpec.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)segmentsCaptor.capture(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)ArgumentMatchers.any(), (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.capture(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertEquals((long)2L, (long)((List)segmentsCaptor.getValue()).size());
        ClientCompactionTaskGranularitySpec actual = (ClientCompactionTaskGranularitySpec)granularitySpecArgumentCaptor.getValue();
        Assert.assertNotNull((Object)actual);
        ClientCompactionTaskGranularitySpec expected = new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testCompactWithMetricsSpecShouldSetPreserveExistingMetricsTrue() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor clientCompactionTaskQueryTuningConfigArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskQueryTuningConfig.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.capture(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertNotNull((Object)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue());
        Assert.assertNotNull((Object)((ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue()).getAppendableIndexSpec());
        Assert.assertTrue((boolean)((OnheapIncrementalIndex.Spec)((ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue()).getAppendableIndexSpec()).isPreserveExistingMetrics());
    }

    @Test
    public void testCompactWithoutMetricsSpecShouldSetPreserveExistingMetricsFalse() {
        HttpIndexingServiceClient mockIndexingServiceClient = (HttpIndexingServiceClient)Mockito.mock(HttpIndexingServiceClient.class);
        CompactSegments compactSegments = new CompactSegments(COORDINATOR_CONFIG, JSON_MAPPER, (IndexingServiceClient)mockIndexingServiceClient);
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        String dataSource = "dataSource_0";
        compactionConfigs.add(new DataSourceCompactionConfig("dataSource_0", Integer.valueOf(0), Long.valueOf(500L), null, new Period((Object)"PT0H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, Integer.valueOf(3), null, null, null, null, null, null, null), null, null, null, null, null, null));
        this.doCompactSegments(compactSegments, compactionConfigs);
        ArgumentCaptor clientCompactionTaskQueryTuningConfigArgumentCaptor = ArgumentCaptor.forClass(ClientCompactionTaskQueryTuningConfig.class);
        ((HttpIndexingServiceClient)Mockito.verify((Object)mockIndexingServiceClient)).compactSegments(ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.capture(), (ClientCompactionTaskGranularitySpec)ArgumentMatchers.any(), (ClientCompactionTaskDimensionsSpec)ArgumentMatchers.any(), (AggregatorFactory[])ArgumentMatchers.any(), (ClientCompactionTaskTransformSpec)ArgumentMatchers.any(), (Boolean)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Assert.assertNotNull((Object)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue());
        Assert.assertNotNull((Object)((ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue()).getAppendableIndexSpec());
        Assert.assertFalse((boolean)((OnheapIncrementalIndex.Spec)((ClientCompactionTaskQueryTuningConfig)clientCompactionTaskQueryTuningConfigArgumentCaptor.getValue()).getAppendableIndexSpec()).isPreserveExistingMetrics());
    }

    private void verifySnapshot(CompactSegments compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus scheduleStatus, String dataSourceName, long expectedByteCountAwaitingCompaction, long expectedByteCountCompressed, long expectedByteCountSkipped, long expectedIntervalCountAwaitingCompaction, long expectedIntervalCountCompressed, long expectedIntervalCountSkipped, long expectedSegmentCountAwaitingCompaction, long expectedSegmentCountCompressed, long expectedSegmentCountSkipped) {
        Map autoCompactionSnapshots = compactSegments.getAutoCompactionSnapshot();
        AutoCompactionSnapshot snapshot = (AutoCompactionSnapshot)autoCompactionSnapshots.get(dataSourceName);
        Assert.assertEquals((Object)dataSourceName, (Object)snapshot.getDataSource());
        Assert.assertEquals((Object)scheduleStatus, (Object)snapshot.getScheduleStatus());
        Assert.assertEquals((long)expectedByteCountAwaitingCompaction, (long)snapshot.getBytesAwaitingCompaction());
        Assert.assertEquals((long)expectedByteCountCompressed, (long)snapshot.getBytesCompacted());
        Assert.assertEquals((long)expectedByteCountSkipped, (long)snapshot.getBytesSkipped());
        Assert.assertEquals((long)expectedIntervalCountAwaitingCompaction, (long)snapshot.getIntervalCountAwaitingCompaction());
        Assert.assertEquals((long)expectedIntervalCountCompressed, (long)snapshot.getIntervalCountCompacted());
        Assert.assertEquals((long)expectedIntervalCountSkipped, (long)snapshot.getIntervalCountSkipped());
        Assert.assertEquals((long)expectedSegmentCountAwaitingCompaction, (long)snapshot.getSegmentCountAwaitingCompaction());
        Assert.assertEquals((long)expectedSegmentCountCompressed, (long)snapshot.getSegmentCountCompacted());
        Assert.assertEquals((long)expectedSegmentCountSkipped, (long)snapshot.getSegmentCountSkipped());
    }

    private void doCompactionAndAssertCompactSegmentStatistics(CompactSegments compactSegments, int compactionRunCount) {
        for (int dataSourceIndex = 0; dataSourceIndex < 3; ++dataSourceIndex) {
            int i;
            CoordinatorStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
            for (i = 0; i <= dataSourceIndex; ++i) {
                if (i != dataSourceIndex) {
                    this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440 - 40 * (compactionRunCount + 1), 40 * (compactionRunCount + 1), 40L, 11 - (compactionRunCount + 1), compactionRunCount + 1, 1L, 44 - 4 * (compactionRunCount + 1), 2 * (compactionRunCount + 1), 4L);
                    continue;
                }
                this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440 - 40 * (compactionRunCount + 1), 40 * (compactionRunCount + 1), 40L, 11 - (compactionRunCount + 1), compactionRunCount + 1, 1L, 44 - 4 * (compactionRunCount + 1), 2 * compactionRunCount + 4, 4L);
            }
            for (i = dataSourceIndex + 1; i < 3; ++i) {
                this.verifySnapshot(compactSegments, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, DATA_SOURCE_PREFIX + i, 440 - 40 * compactionRunCount, 40 * compactionRunCount, 40L, 11 - compactionRunCount, compactionRunCount, 1L, 44 - 4 * compactionRunCount, 2 * compactionRunCount, 4L);
            }
        }
    }

    private CoordinatorStats doCompactSegments(CompactSegments compactSegments) {
        return this.doCompactSegments(compactSegments, (Integer)null);
    }

    private CoordinatorStats doCompactSegments(CompactSegments compactSegments, @Nullable Integer numCompactionTaskSlots) {
        return this.doCompactSegments(compactSegments, this.createCompactionConfigs(), numCompactionTaskSlots);
    }

    private CoordinatorStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs) {
        return this.doCompactSegments(compactSegments, compactionConfigs, null);
    }

    private CoordinatorStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs, @Nullable Integer numCompactionTaskSlots) {
        return this.doCompactSegments(compactSegments, compactionConfigs, numCompactionTaskSlots, false);
    }

    private CoordinatorStats doCompactSegments(CompactSegments compactSegments, List<DataSourceCompactionConfig> compactionConfigs, @Nullable Integer numCompactionTaskSlots, boolean useAutoScaleSlots) {
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withUsedSegmentsTimelinesPerDataSourceInTest(this.dataSources).withCompactionConfig(new CoordinatorCompactionConfig(compactionConfigs, numCompactionTaskSlots == null ? null : Double.valueOf(1.0), numCompactionTaskSlots, Boolean.valueOf(useAutoScaleSlots))).build();
        return compactSegments.run(params).getCoordinatorStats();
    }

    private void assertCompactSegments(CompactSegments compactSegments, Interval expectedInterval, int expectedRemainingSegments, int expectedCompactTaskCount, Supplier<String> expectedVersionSupplier) {
        int i;
        for (i = 0; i < 3; ++i) {
            CoordinatorStats stats = this.doCompactSegments(compactSegments);
            Assert.assertEquals((long)expectedCompactTaskCount, (long)stats.getGlobalStat("compactTaskCount"));
            if (expectedRemainingSegments > 0) {
                long numDataSourceOfExpectedRemainingSegments = stats.getDataSources("segmentSizeWaitCompact").stream().mapToLong(ds -> stats.getDataSourceStat("segmentSizeWaitCompact", ds)).filter(stat -> stat == (long)expectedRemainingSegments).count();
                Assert.assertEquals((long)(i + 1), (long)numDataSourceOfExpectedRemainingSegments);
                continue;
            }
            Assert.assertEquals((long)(2 - i), (long)stats.getDataSources("segmentSizeWaitCompact").size());
        }
        for (i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            List holders = this.dataSources.get(dataSource).lookup(expectedInterval);
            Assert.assertEquals((long)1L, (long)holders.size());
            ArrayList chunks = Lists.newArrayList((Iterable)((TimelineObjectHolder)holders.get(0)).getObject());
            Assert.assertEquals((long)2L, (long)chunks.size());
            String expectedVersion = expectedVersionSupplier.get();
            for (PartitionChunk chunk : chunks) {
                Assert.assertEquals((Object)expectedInterval, (Object)((DataSegment)chunk.getObject()).getInterval());
                Assert.assertEquals((Object)expectedVersion, (Object)((DataSegment)chunk.getObject()).getVersion());
            }
        }
    }

    private void assertLastSegmentNotCompacted(CompactSegments compactSegments) {
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            Interval interval = Intervals.of((String)StringUtils.format((String)"2017-01-09T12:00:00/2017-01-10", (Object[])new Object[0]));
            List holders = this.dataSources.get(dataSource).lookup(interval);
            Assert.assertEquals((long)1L, (long)holders.size());
            for (TimelineObjectHolder holder : holders) {
                ArrayList chunks = Lists.newArrayList((Iterable)holder.getObject());
                Assert.assertEquals((long)4L, (long)chunks.size());
                for (PartitionChunk chunk : chunks) {
                    DataSegment segment = (DataSegment)chunk.getObject();
                    Assert.assertEquals((Object)interval, (Object)segment.getInterval());
                    Assert.assertEquals((Object)"version", (Object)segment.getVersion());
                }
            }
        }
        String dataSource = "dataSource_0";
        this.addMoreData("dataSource_0", 9);
        CoordinatorStats stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
        this.addMoreData("dataSource_0", 10);
        stats = this.doCompactSegments(compactSegments);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("compactTaskCount"));
    }

    private void addMoreData(String dataSource, int day) {
        for (int i = 0; i < 2; ++i) {
            DataSegment newSegment = this.createSegment(dataSource, day, true, i);
            this.dataSources.get(dataSource).add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
            newSegment = this.createSegment(dataSource, day, false, i);
            this.dataSources.get(dataSource).add(newSegment.getInterval(), (Object)newSegment.getVersion(), newSegment.getShardSpec().createChunk((Object)newSegment));
        }
    }

    private List<DataSourceCompactionConfig> createCompactionConfigs() {
        return this.createCompactionConfigs(null);
    }

    private List<DataSourceCompactionConfig> createCompactionConfigs(@Nullable Integer maxNumConcurrentSubTasks) {
        ArrayList<DataSourceCompactionConfig> compactionConfigs = new ArrayList<DataSourceCompactionConfig>();
        for (int i = 0; i < 3; ++i) {
            String dataSource = DATA_SOURCE_PREFIX + i;
            compactionConfigs.add(new DataSourceCompactionConfig(dataSource, Integer.valueOf(0), Long.valueOf(50L), null, new Period((Object)"PT1H"), new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, this.partitionsSpec, null, null, null, null, null, maxNumConcurrentSubTasks, null, null, null, null, null, null, null), null, null, null, null, null, null));
        }
        return compactionConfigs;
    }

    public static class StaticUtilsTest {
        @Test
        public void testIsParalleModeNullTuningConfigReturnFalse() {
            Assert.assertFalse((boolean)CompactSegments.isParallelMode(null));
        }

        @Test
        public void testIsParallelModeNullPartitionsSpecReturnFalse() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeNonRangePartitionVaryingMaxNumConcurrentSubTasks() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(Mockito.mock(PartitionsSpec.class));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testIsParallelModeRangePartitionVaryingMaxNumConcurrentSubTasks() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(Mockito.mock(SingleDimensionPartitionsSpec.class));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn(null);
            Assert.assertFalse((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertTrue((boolean)CompactSegments.isParallelMode((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testFindMaxNumTaskSlotsUsedByOneCompactionTaskWhenIsParallelMode() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(Mockito.mock(PartitionsSpec.class));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)2);
            Assert.assertEquals((long)3L, (long)CompactSegments.findMaxNumTaskSlotsUsedByOneCompactionTask((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }

        @Test
        public void testFindMaxNumTaskSlotsUsedByOneCompactionTaskWhenIsSequentialMode() {
            ClientCompactionTaskQueryTuningConfig tuningConfig = (ClientCompactionTaskQueryTuningConfig)Mockito.mock(ClientCompactionTaskQueryTuningConfig.class);
            Mockito.when((Object)tuningConfig.getPartitionsSpec()).thenReturn(Mockito.mock(PartitionsSpec.class));
            Mockito.when((Object)tuningConfig.getMaxNumConcurrentSubTasks()).thenReturn((Object)1);
            Assert.assertEquals((long)1L, (long)CompactSegments.findMaxNumTaskSlotsUsedByOneCompactionTask((ClientCompactionTaskQueryTuningConfig)tuningConfig));
        }
    }

    private static class TestNodeDiscoveryProvider
    extends DruidNodeDiscoveryProvider {
        private TestNodeDiscoveryProvider() {
        }

        public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
            throw new UnsupportedOperationException();
        }

        public DruidNodeDiscovery getForNodeRole(NodeRole nodeRole) {
            return (DruidNodeDiscovery)EasyMock.niceMock(DruidNodeDiscovery.class);
        }
    }

    private class TestDruidLeaderClient
    extends DruidLeaderClient {
        private final ObjectMapper jsonMapper;
        private final Map<String, List<Interval>> lockedIntervals;
        private final List<ClientCompactionTaskQuery> submittedCompactionTasks;
        private int compactVersionSuffix;

        private TestDruidLeaderClient(ObjectMapper jsonMapper) {
            super(null, (DruidNodeDiscoveryProvider)new TestNodeDiscoveryProvider(), null, null);
            this.lockedIntervals = new HashMap<String, List<Interval>>();
            this.submittedCompactionTasks = new ArrayList<ClientCompactionTaskQuery>();
            this.compactVersionSuffix = 0;
            this.jsonMapper = jsonMapper;
        }

        public Request makeRequest(HttpMethod httpMethod, String urlPath) throws IOException {
            return new Request(httpMethod, new URL("http", "host", 8090, urlPath));
        }

        public StringFullResponseHolder go(Request request) throws IOException {
            String urlString = request.getUrl().toString();
            if (urlString.contains("/druid/indexer/v1/task")) {
                return this.handleTask(request);
            }
            if (urlString.contains("/druid/indexer/v1/workers")) {
                return this.handleWorkers();
            }
            if (urlString.contains("/druid/indexer/v1/totalWorkerCapacity")) {
                return this.handleTotalWorkerCapacity();
            }
            if (urlString.contains("/druid/indexer/v1/waitingTasks") || urlString.contains("/druid/indexer/v1/pendingTasks") || urlString.contains("/druid/indexer/v1/runningTasks")) {
                return this.createStringFullResponseHolder(this.jsonMapper.writeValueAsString(Collections.emptyList()));
            }
            if (urlString.contains("/druid/indexer/v1/lockedIntervals")) {
                return this.handleLockedIntervals();
            }
            throw new IAE("Cannot handle request for url[%s]", new Object[]{request.getUrl()});
        }

        private StringFullResponseHolder createStringFullResponseHolder(String content) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            StringFullResponseHolder holder = new StringFullResponseHolder((HttpResponse)httpResponse, StandardCharsets.UTF_8);
            holder.addChunk(content);
            return holder;
        }

        private StringFullResponseHolder handleWorkers() throws JsonProcessingException {
            ArrayList<IndexingWorkerInfo> workerInfos = new ArrayList<IndexingWorkerInfo>();
            for (int i = 0; i < 10; ++i) {
                workerInfos.add(new IndexingWorkerInfo(new IndexingWorker("http", "host", "8091", 1, "version"), 0, Collections.emptySet(), Collections.emptyList(), DateTimes.EPOCH, null));
            }
            return this.createStringFullResponseHolder(this.jsonMapper.writeValueAsString(workerInfos));
        }

        private StringFullResponseHolder handleTotalWorkerCapacity() throws JsonProcessingException {
            IndexingTotalWorkerCapacityInfo info = new IndexingTotalWorkerCapacityInfo(5, 10);
            return this.createStringFullResponseHolder(this.jsonMapper.writeValueAsString((Object)info));
        }

        private StringFullResponseHolder handleTask(Request request) throws IOException {
            ClientTaskQuery taskQuery = (ClientTaskQuery)this.jsonMapper.readValue(request.getContent().array(), ClientTaskQuery.class);
            if (!(taskQuery instanceof ClientCompactionTaskQuery)) {
                throw new IAE("Cannot run non-compaction task", new Object[0]);
            }
            ClientCompactionTaskQuery compactionTaskQuery = (ClientCompactionTaskQuery)taskQuery;
            this.submittedCompactionTasks.add(compactionTaskQuery);
            Interval intervalToCompact = compactionTaskQuery.getIoConfig().getInputSpec().getInterval();
            VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)CompactSegmentsTest.this.dataSources.get(compactionTaskQuery.getDataSource());
            List<DataSegment> segments = timeline.lookup(intervalToCompact).stream().flatMap(holder -> Streams.sequentialStreamFrom((Iterable)holder.getObject())).map(PartitionChunk::getObject).collect(Collectors.toList());
            this.compactSegments((VersionedIntervalTimeline<String, DataSegment>)timeline, segments, compactionTaskQuery);
            return this.createStringFullResponseHolder(this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"task", (Object)taskQuery.getId())));
        }

        private StringFullResponseHolder handleLockedIntervals() throws IOException {
            return this.createStringFullResponseHolder(this.jsonMapper.writeValueAsString(this.lockedIntervals));
        }

        private void compactSegments(VersionedIntervalTimeline<String, DataSegment> timeline, List<DataSegment> segments, ClientCompactionTaskQuery clientCompactionTaskQuery) {
            Preconditions.checkArgument((segments.size() > 1 ? 1 : 0) != 0);
            DateTime minStart = DateTimes.MAX;
            DateTime maxEnd = DateTimes.MIN;
            for (DataSegment segment2 : segments) {
                if (segment2.getInterval().getStart().compareTo((ReadableInstant)minStart) < 0) {
                    minStart = segment2.getInterval().getStart();
                }
                if (segment2.getInterval().getEnd().compareTo((ReadableInstant)maxEnd) <= 0) continue;
                maxEnd = segment2.getInterval().getEnd();
            }
            Interval compactInterval = new Interval((ReadableInstant)minStart, (ReadableInstant)maxEnd);
            segments.forEach(segment -> timeline.remove(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk(segment)));
            String version = "newVersion_" + this.compactVersionSuffix++;
            long segmentSize = segments.stream().mapToLong(DataSegment::getSize).sum() / 2L;
            Object compactionPartitionsSpec = clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec() instanceof DynamicPartitionsSpec ? new DynamicPartitionsSpec(clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec().getMaxRowsPerSegment(), Long.valueOf(((DynamicPartitionsSpec)clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec()).getMaxTotalRowsOr(Long.MAX_VALUE))) : clientCompactionTaskQuery.getTuningConfig().getPartitionsSpec();
            Map transformSpec = null;
            try {
                if (clientCompactionTaskQuery.getTransformSpec() != null) {
                    transformSpec = (Map)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)new TransformSpec(clientCompactionTaskQuery.getTransformSpec().getFilter(), null)), (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
            }
            catch (JsonProcessingException e) {
                throw new IAE("Invalid Json payload", new Object[0]);
            }
            List metricsSpec = null;
            if (clientCompactionTaskQuery.getMetricsSpec() != null) {
                metricsSpec = (List)this.jsonMapper.convertValue((Object)clientCompactionTaskQuery.getMetricsSpec(), (TypeReference)new TypeReference<List<Object>>(){});
            }
            for (int i = 0; i < 2; ++i) {
                DataSegment compactSegment = new DataSegment(segments.get(0).getDataSource(), compactInterval, version, null, segments.get(0).getDimensions(), segments.get(0).getMetrics(), (ShardSpec)CompactSegmentsTest.this.shardSpecFactory.apply(i, 2), new CompactionState(compactionPartitionsSpec, clientCompactionTaskQuery.getDimensionsSpec() == null ? null : new DimensionsSpec(clientCompactionTaskQuery.getDimensionsSpec().getDimensions()), metricsSpec, transformSpec, (Map)ImmutableMap.of((Object)"bitmap", (Object)ImmutableMap.of((Object)"type", (Object)"roaring", (Object)"compressRunOnSerialization", (Object)true), (Object)"dimensionCompression", (Object)"lz4", (Object)"metricCompression", (Object)"lz4", (Object)"longEncoding", (Object)"longs"), (Map)ImmutableMap.of()), Integer.valueOf(1), segmentSize);
                timeline.add(compactInterval, (Object)compactSegment.getVersion(), compactSegment.getShardSpec().createChunk((Object)compactSegment));
            }
        }
    }
}

