/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.duty.KillCompactionConfig;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class KillCompactionConfigTest {
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Mock
    private SqlSegmentsMetadataManager mockSqlSegmentsMetadataManager;
    @Mock
    private JacksonConfigManager mockJacksonConfigManager;
    @Mock
    private MetadataStorageConnector mockConnector;
    @Mock
    private MetadataStorageTablesConfig mockConnectorConfig;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillCompactionConfig killCompactionConfig;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockConnectorConfig.getConfigTable()).thenReturn((Object)"druid_config");
    }

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorCompactionKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killCompactionConfig = new KillCompactionConfig((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockSqlSegmentsMetadataManager, this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockServiceEmitter});
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorCompactionKillPeriod(new Duration((Object)"PT3S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Coordinator compaction configuration kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.killCompactionConfig = new KillCompactionConfig((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockSqlSegmentsMetadataManager, this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
    }

    @Test
    public void testRunDoNothingIfCurrentConfigIsEmpty() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn(null);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)CoordinatorCompactionConfig.empty());
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorCompactionKillPeriod(new Duration((Object)"PT6S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killCompactionConfig = new KillCompactionConfig((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockSqlSegmentsMetadataManager, this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
        ArgumentCaptor emittedEventCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)emittedEventCaptor.capture());
        Assert.assertEquals((Object)"metadata/kill/compaction/count", (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)0, (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"value"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector)).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
    }

    @Test
    public void testRunRemoveInactiveDatasourceCompactionConfig() {
        String inactiveDatasourceName = "inactive_datasource";
        String activeDatasourceName = "active_datasource";
        DataSourceCompactionConfig inactiveDatasourceConfig = new DataSourceCompactionConfig(inactiveDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        DataSourceCompactionConfig activeDatasourceConfig = new DataSourceCompactionConfig(activeDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        CoordinatorCompactionConfig originalCurrentConfig = CoordinatorCompactionConfig.from((List)ImmutableList.of((Object)inactiveDatasourceConfig, (Object)activeDatasourceConfig));
        byte[] originalCurrentConfigBytes = new byte[]{1, 2, 3};
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn((Object)originalCurrentConfigBytes);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)originalCurrentConfig);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        Mockito.when((Object)this.mockSqlSegmentsMetadataManager.retrieveAllDataSourceNames()).thenReturn((Object)ImmutableSet.of((Object)activeDatasourceName));
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorCompactionKillPeriod(new Duration((Object)"PT6S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killCompactionConfig = new KillCompactionConfig((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockSqlSegmentsMetadataManager, this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        Assert.assertNotNull((Object)oldConfigCaptor.getValue());
        Assert.assertEquals((Object)oldConfigCaptor.getValue(), (Object)originalCurrentConfigBytes);
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)1L, (long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().size());
        Assert.assertEquals((Object)activeDatasourceConfig, ((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().get(0));
        ArgumentCaptor emittedEventCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)emittedEventCaptor.capture());
        Assert.assertEquals((Object)"metadata/kill/compaction/count", (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1, (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"value"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector)).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager)).set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(CoordinatorCompactionConfig.class), (AuditInfo)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        ((SqlSegmentsMetadataManager)Mockito.verify((Object)this.mockSqlSegmentsMetadataManager)).retrieveAllDataSourceNames();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
    }

    @Test
    public void testRunRetryForRetryableException() {
        String inactiveDatasourceName = "inactive_datasource";
        DataSourceCompactionConfig inactiveDatasourceConfig = new DataSourceCompactionConfig(inactiveDatasourceName, null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        CoordinatorCompactionConfig originalCurrentConfig = CoordinatorCompactionConfig.from((List)ImmutableList.of((Object)inactiveDatasourceConfig));
        byte[] originalCurrentConfigBytes = new byte[]{1, 2, 3};
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn((Object)originalCurrentConfigBytes);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)originalCurrentConfig);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        Mockito.when((Object)this.mockSqlSegmentsMetadataManager.retrieveAllDataSourceNames()).thenReturn((Object)ImmutableSet.of());
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(CoordinatorCompactionConfig.class), (AuditInfo)ArgumentMatchers.any())).thenAnswer(new Answer(){
            private int count = 0;

            public Object answer(InvocationOnMock invocation) {
                if (this.count++ < 3) {
                    return ConfigManager.SetResult.fail((Exception)new Exception(), (boolean)true);
                }
                return ConfigManager.SetResult.ok();
            }
        });
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordinatorCompactionKillPeriod(new Duration((Object)"PT6S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killCompactionConfig = new KillCompactionConfig((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockSqlSegmentsMetadataManager, this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
        this.killCompactionConfig.run(this.mockDruidCoordinatorRuntimeParams);
        ArgumentCaptor emittedEventCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)emittedEventCaptor.capture());
        Assert.assertEquals((Object)"metadata/kill/compaction/count", (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1, (Object)((ServiceEventBuilder)emittedEventCaptor.getValue()).build(ImmutableMap.of()).toMap().get((Object)"value"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager, (VerificationMode)Mockito.times((int)4))).convertByteToConfig((byte[])ArgumentMatchers.eq((Object)originalCurrentConfigBytes), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()));
        ((MetadataStorageConnector)Mockito.verify((Object)this.mockConnector, (VerificationMode)Mockito.times((int)4))).lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"));
        ((JacksonConfigManager)Mockito.verify((Object)this.mockJacksonConfigManager, (VerificationMode)Mockito.times((int)4))).set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.any(CoordinatorCompactionConfig.class), (AuditInfo)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockJacksonConfigManager});
        ((SqlSegmentsMetadataManager)Mockito.verify((Object)this.mockSqlSegmentsMetadataManager, (VerificationMode)Mockito.times((int)4))).retrieveAllDataSourceNames();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSqlSegmentsMetadataManager});
    }
}

