/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.apache.druid.server.coordinator.duty.CompactionSegmentIterator;
import org.apache.druid.server.coordinator.duty.NewestSegmentFirstIterator;
import org.apache.druid.server.coordinator.duty.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.duty.SegmentCompactionUtil;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Test;

public class NewestSegmentFirstPolicyTest {
    private static final String DATA_SOURCE = "dataSource";
    private static final long DEFAULT_SEGMENT_SIZE = 1000L;
    private static final int DEFAULT_NUM_SEGMENTS_PER_SHARD = 4;
    private ObjectMapper mapper = new DefaultObjectMapper();
    private final NewestSegmentFirstPolicy policy = new NewestSegmentFirstPolicy(this.mapper);

    @Test
    public void testLargeOffsetAndSmallSegmentInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testSmallOffsetAndLargeSegmentInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1M"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T02:00:00/2017-11-17T03:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-16T06:00:00/2017-11-16T07:00:00"), true);
    }

    @Test
    public void testLargeGapInData() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1H1M"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-15T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-17T01:00:00/2017-11-17T02:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T06:00:00/2017-11-15T07:00:00"), true);
    }

    @Test
    public void testHugeShard() {
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P1D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-17T00:00:00/2017-11-18T03:00:00"), new Period((Object)"PT1H"), 200L, 4), new SegmentGenerateSpec(Intervals.of((String)"2017-11-09T00:00:00/2017-11-17T00:00:00"), new Period((Object)"P2D"), 13000L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-11-05T00:00:00/2017-11-09T00:00:00"), new Period((Object)"PT1H"), 200L, 4))), Collections.emptyMap());
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-11-05T00:00:00/2017-11-05T01:00:00"), lastInterval);
    }

    @Test
    public void testManySegmentsPerShard() {
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(800000L, new Period((Object)"P1D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-04T01:00:00/2017-12-05T03:00:00"), new Period((Object)"PT1H"), 375L, 80), new SegmentGenerateSpec(Intervals.of((String)"2017-12-04T00:00:00/2017-12-04T01:00:00"), new Period((Object)"PT1H"), 200L, 150), new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T18:00:00/2017-12-04T00:00:00"), new Period((Object)"PT6H"), 200000L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T11:00:00/2017-12-03T18:00:00"), new Period((Object)"PT1H"), 375L, 80))), Collections.emptyMap());
        Interval lastInterval = null;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            lastInterval = ((DataSegment)segments.get(0)).getInterval();
            Interval prevInterval = null;
            for (DataSegment segment : segments) {
                if (prevInterval != null && !prevInterval.getStart().equals((Object)segment.getInterval().getStart())) {
                    Assert.assertEquals((Object)prevInterval.getEnd(), (Object)segment.getInterval().getStart());
                }
                prevInterval = segment.getInterval();
            }
        }
        Assert.assertNotNull(lastInterval);
        Assert.assertEquals((Object)Intervals.of((String)"2017-12-03T11:00:00/2017-12-03T12:00:00"), lastInterval);
    }

    @Test
    public void testSkipUnknownDataSource() {
        String unknownDataSource = "unknown";
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)"unknown", (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D"), null), (Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P2D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), Collections.emptyMap());
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T00:00:00/2017-11-14T01:00:00"), Intervals.of((String)"2017-11-15T03:00:00/2017-11-15T04:00:00"), true);
    }

    @Test
    public void testClearSegmentsToCompactWhenSkippingSegments() {
        long inputSegmentSizeBytes = 800000L;
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-03T00:00:00/2017-12-04T00:00:00"), new Period((Object)"P1D"), 400010L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-02T00:00:00/2017-12-03T00:00:00"), new Period((Object)"P1D"), 800010L, 1), new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T00:00:00/2017-12-02T00:00:00"), new Period((Object)"P1D"), 266676L, 2));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(800000L, new Period((Object)"P0D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-03/2017-12-04"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact.sort(Comparator.naturalOrder());
        ArrayList expectedSegmentsToCompact2 = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01/2017-12-02"), Partitions.ONLY_COMPLETE));
        expectedSegmentsToCompact2.sort(Comparator.naturalOrder());
        Assertions.assertThat((Iterator)iterator).toIterable().containsExactly((Object[])new List[]{expectedSegmentsToCompact, expectedSegmentsToCompact2});
    }

    @Test
    public void testIfFirstSegmentIsInSkipOffset() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-02T14:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H"), 40000L, 1));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfFirstSegmentOverlapsSkipOffset() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T23:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H"), 40000L, 1));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularityEqual() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-30T23:00:00/2017-12-03T00:00:00"), new Period((Object)"P1D")), new SegmentGenerateSpec(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), new Period((Object)"P1D")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"), new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14T00:00:00/2017-12-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)ImmutableSet.copyOf((Iterator)iterator))));
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularityLarger() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-30T23:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H")), new SegmentGenerateSpec(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), new Period((Object)"PT5H")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"), new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        List actual = (List)iterator.next();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIfSegmentsSkipOffsetWithConfiguredSegmentGranularitySmaller() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T23:00:00/2017-12-03T00:00:00"), new Period((Object)"PT5H")), new SegmentGenerateSpec(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), new Period((Object)"PT5H")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P1D"), new UserCompactionTaskGranularityConfig(Granularities.MINUTE, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-14T00:00:00/2017-10-15T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)ImmutableSet.copyOf((Iterator)iterator))));
    }

    @Test
    public void testWithSkipIntervals() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"P1D"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T20:00:00/2017-11-17T04:00:00"), segmentPeriod), new SegmentGenerateSpec(Intervals.of((String)"2017-11-14T00:00:00/2017-11-16T07:00:00"), segmentPeriod))), (Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T00:00:00/2017-11-17T00:00:00"), (Object)Intervals.of((String)"2017-11-15T00:00:00/2017-11-15T20:00:00"), (Object)Intervals.of((String)"2017-11-13T00:00:00/2017-11-14T01:00:00"))));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-15T20:00:00/2017-11-15T21:00:00"), Intervals.of((String)"2017-11-15T23:00:00/2017-11-16T00:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-14T01:00:00/2017-11-14T02:00:00"), Intervals.of((String)"2017-11-14T23:00:00/2017-11-15T00:00:00"), true);
    }

    @Test
    public void testHoleInSearchInterval() {
        Period segmentPeriod = new Period((Object)"PT1H");
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(10000L, new Period((Object)"PT1H"), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-11-16T00:00:00/2017-11-17T00:00:00"), segmentPeriod))), (Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)ImmutableList.of((Object)Intervals.of((String)"2017-11-16T04:00:00/2017-11-16T10:00:00"), (Object)Intervals.of((String)"2017-11-16T14:00:00/2017-11-16T20:00:00"))));
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T20:00:00/2017-11-16T21:00:00"), Intervals.of((String)"2017-11-16T22:00:00/2017-11-16T23:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T10:00:00/2017-11-16T11:00:00"), Intervals.of((String)"2017-11-16T13:00:00/2017-11-16T14:00:00"), false);
        NewestSegmentFirstPolicyTest.assertCompactSegmentIntervals(iterator, segmentPeriod, Intervals.of((String)"2017-11-16T00:00:00/2017-11-16T01:00:00"), Intervals.of((String)"2017-11-16T03:00:00/2017-11-16T04:00:00"), true);
    }

    @Test
    public void testIteratorReturnsSegmentsInConfiguredSegmentGranularity() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-12-31T00:00:00"), new Period((Object)"P1D")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01T00:00:00/2017-12-31T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-11-01T00:00:00/2017-12-01T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-11-01T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsInMultipleIntervalIfConfiguredSegmentGranularityCrossBoundary() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2020-01-01/2020-01-08"), new Period((Object)"P7D")), new SegmentGenerateSpec(Intervals.of((String)"2020-01-28/2020-02-03"), new Period((Object)"P7D")), new SegmentGenerateSpec(Intervals.of((String)"2020-02-08/2020-02-15"), new Period((Object)"P7D")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2020-01-28/2020-02-15"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        List actual = (List)iterator.next();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2020-01-01/2020-02-03"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        actual = (List)iterator.next();
        Assert.assertEquals((long)expectedSegmentsToCompact.size(), (long)actual.size());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)actual));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorDoesNotReturnCompactedInterval() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-12-01T00:00:00/2017-12-02T00:00:00"), new Period((Object)"P1D")));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(40000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.MINUTE, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-12-01T00:00:00/2017-12-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsAllMixedVersionSegmentsInConfiguredSegmentGranularity() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), "1994-04-29T00:00:00.000Z", null), new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T01:00:00/2017-10-01T02:00:00"), new Period((Object)"PT1H"), "1994-04-30T00:00:00.000Z", null));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsNothingAsSegmentsWasCompactedAndHaveSameSegmentGranularityAndSameTimezone() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsNothingAsSegmentsWasCompactedAndHaveSameSegmentGranularityInLastCompactionState() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"))));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentSegmentGranularity() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentSegmentGranularityInLastCompactionState() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"segmentGranularity", (Object)"day"))));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentTimezone() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Asia/Bangkok"))), null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentOrigin() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(new Period((Object)"P1D"), DateTimes.of((String)"2012-01-02T00:05:00.000Z"), DateTimeZone.UTC), null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentRollup() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"rollup", (Object)"false"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"rollup", (Object)"true"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of())));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentQueryGranularity() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"queryGranularity", (Object)"day"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of((Object)"queryGranularity", (Object)"minute"))), new SegmentGenerateSpec(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, (Map)ImmutableMap.of())));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(null, Granularities.MINUTE, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentDimensions() {
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo"))), null, null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo"))), null, null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, DimensionsSpec.EMPTY, null, null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo"))), null, null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, new UserCompactionTaskDimensionsConfig(null), null, null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentFilter() throws Exception {
        NullHandling.initializeForTests();
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null), null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec((DimFilter)new SelectorDimFilter("dim1", "bar", null), null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)new TransformSpec(null, null)), (TypeReference)new TypeReference<Map<String, Object>>(){}), indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, new UserCompactionTaskTransformConfig((DimFilter)new SelectorDimFilter("dim1", "bar", null)), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, new UserCompactionTaskTransformConfig(null), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsSegmentsWasCompactedAndHaveDifferentMetricsSpec() {
        NullHandling.initializeForTests();
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE));
        Map indexSpec = (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[]{new CountAggregatorFactory("cnt")}, (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")}, (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, (List)this.mapper.convertValue((Object)new AggregatorFactory[0], (TypeReference)new TypeReference<List<Object>>(){}), null, indexSpec, null)), new SegmentGenerateSpec(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, indexSpec, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, null, new AggregatorFactory[]{new CountAggregatorFactory("cnt"), new LongSumAggregatorFactory("val", "val")})), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-04T00:00:00/2017-10-05T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-03T00:00:00/2017-10-04T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertTrue((boolean)iterator.hasNext());
        expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, null, null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsSmallerSegmentGranularityCoveringMultipleSegmentsInTimeline() {
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), "1994-04-29T00:00:00.000Z", null), new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T01:00:00/2017-10-01T02:00:00"), new Period((Object)"PT1H"), "1994-04-30T00:00:00.000Z", null));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorReturnsSegmentsAsCompactionStateChangedWithCompactedStateHasSameSegmentGranularity() {
        IndexSpec newIndexSpec = new IndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), null, null, null);
        Map newIndexSpecMap = (Map)this.mapper.convertValue((Object)newIndexSpec, (TypeReference)new TypeReference<Map<String, Object>>(){});
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-02T00:00:00/2017-10-03T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, newIndexSpecMap, null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), new UserCompactionTaskGranularityConfig((Granularity)new PeriodGranularity(new Period((Object)"P1D"), null, DateTimeZone.UTC), null, null))), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertTrue((boolean)iterator.hasNext());
        ArrayList expectedSegmentsToCompact = new ArrayList(timeline.findNonOvershadowedObjectsInInterval(Intervals.of((String)"2017-10-01T00:00:00/2017-10-03T00:00:00"), Partitions.ONLY_COMPLETE));
        Assert.assertEquals((Object)ImmutableSet.copyOf(expectedSegmentsToCompact), (Object)ImmutableSet.copyOf((Collection)((Collection)iterator.next())));
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testIteratorDoesNotReturnSegmentWithChangingAppendableIndexSpec() {
        NullHandling.initializeForTests();
        PartitionsSpec partitionsSpec = NewestSegmentFirstIterator.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from(null, null, null));
        VersionedIntervalTimeline<String, DataSegment> timeline = NewestSegmentFirstPolicyTest.createTimeline(new SegmentGenerateSpec(Intervals.of((String)"2017-10-01T00:00:00/2017-10-02T00:00:00"), new Period((Object)"P1D"), null, new CompactionState(partitionsSpec, null, null, null, (Map)this.mapper.convertValue((Object)new IndexSpec(), (TypeReference)new TypeReference<Map<String, Object>>(){}), null)));
        CompactionSegmentIterator iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, null, new UserCompactionTaskQueryTuningConfig(null, (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), null, Long.valueOf(1000L), null, partitionsSpec, new IndexSpec(), null, null, null, null, null, null, null, null, null, null, null, null), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.policy.reset((Map)ImmutableMap.of((Object)DATA_SOURCE, (Object)this.createCompactionConfig(130000L, new Period((Object)"P0D"), null, null, null, new UserCompactionTaskQueryTuningConfig(null, (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(false)), null, Long.valueOf(1000L), null, partitionsSpec, new IndexSpec(), null, null, null, null, null, null, null, null, null, null, null, null), null)), (Map)ImmutableMap.of((Object)DATA_SOURCE, timeline), Collections.emptyMap());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private static void assertCompactSegmentIntervals(CompactionSegmentIterator iterator, Period segmentPeriod, Interval from, Interval to, boolean assertLast) {
        Interval expectedSegmentIntervalStart = to;
        while (iterator.hasNext()) {
            List segments = (List)iterator.next();
            Interval firstInterval = ((DataSegment)segments.get(0)).getInterval();
            Assert.assertTrue((String)"Intervals should be same or abutting", (boolean)segments.stream().allMatch(segment -> segment.getInterval().isEqual((ReadableInterval)firstInterval) || segment.getInterval().abuts((ReadableInterval)firstInterval)));
            ArrayList<Interval> expectedIntervals = new ArrayList<Interval>(segments.size());
            for (int i = 0; i < segments.size(); ++i) {
                if (i > 0 && i % 4 == 0) {
                    expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
                }
                expectedIntervals.add(expectedSegmentIntervalStart);
            }
            expectedIntervals.sort(Comparators.intervalsByStartThenEnd());
            Assert.assertEquals(expectedIntervals, segments.stream().map(DataSegment::getInterval).collect(Collectors.toList()));
            if (expectedSegmentIntervalStart.equals((Object)from)) break;
            expectedSegmentIntervalStart = new Interval((ReadablePeriod)segmentPeriod, (ReadableInstant)expectedSegmentIntervalStart.getStart());
        }
        if (assertLast) {
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private static VersionedIntervalTimeline<String, DataSegment> createTimeline(SegmentGenerateSpec ... specs) {
        ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
        String version = DateTimes.nowUtc().toString();
        List<SegmentGenerateSpec> orderedSpecs = Arrays.asList(specs);
        orderedSpecs.sort(Comparator.comparing(s -> ((SegmentGenerateSpec)s).totalInterval, Comparators.intervalsByStartThenEnd().reversed()));
        for (SegmentGenerateSpec spec : orderedSpecs) {
            Interval remainingInterval = spec.totalInterval;
            while (!Intervals.isEmpty((Interval)remainingInterval)) {
                Interval segmentInterval = remainingInterval.toDuration().isLongerThan((ReadableDuration)spec.segmentPeriod.toStandardDuration()) ? new Interval((ReadablePeriod)spec.segmentPeriod, (ReadableInstant)remainingInterval.getEnd()) : remainingInterval;
                for (int i = 0; i < spec.numSegmentsPerShard; ++i) {
                    NumberedShardSpec shardSpec = new NumberedShardSpec(i, spec.numSegmentsPerShard);
                    DataSegment segment = new DataSegment(DATA_SOURCE, segmentInterval, spec.version == null ? version : spec.version, null, (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)shardSpec, spec.lastCompactionState, Integer.valueOf(0), spec.segmentSize);
                    segments.add(segment);
                }
                remainingInterval = SegmentCompactionUtil.removeIntervalFromEnd((Interval)remainingInterval, (Interval)segmentInterval);
            }
        }
        return VersionedIntervalTimeline.forSegments(segments);
    }

    private DataSourceCompactionConfig createCompactionConfig(long inputSegmentSizeBytes, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec) {
        return this.createCompactionConfig(inputSegmentSizeBytes, skipOffsetFromLatest, granularitySpec, null, null, null, null);
    }

    private DataSourceCompactionConfig createCompactionConfig(long inputSegmentSizeBytes, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec, UserCompactionTaskDimensionsConfig dimensionsSpec, UserCompactionTaskTransformConfig transformSpec, AggregatorFactory[] metricsSpec) {
        return this.createCompactionConfig(inputSegmentSizeBytes, skipOffsetFromLatest, granularitySpec, dimensionsSpec, transformSpec, null, metricsSpec);
    }

    private DataSourceCompactionConfig createCompactionConfig(long inputSegmentSizeBytes, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec, UserCompactionTaskDimensionsConfig dimensionsSpec, UserCompactionTaskTransformConfig transformSpec, UserCompactionTaskQueryTuningConfig tuningConfig, AggregatorFactory[] metricsSpec) {
        return new DataSourceCompactionConfig(DATA_SOURCE, Integer.valueOf(0), Long.valueOf(inputSegmentSizeBytes), null, skipOffsetFromLatest, tuningConfig, granularitySpec, dimensionsSpec, metricsSpec, transformSpec, null, null);
    }

    private static class SegmentGenerateSpec {
        private final Interval totalInterval;
        private final Period segmentPeriod;
        private final long segmentSize;
        private final int numSegmentsPerShard;
        private final String version;
        private final CompactionState lastCompactionState;

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod) {
            this(totalInterval, segmentPeriod, null, null);
        }

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod, String version, CompactionState lastCompactionState) {
            this(totalInterval, segmentPeriod, 1000L, 4, version, lastCompactionState);
        }

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod, long segmentSize, int numSegmentsPerShard) {
            this(totalInterval, segmentPeriod, segmentSize, numSegmentsPerShard, null, null);
        }

        SegmentGenerateSpec(Interval totalInterval, Period segmentPeriod, long segmentSize, int numSegmentsPerShard, String version, CompactionState lastCompactionState) {
            Preconditions.checkArgument((numSegmentsPerShard >= 1 ? 1 : 0) != 0);
            this.totalInterval = totalInterval;
            this.segmentPeriod = segmentPeriod;
            this.segmentSize = segmentSize;
            this.numSegmentsPerShard = numSegmentsPerShard;
            this.version = version;
            this.lastCompactionState = lastCompactionState;
        }
    }
}

