/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.IntervalBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.PeriodBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BroadcastDistributionRuleSerdeTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private final Rule testRule;

    @Parameterized.Parameters
    public static List<Object[]> constructorFeeder() {
        return Lists.newArrayList((Object[])new Object[][]{{new ForeverBroadcastDistributionRule()}, {new IntervalBroadcastDistributionRule(Intervals.of((String)"0/1000"))}, {new PeriodBroadcastDistributionRule(new Period(1000L), null)}});
    }

    public BroadcastDistributionRuleSerdeTest(Rule testRule) {
        this.testRule = testRule;
    }

    @Test
    public void testSerde() throws IOException {
        List<Rule> rules = Collections.singletonList(this.testRule);
        String json = MAPPER.writeValueAsString(rules);
        List fromJson = (List)MAPPER.readValue(json, (TypeReference)new TypeReference<List<Rule>>(){});
        Assert.assertEquals(rules, (Object)fromJson);
    }
}

