/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BroadcastDistributionRuleTest {
    private DruidCluster druidCluster;
    private ServerHolder holderOfSmallSegment;
    private final List<ServerHolder> holdersOfLargeSegments = new ArrayList<ServerHolder>();
    private final List<ServerHolder> holdersOfLargeSegments2 = new ArrayList<ServerHolder>();
    private final List<DataSegment> largeSegments = new ArrayList<DataSegment>();
    private final List<DataSegment> largeSegments2 = new ArrayList<DataSegment>();
    private DataSegment smallSegment;
    private DruidCluster secondCluster;
    private ServerHolder activeServer;
    private ServerHolder decommissioningServer1;
    private ServerHolder decommissioningServer2;

    @Before
    public void setUp() {
        int i;
        this.smallSegment = new DataSegment("small_source", Intervals.of((String)"0/1000"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
        for (i = 0; i < 3; ++i) {
            this.largeSegments.add(new DataSegment("large_source", Intervals.of((String)(i * 1000 + "/" + (i + 1) * 1000)), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L));
        }
        for (i = 0; i < 2; ++i) {
            this.largeSegments2.add(new DataSegment("large_source2", Intervals.of((String)(i * 1000 + "/" + (i + 1) * 1000)), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 100L));
        }
        this.holderOfSmallSegment = new ServerHolder(new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.smallSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverHot1", "hostHot1", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.largeSegments.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverNorm1", "hostNorm1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments.get(1)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments.add(new ServerHolder(new DruidServer("serverNorm2", "hostNorm2", null, 100L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments.get(2)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments2.add(new ServerHolder(new DruidServer("serverHot3", "hostHot3", null, 1000L, ServerType.HISTORICAL, "hot", 0).addDataSegment(this.largeSegments2.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.holdersOfLargeSegments2.add(new ServerHolder(new DruidServer("serverNorm3", "hostNorm3", null, 100L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.largeSegments2.get(1)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester()));
        this.activeServer = new ServerHolder(new DruidServer("active", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0).addDataSegment(this.largeSegments.get(0)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.decommissioningServer1 = new ServerHolder(new DruidServer("decommissioning1", "host2", null, 100L, ServerType.HISTORICAL, "tier1", 0).addDataSegment(this.smallSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester(), true);
        this.decommissioningServer2 = new ServerHolder(new DruidServer("decommissioning2", "host3", null, 100L, ServerType.HISTORICAL, "tier1", 0).addDataSegment(this.largeSegments.get(1)).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester(), true);
        this.druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", this.holdersOfLargeSegments.get(0), this.holderOfSmallSegment, this.holdersOfLargeSegments2.get(0)).addTier("_default_tier", this.holdersOfLargeSegments.get(1), this.holdersOfLargeSegments.get(2), this.holdersOfLargeSegments2.get(1)).build();
        this.secondCluster = DruidClusterBuilder.newBuilder().addTier("tier1", this.activeServer, this.decommissioningServer1, this.decommissioningServer2).build();
    }

    @Test
    public void testBroadcastToSingleDataSource() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule();
        CoordinatorStats stats = rule.run(null, BroadcastDistributionRuleTest.makeCoordinartorRuntimeParams(this.druidCluster, this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)), this.smallSegment);
        Assert.assertEquals((long)5L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertFalse((boolean)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.holdersOfLargeSegments.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertTrue((boolean)this.holdersOfLargeSegments2.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertTrue((boolean)this.holderOfSmallSegment.isServingSegment(this.smallSegment));
    }

    private static DruidCoordinatorRuntimeParams makeCoordinartorRuntimeParams(DruidCluster druidCluster, DataSegment ... usedSegments) {
        return CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false)).withUsedSegmentsInTest(usedSegments).build();
    }

    @Test
    public void testBroadcastDecommissioning() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule();
        CoordinatorStats stats = rule.run(null, BroadcastDistributionRuleTest.makeCoordinartorRuntimeParams(this.secondCluster, this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1)), this.smallSegment);
        Assert.assertEquals((long)1L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertFalse((boolean)stats.hasPerTierStats());
        Assert.assertEquals((long)1L, (long)this.activeServer.getPeon().getSegmentsToLoad().size());
        Assert.assertEquals((long)1L, (long)this.decommissioningServer1.getPeon().getSegmentsToDrop().size());
        Assert.assertEquals((long)0L, (long)this.decommissioningServer2.getPeon().getSegmentsToLoad().size());
    }

    @Test
    public void testBroadcastToMultipleDataSources() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule();
        CoordinatorStats stats = rule.run(null, BroadcastDistributionRuleTest.makeCoordinartorRuntimeParams(this.druidCluster, this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)), this.smallSegment);
        Assert.assertEquals((long)5L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertFalse((boolean)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.holdersOfLargeSegments.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertTrue((boolean)this.holdersOfLargeSegments2.stream().allMatch(holder -> holder.getPeon().getSegmentsToLoad().contains(this.smallSegment)));
        Assert.assertFalse((boolean)this.holderOfSmallSegment.getPeon().getSegmentsToLoad().contains(this.smallSegment));
    }

    @Test
    public void testBroadcastToAllServers() {
        ForeverBroadcastDistributionRule rule = new ForeverBroadcastDistributionRule();
        CoordinatorStats stats = rule.run(null, BroadcastDistributionRuleTest.makeCoordinartorRuntimeParams(this.druidCluster, this.smallSegment, this.largeSegments.get(0), this.largeSegments.get(1), this.largeSegments.get(2), this.largeSegments2.get(0), this.largeSegments2.get(1)), this.smallSegment);
        Assert.assertEquals((long)5L, (long)stats.getGlobalStat("assignedCount"));
        Assert.assertFalse((boolean)stats.hasPerTierStats());
        Assert.assertTrue((boolean)this.druidCluster.getAllServers().stream().allMatch(holder -> holder.isLoadingSegment(this.smallSegment) || holder.isServingSegment(this.smallSegment)));
    }
}

