/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.ws.rs.core.Response;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.CompactionResource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompactionResourceTest {
    private DruidCoordinator mock;
    private String dataSourceName = "datasource_1";
    private AutoCompactionSnapshot expectedSnapshot = new AutoCompactionSnapshot(this.dataSourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L);

    @Before
    public void setUp() {
        this.mock = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithEmptyQueryParameter() {
        ImmutableMap expected = ImmutableMap.of((Object)this.dataSourceName, (Object)this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn((Object)expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CompactionResource(this.mock).getCompactionSnapshotForDataSource("");
        Assert.assertEquals((Object)ImmutableMap.of((Object)"latestStatus", expected.values()), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithNullQueryParameter() {
        String dataSourceName = "datasource_1";
        ImmutableMap expected = ImmutableMap.of((Object)dataSourceName, (Object)this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn((Object)expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CompactionResource(this.mock).getCompactionSnapshotForDataSource(null);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"latestStatus", expected.values()), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithValidQueryParameter() {
        String dataSourceName = "datasource_1";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn((Object)this.expectedSnapshot).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CompactionResource(this.mock).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"latestStatus", (Object)ImmutableList.of((Object)this.expectedSnapshot)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithInvalidQueryParameter() {
        String dataSourceName = "invalid_datasource";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CompactionResource(this.mock).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }
}

