/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.http.CoordinatorCompactionConfigsResource;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CoordinatorCompactionConfigsResourceTest {
    private static final DataSourceCompactionConfig OLD_CONFIG = new DataSourceCompactionConfig("oldDataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
    private static final byte[] OLD_CONFIG_IN_BYTES = new byte[]{1, 2, 3};
    private static final CoordinatorCompactionConfig ORIGINAL_CONFIG = CoordinatorCompactionConfig.from((List)ImmutableList.of((Object)OLD_CONFIG));
    @Mock
    private JacksonConfigManager mockJacksonConfigManager;
    @Mock
    private HttpServletRequest mockHttpServletRequest;
    @Mock
    private MetadataStorageConnector mockConnector;
    @Mock
    private MetadataStorageTablesConfig mockConnectorConfig;
    private CoordinatorCompactionConfigsResource coordinatorCompactionConfigsResource;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn((Object)OLD_CONFIG_IN_BYTES);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)OLD_CONFIG_IN_BYTES), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)ORIGINAL_CONFIG);
        Mockito.when((Object)this.mockConnectorConfig.getConfigTable()).thenReturn((Object)"druid_config");
        this.coordinatorCompactionConfigsResource = new CoordinatorCompactionConfigsResource(this.mockJacksonConfigManager, this.mockConnector, this.mockConnectorConfig);
        Mockito.when((Object)this.mockHttpServletRequest.getRemoteAddr()).thenReturn((Object)"123");
    }

    @Test
    public void testSetCompactionTaskLimitWithExistingConfig() {
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        double compactionTaskSlotRatio = 0.5;
        int maxCompactionTaskSlots = 9;
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.setCompactionTaskLimit(Double.valueOf(compactionTaskSlotRatio), Integer.valueOf(maxCompactionTaskSlots), Boolean.valueOf(true), author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertNotNull((Object)oldConfigCaptor.getValue());
        Assert.assertEquals((Object)oldConfigCaptor.getValue(), (Object)OLD_CONFIG_IN_BYTES);
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getMaxCompactionTaskSlots(), (long)maxCompactionTaskSlots);
        Assert.assertTrue((boolean)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).isUseAutoScaleSlots());
        Assert.assertEquals((double)compactionTaskSlotRatio, (double)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionTaskSlotRatio(), (double)0.0);
    }

    @Test
    public void testAddOrUpdateCompactionConfigWithExistingConfig() {
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        DataSourceCompactionConfig newConfig = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, Boolean.valueOf(true)), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.addOrUpdateCompactionConfig(newConfig, author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertNotNull((Object)oldConfigCaptor.getValue());
        Assert.assertEquals((Object)oldConfigCaptor.getValue(), (Object)OLD_CONFIG_IN_BYTES);
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)2L, (long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().size());
        Assert.assertEquals((Object)OLD_CONFIG, ((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().get(0));
        Assert.assertEquals((Object)newConfig, ((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().get(1));
    }

    @Test
    public void testDeleteCompactionConfigWithExistingConfig() {
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        String datasourceName = "dataSource";
        DataSourceCompactionConfig toDelete = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        CoordinatorCompactionConfig originalConfig = CoordinatorCompactionConfig.from((List)ImmutableList.of((Object)toDelete));
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq((Object)OLD_CONFIG_IN_BYTES), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)originalConfig);
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.deleteCompactionConfig("dataSource", author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertNotNull((Object)oldConfigCaptor.getValue());
        Assert.assertEquals((Object)oldConfigCaptor.getValue(), (Object)OLD_CONFIG_IN_BYTES);
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)0L, (long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().size());
    }

    @Test
    public void testUpdateConfigHelperShouldRetryIfRetryableException() {
        MutableInt nunCalled = new MutableInt(0);
        Callable<ConfigManager.SetResult> callable = () -> {
            nunCalled.increment();
            return ConfigManager.SetResult.fail((Exception)new Exception(), (boolean)true);
        };
        this.coordinatorCompactionConfigsResource.updateConfigHelper(callable);
        Assert.assertEquals((long)5L, (long)nunCalled.getValue().intValue());
    }

    @Test
    public void testUpdateConfigHelperShouldNotRetryIfNotRetryableException() {
        MutableInt nunCalled = new MutableInt(0);
        Callable<ConfigManager.SetResult> callable = () -> {
            nunCalled.increment();
            return ConfigManager.SetResult.fail((Exception)new Exception(), (boolean)false);
        };
        this.coordinatorCompactionConfigsResource.updateConfigHelper(callable);
        Assert.assertEquals((long)1L, (long)nunCalled.getValue().intValue());
    }

    @Test
    public void testSetCompactionTaskLimitWithoutExistingConfig() {
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn(null);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)CoordinatorCompactionConfig.empty());
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        double compactionTaskSlotRatio = 0.5;
        int maxCompactionTaskSlots = 9;
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.setCompactionTaskLimit(Double.valueOf(compactionTaskSlotRatio), Integer.valueOf(maxCompactionTaskSlots), Boolean.valueOf(true), author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertNull((Object)oldConfigCaptor.getValue());
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getMaxCompactionTaskSlots(), (long)maxCompactionTaskSlots);
        Assert.assertTrue((boolean)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).isUseAutoScaleSlots());
        Assert.assertEquals((double)compactionTaskSlotRatio, (double)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionTaskSlotRatio(), (double)0.0);
    }

    @Test
    public void testAddOrUpdateCompactionConfigWithoutExistingConfig() {
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn(null);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)CoordinatorCompactionConfig.empty());
        ArgumentCaptor oldConfigCaptor = ArgumentCaptor.forClass(byte[].class);
        ArgumentCaptor newConfigCaptor = ArgumentCaptor.forClass(CoordinatorCompactionConfig.class);
        Mockito.when((Object)this.mockJacksonConfigManager.set((String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"), (byte[])oldConfigCaptor.capture(), newConfigCaptor.capture(), (AuditInfo)ArgumentMatchers.any())).thenReturn((Object)ConfigManager.SetResult.ok());
        DataSourceCompactionConfig newConfig = new DataSourceCompactionConfig("dataSource", null, Long.valueOf(500L), null, new Period(3600L), null, new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null), null, null, null, null, (Map)ImmutableMap.of((Object)"key", (Object)"val"));
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.addOrUpdateCompactionConfig(newConfig, author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)result.getStatus());
        Assert.assertNull((Object)oldConfigCaptor.getValue());
        Assert.assertNotNull((Object)newConfigCaptor.getValue());
        Assert.assertEquals((long)1L, (long)((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().size());
        Assert.assertEquals((Object)newConfig, ((CoordinatorCompactionConfig)newConfigCaptor.getValue()).getCompactionConfigs().get(0));
    }

    @Test
    public void testDeleteCompactionConfigWithoutExistingConfigShouldFailAsDatasourceNotExist() {
        Mockito.when((Object)this.mockConnector.lookup(ArgumentMatchers.anyString(), (String)ArgumentMatchers.eq((Object)"name"), (String)ArgumentMatchers.eq((Object)"payload"), (String)ArgumentMatchers.eq((Object)"coordinator.compaction.config"))).thenReturn(null);
        Mockito.when((Object)this.mockJacksonConfigManager.convertByteToConfig((byte[])ArgumentMatchers.eq(null), (Class)ArgumentMatchers.eq(CoordinatorCompactionConfig.class), ArgumentMatchers.eq((Object)CoordinatorCompactionConfig.empty()))).thenReturn((Object)CoordinatorCompactionConfig.empty());
        String author = "maytas";
        String comment = "hello";
        Response result = this.coordinatorCompactionConfigsResource.deleteCompactionConfig("notExist", author, comment, this.mockHttpServletRequest);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)result.getStatus());
    }
}

