/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorDynamicConfigTest {
    private static final int EXPECTED_DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 100;
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"percentOfSegmentsToConsiderPerMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"decommissioningMaxPercentOfMaxSegmentsToMove\": 9,\n  \"pauseCoordination\": false,\n  \"replicateAfterLoadTimeout\": false,\n  \"maxNonPrimaryReplicantsToLoad\": 2147483647\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)decommissioning, 9, false, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 9, false, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, false, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, true, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withPercentOfSegmentsToConsiderPerMove(10.0).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 10, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, true, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withReplicateAfterLoadTimeout(true).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 10, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, true, true, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withMaxNonPrimaryReplicantsToLoad(10).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 10, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, true, true, 10);
    }

    @Test
    public void testConstructorWithNullsShouldKillUnusedSegmentsInAllDataSources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1L, 1, 1, null, false, 1, 2, 10, true, null, null, null, (Object)ImmutableSet.of((Object)"host1"), 5, true, true, Integer.valueOf(10));
        Assert.assertTrue((boolean)config.isKillUnusedSegmentsInAllDataSources());
        Assert.assertTrue((boolean)config.getSpecificDataSourcesToKillUnusedSegmentsIn().isEmpty());
    }

    @Test
    public void testConstructorWithSpecificDataSourcesToKillShouldNotKillUnusedSegmentsInAllDatasources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1L, 1, 1, null, false, 1, 2, 10, true, (Object)ImmutableSet.of((Object)"test1"), null, null, (Object)ImmutableSet.of((Object)"host1"), 5, true, true, Integer.valueOf(10));
        Assert.assertFalse((boolean)config.isKillUnusedSegmentsInAllDataSources());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test1"), (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
    }

    @Test
    public void testDecommissioningParametersBackwardCompatibility() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of();
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1L, 1, 1, 100, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)decommissioning, 0, false, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 100, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 0, false, false, Integer.MAX_VALUE);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1L, 1, 1, 100, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)ImmutableSet.of((Object)"host1"), 5, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testSerdeWithStringinKillDataSourceWhitelist() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"percentOfSegmentsToConsiderPerMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": \"test1, test2\", \n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of((Object)"test1", (Object)"test2"), false, 1, (Set<String>)ImmutableSet.of(), 0, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testSerdeHandleInvalidPercentOfSegmentsToConsiderPerMove() throws Exception {
        String jsonStr;
        try {
            jsonStr = "{\n  \"percentOfSegmentsToConsiderPerMove\": 0\n}\n";
            this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
            Assert.fail((String)"deserialization should fail.");
        }
        catch (JsonMappingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            jsonStr = "{\n  \"percentOfSegmentsToConsiderPerMove\": -100\n}\n";
            this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
            Assert.fail((String)"deserialization should fail.");
        }
        catch (JsonMappingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
        try {
            jsonStr = "{\n  \"percentOfSegmentsToConsiderPerMove\": 105\n}\n";
            this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
            Assert.fail((String)"deserialization should fail.");
        }
        catch (JsonMappingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testHandleMissingPercentOfSegmentsToConsiderPerMove() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"decommissioningMaxPercentOfMaxSegmentsToMove\": 9,\n  \"pauseCoordination\": false\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1L, 1, 1, 100, 1, 1, 2, true, (Set<String>)whitelist, false, 1, (Set<String>)decommissioning, 9, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testSerdeWithKillAllDataSources() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"percentOfSegmentsToConsiderPerMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killAllDataSources\": true,\n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of(), true, 1, (Set<String>)ImmutableSet.of(), 0, false, false, Integer.MAX_VALUE);
        jsonStr = "{\n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"killAllDataSources\": true,\n  \"percentOfSegmentsToConsiderPerMove\": 1\n}\n";
        actual = (CoordinatorDynamicConfig)this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class);
        Assert.assertFalse((boolean)actual.isKillUnusedSegmentsInAllDataSources());
        Assert.assertEquals((long)2L, (long)actual.getSpecificDataSourcesToKillUnusedSegmentsIn().size());
    }

    @Test
    public void testDeserializeWithoutMaxSegmentsInNodeLoadingQueue() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"mergeBytesLimit\": 1,\n  \"mergeSegmentsLimit\" : 1,\n  \"maxSegmentsToMove\": 1,\n  \"percentOfSegmentsToConsiderPerMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"emitBalancingStats\": true,\n  \"killAllDataSources\": true\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1L, 1, 1, 1, 1, 1, 2, true, (Set<String>)ImmutableSet.of(), true, 100, (Set<String>)ImmutableSet.of(), 0, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testBuilderDefaults() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().build();
        ImmutableSet emptyList = ImmutableSet.of();
        this.assertConfig(defaultConfig, 900000L, 524288000L, 100, 5, 100, 15, 10, 1, false, (Set<String>)emptyList, true, 100, (Set<String>)emptyList, 70, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testBuilderWithDefaultSpecificDataSourcesToKillUnusedSegmentsInSpecified() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"DATASOURCE")).build();
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().build(defaultConfig);
        this.assertConfig(config, 900000L, 524288000L, 100, 5, 100, 15, 10, 1, false, (Set<String>)ImmutableSet.of((Object)"DATASOURCE"), false, 100, (Set<String>)ImmutableSet.of(), 70, false, false, Integer.MAX_VALUE);
    }

    @Test
    public void testUpdate() {
        CoordinatorDynamicConfig current = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"x")).build();
        Assert.assertEquals((Object)current, (Object)new CoordinatorDynamicConfig.Builder(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null).build(current));
    }

    @Test
    public void testSerdeHandleInvalidMaxNonPrimaryReplicantsToLoad() throws Exception {
        try {
            String jsonStr = "{\n  \"maxNonPrimaryReplicantsToLoad\": -1\n}\n";
            this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
            Assert.fail((String)"deserialization should fail.");
        }
        catch (JsonMappingException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testEqualsAndHashCodeSanity() {
        CoordinatorDynamicConfig config1 = CoordinatorDynamicConfig.builder().build();
        CoordinatorDynamicConfig config2 = CoordinatorDynamicConfig.builder().build();
        Assert.assertEquals((Object)config1, (Object)config2);
        Assert.assertEquals((long)config1.hashCode(), (long)config2.hashCode());
    }

    private void assertConfig(CoordinatorDynamicConfig config, long expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, long expectedMergeBytesLimit, int expectedMergeSegmentsLimit, int expectedMaxSegmentsToMove, int expectedPercentOfSegmentsToConsiderPerMove, int expectedReplicantLifetime, int expectedReplicationThrottleLimit, int expectedBalancerComputeThreads, boolean expectedEmitingBalancingStats, Set<String> expectedSpecificDataSourcesToKillUnusedSegmentsIn, boolean expectedKillUnusedSegmentsInAllDataSources, int expectedMaxSegmentsInNodeLoadingQueue, Set<String> decommissioningNodes, int decommissioningMaxPercentOfMaxSegmentsToMove, boolean pauseCoordination, boolean replicateAfterLoadTimeout, int maxNonPrimaryReplicantsToLoad) {
        Assert.assertEquals((long)expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, (long)config.getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments());
        Assert.assertEquals((long)expectedMergeBytesLimit, (long)config.getMergeBytesLimit());
        Assert.assertEquals((long)expectedMergeSegmentsLimit, (long)config.getMergeSegmentsLimit());
        Assert.assertEquals((long)expectedMaxSegmentsToMove, (long)config.getMaxSegmentsToMove());
        Assert.assertEquals((double)expectedPercentOfSegmentsToConsiderPerMove, (double)config.getPercentOfSegmentsToConsiderPerMove(), (double)0.0);
        Assert.assertEquals((long)expectedReplicantLifetime, (long)config.getReplicantLifetime());
        Assert.assertEquals((long)expectedReplicationThrottleLimit, (long)config.getReplicationThrottleLimit());
        Assert.assertEquals((long)expectedBalancerComputeThreads, (long)config.getBalancerComputeThreads());
        Assert.assertEquals((Object)expectedEmitingBalancingStats, (Object)config.emitBalancingStats());
        Assert.assertEquals(expectedSpecificDataSourcesToKillUnusedSegmentsIn, (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
        Assert.assertEquals((Object)expectedKillUnusedSegmentsInAllDataSources, (Object)config.isKillUnusedSegmentsInAllDataSources());
        Assert.assertEquals((long)expectedMaxSegmentsInNodeLoadingQueue, (long)config.getMaxSegmentsInNodeLoadingQueue());
        Assert.assertEquals(decommissioningNodes, (Object)config.getDecommissioningNodes());
        Assert.assertEquals((long)decommissioningMaxPercentOfMaxSegmentsToMove, (long)config.getDecommissioningMaxPercentOfMaxSegmentsToMove());
        Assert.assertEquals((Object)pauseCoordination, (Object)config.getPauseCoordination());
        Assert.assertEquals((Object)replicateAfterLoadTimeout, (Object)config.getReplicateAfterLoadTimeout());
        Assert.assertEquals((long)maxNonPrimaryReplicantsToLoad, (long)config.getMaxNonPrimaryReplicantsToLoad());
    }
}

