/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import java.net.URL;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.CoordinatorRedirectInfo;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorRedirectInfoTest {
    private DruidCoordinator druidCoordinator;
    private CoordinatorRedirectInfo coordinatorRedirectInfo;

    @Before
    public void setUp() {
        this.druidCoordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.coordinatorRedirectInfo = new CoordinatorRedirectInfo(this.druidCoordinator);
    }

    @Test
    public void testDoLocalWhenLeading() {
        EasyMock.expect((Object)this.druidCoordinator.isLeader()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidCoordinator});
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal(null));
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/leader"));
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/isLeader"));
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/other/path"));
        EasyMock.verify((Object[])new Object[]{this.druidCoordinator});
    }

    @Test
    public void testDoLocalWhenNotLeading() {
        EasyMock.expect((Object)this.druidCoordinator.isLeader()).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidCoordinator});
        Assert.assertFalse((boolean)this.coordinatorRedirectInfo.doLocal(null));
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/leader"));
        Assert.assertTrue((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/isLeader"));
        Assert.assertFalse((boolean)this.coordinatorRedirectInfo.doLocal("/druid/coordinator/v1/other/path"));
        EasyMock.verify((Object[])new Object[]{this.druidCoordinator});
    }

    @Test
    public void testGetRedirectURLNull() {
        EasyMock.expect((Object)this.druidCoordinator.getCurrentLeader()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidCoordinator});
        URL url = this.coordinatorRedirectInfo.getRedirectURL("query", "/request");
        Assert.assertNull((Object)url);
        EasyMock.verify((Object[])new Object[]{this.druidCoordinator});
    }

    @Test
    public void testGetRedirectURL() {
        String query = "foo=bar&x=y";
        String request = "/request";
        EasyMock.expect((Object)this.druidCoordinator.getCurrentLeader()).andReturn((Object)"http://localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidCoordinator});
        URL url = this.coordinatorRedirectInfo.getRedirectURL(query, request);
        Assert.assertEquals((Object)"http://localhost/request?foo=bar&x=y", (Object)url.toString());
        EasyMock.verify((Object[])new Object[]{this.druidCoordinator});
    }
}

