/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.server.http.OverlordProxyServlet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class OverlordProxyServletTest {
    @Test
    public void testRewriteURI() {
        DruidLeaderClient druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        EasyMock.expect((Object)druidLeaderClient.findCurrentLeader()).andReturn((Object)"https://overlord:port");
        HttpServletRequest request = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getQueryString()).andReturn((Object)"param1=test&param2=test2").anyTimes();
        EasyMock.expect((Object)request.getRequestURI()).andReturn((Object)"/druid/over%3Alord/worker").anyTimes();
        EasyMock.replay((Object[])new Object[]{druidLeaderClient, request});
        URI uri = URI.create(new OverlordProxyServlet(druidLeaderClient, null, null).rewriteTarget(request));
        Assert.assertEquals((Object)"https://overlord:port/druid/over%3Alord/worker?param1=test&param2=test2", (Object)uri.toString());
    }
}

