/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.FakeQuery;
import org.apache.druid.server.log.LoggingRequestLogger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoggingRequestLoggerTest {
    private static final ObjectMapper MAPPER = new DefaultObjectMapper();
    private static final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static Appender appender;
    final DateTime timestamp = DateTimes.of((String)"2016-01-01T00:00:00Z");
    final String remoteAddr = "some.host.tld";
    final Map<String, Object> queryContext = ImmutableMap.of((Object)"foo", (Object)"bar");
    final Query query = new FakeQuery((DataSource)new TableDataSource("datasource"), new QuerySegmentSpec(){

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.of((String)"2016-01-01T00Z/2016-01-02T00Z"));
        }

        public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
            return null;
        }
    }, false, this.queryContext);
    final Query nestedQuery = new FakeQuery((DataSource)new QueryDataSource(this.query), new QuerySegmentSpec(){

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.of((String)"2016-01-01T00Z/2016-01-02T00Z"));
        }

        public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
            return null;
        }
    }, false, this.queryContext);
    final Query nestedNestedQuery = new FakeQuery((DataSource)new QueryDataSource(this.nestedQuery), new QuerySegmentSpec(){

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.of((String)"2016-01-01T00Z/2016-01-02T00Z"));
        }

        public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
            return null;
        }
    }, false, this.queryContext);
    final Query unionQuery = new FakeQuery((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource("A"), (Object)new TableDataSource("B"))), new QuerySegmentSpec(){

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.of((String)"2016-01-01T00Z/2016-01-02T00Z"));
        }

        public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
            return null;
        }
    }, false, this.queryContext);
    final QueryStats queryStats = new QueryStats((Map)ImmutableMap.of());
    final RequestLogLine logLine = RequestLogLine.forNative((Query)this.query, (DateTime)this.timestamp, (String)"some.host.tld", (QueryStats)this.queryStats);

    @BeforeClass
    public static void setUpStatic() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        appender = ((OutputStreamAppender.Builder)((OutputStreamAppender.Builder)OutputStreamAppender.newBuilder().setName("test stream")).setTarget((OutputStream)BAOS).setLayout((Layout)JsonLayout.createLayout((Configuration)configuration, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (String)"[", (String)"]", (Charset)StandardCharsets.UTF_8, (boolean)true))).build();
        Logger logger = (Logger)LogManager.getLogger(LoggingRequestLogger.class);
        appender.start();
        logger.addAppender(appender);
    }

    @After
    public void tearDown() {
        BAOS.reset();
    }

    @AfterClass
    public static void tearDownStatic() {
        Logger logger = (Logger)LogManager.getLogger(LoggingRequestLogger.class);
        logger.removeAppender(appender);
        appender.stop();
    }

    @Test
    public void testSimpleLogging() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), false, false);
        requestLogger.logNativeQuery(this.logLine);
    }

    @Test
    public void testLoggingMDC() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, false);
        requestLogger.logNativeQuery(this.logLine);
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(BAOS.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertEquals((Object)"false", (Object)map.get("isNested"));
        Assert.assertNull((Object)map.get("foo"));
    }

    @Test
    public void testLoggingMDCContext() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, true);
        requestLogger.logNativeQuery(this.logLine);
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(BAOS.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertEquals((Object)"false", (Object)map.get("isNested"));
        Assert.assertEquals((Object)"bar", (Object)map.get("foo"));
    }

    @Test
    public void testNestedQueryLoggingMDC() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, false);
        requestLogger.logNativeQuery(RequestLogLine.forNative((Query)this.nestedQuery, (DateTime)this.timestamp, (String)"some.host.tld", (QueryStats)this.queryStats));
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(BAOS.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertEquals((Object)"true", (Object)map.get("isNested"));
        Assert.assertNull((Object)map.get("foo"));
    }

    @Test
    public void testNestedNestedQueryLoggingMDC() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, false);
        requestLogger.logNativeQuery(RequestLogLine.forNative((Query)this.nestedNestedQuery, (DateTime)this.timestamp, (String)"some.host.tld", (QueryStats)this.queryStats));
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(BAOS.toByteArray());
        Assert.assertEquals((Object)"datasource", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"true", (Object)map.get("isNested"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertNull((Object)map.get("foo"));
    }

    @Test
    public void testUnionQueryLoggingMDC() throws Exception {
        LoggingRequestLogger requestLogger = new LoggingRequestLogger((ObjectMapper)new DefaultObjectMapper(), true, false);
        requestLogger.logNativeQuery(RequestLogLine.forNative((Query)this.unionQuery, (DateTime)this.timestamp, (String)"some.host.tld", (QueryStats)this.queryStats));
        Map<String, Object> map = LoggingRequestLoggerTest.readContextMap(BAOS.toByteArray());
        Assert.assertEquals((Object)"A,B", (Object)map.get("dataSource"));
        Assert.assertEquals((Object)"true", (Object)map.get("isNested"));
        Assert.assertEquals((Object)"PT86400S", (Object)map.get("duration"));
        Assert.assertEquals((Object)"false", (Object)map.get("hasFilters"));
        Assert.assertEquals((Object)"fake", (Object)map.get("queryType"));
        Assert.assertEquals((Object)"some.host.tld", (Object)map.get("remoteAddr"));
        Assert.assertEquals((Object)"false", (Object)map.get("descending"));
        Assert.assertNull((Object)map.get("foo"));
    }

    private static Map<String, Object> readContextMap(byte[] bytes) throws Exception {
        Map rawMap = (Map)MAPPER.readValue(bytes, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Object contextMap = rawMap.get("contextMap");
        if (contextMap == null) {
            return null;
        }
        Collection contextList = (Collection)contextMap;
        HashMap context = new HashMap();
        for (Map microContext : contextList) {
            String key = microContext.get("key").toString();
            Object value = microContext.get("value");
            if (key == null || value == null) continue;
            context.put(key, value);
        }
        return ImmutableMap.copyOf(context);
    }
}

