/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import org.apache.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class LookupCoordinatorManagerConfigTest {
    @Test
    public void testConfigsTakeOverrides() {
        Duration funnyDuration = Duration.standardDays((long)100L);
        LookupCoordinatorManagerConfig config = new LookupCoordinatorManagerConfig();
        config.setHostTimeout(funnyDuration);
        config.setAllHostTimeout(funnyDuration);
        config.setPeriod(funnyDuration.getMillis());
        config.setThreadPoolSize(1200);
        Assert.assertEquals((Object)funnyDuration, (Object)config.getHostTimeout());
        Assert.assertEquals((Object)funnyDuration, (Object)config.getAllHostTimeout());
        Assert.assertEquals((long)funnyDuration.getMillis(), (long)config.getPeriod());
        Assert.assertEquals((long)1200L, (long)config.getThreadPoolSize());
    }

    @Test
    public void testSimpleConfigDefaults() {
        LookupCoordinatorManagerConfig config = new LookupCoordinatorManagerConfig();
        Assert.assertEquals((Object)LookupCoordinatorManagerConfig.DEFAULT_HOST_TIMEOUT, (Object)config.getHostTimeout());
        Assert.assertEquals((Object)LookupCoordinatorManagerConfig.DEFAULT_ALL_HOST_TIMEOUT, (Object)config.getAllHostTimeout());
        Assert.assertEquals((long)10L, (long)config.getThreadPoolSize());
        Assert.assertEquals((long)120000L, (long)config.getPeriod());
    }
}

