/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.Response;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.LoggingEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.server.http.HostAndPortWithScheme;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManagerConfig;
import org.apache.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.apache.druid.server.lookup.cache.LookupNodeDiscovery;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LookupCoordinatorManagerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createStrictMock(DruidNodeDiscoveryProvider.class);
    private final LookupNodeDiscovery lookupNodeDiscovery = (LookupNodeDiscovery)EasyMock.createStrictMock(LookupNodeDiscovery.class);
    private final HttpClient client = (HttpClient)EasyMock.createStrictMock(HttpClient.class);
    private final JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createStrictMock(JacksonConfigManager.class);
    private final LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig = new LookupCoordinatorManagerConfig();
    private static final String LOOKUP_TIER = "lookup_tier";
    private static final String SINGLE_LOOKUP_NAME = "lookupName";
    private static final LookupExtractorFactoryMapContainer SINGLE_LOOKUP_SPEC_V0 = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"k0", (Object)"v0"));
    private static final LookupExtractorFactoryMapContainer SINGLE_LOOKUP_SPEC_V1 = new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1"));
    private static final Map<String, LookupExtractorFactoryMapContainer> SINGLE_LOOKUP_MAP_V0 = ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP_SPEC_V0);
    private static final Map<String, LookupExtractorFactoryMapContainer> SINGLE_LOOKUP_MAP_V1 = ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP_SPEC_V1);
    private static final Map<String, Map<String, LookupExtractorFactoryMapContainer>> TIERED_LOOKUP_MAP_V0 = ImmutableMap.of((Object)"lookup_tier", SINGLE_LOOKUP_MAP_V0);
    private static final Map<String, Map<String, LookupExtractorFactoryMapContainer>> TIERED_LOOKUP_MAP_V1 = ImmutableMap.of((Object)"lookup_tier", SINGLE_LOOKUP_MAP_V1);
    private static final Map<String, Map<String, LookupExtractorFactoryMapContainer>> EMPTY_TIERED_LOOKUP = ImmutableMap.of();
    private static final LookupsState<LookupExtractorFactoryMapContainer> LOOKUPS_STATE = new LookupsState(SINGLE_LOOKUP_MAP_V0, SINGLE_LOOKUP_MAP_V1, Collections.emptySet());
    private static final AtomicLong EVENT_EMITS = new AtomicLong(0L);
    private static ServiceEmitter SERVICE_EMITTER;

    @BeforeClass
    public static void setUpStatic() {
        LoggingEmitter loggingEmitter = (LoggingEmitter)EasyMock.createNiceMock(LoggingEmitter.class);
        EasyMock.replay((Object[])new Object[]{loggingEmitter});
        SERVICE_EMITTER = new ServiceEmitter("", "", (Emitter)loggingEmitter){

            public void emit(Event event) {
                EVENT_EMITS.incrementAndGet();
                super.emit(event);
            }
        };
        EmittingLogger.registerEmitter((ServiceEmitter)SERVICE_EMITTER);
    }

    @Before
    public void setUp() throws IOException {
        SERVICE_EMITTER.flush();
        EVENT_EMITS.set(0L);
        EasyMock.reset((Object[])new Object[]{this.lookupNodeDiscovery});
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookupsConfig"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<Object>(null)).anyTimes();
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookups"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<Object>(null)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.configManager});
    }

    @After
    public void tearDown() throws IOException {
        SERVICE_EMITTER.flush();
        Assert.assertEquals((long)0L, (long)EVENT_EMITS.get());
    }

    @Test
    public void testUpdateNodeWithSuccess() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString(LOOKUPS_STATE))));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.ACCEPTED.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        LookupsState resp = lookupsCommunicator.updateNode(HostAndPortWithScheme.fromString((String)"localhost"), LOOKUPS_STATE);
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
        Assert.assertEquals((Object)resp, LOOKUPS_STATE);
    }

    @Test
    public void testUpdateNodeRespondedWithNotOkErrorCode() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"server failed")));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        try {
            lookupsCommunicator.updateNode(HostAndPortWithScheme.fromString((String)"localhost"), LOOKUPS_STATE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    @Test
    public void testUpdateNodeReturnsWeird() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"weird")));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.ACCEPTED.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        try {
            lookupsCommunicator.updateNode(HostAndPortWithScheme.fromString((String)"localhost"), LOOKUPS_STATE);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateNodeInterrupted() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.ACCEPTED.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        Thread.currentThread().interrupt();
        try {
            lookupsCommunicator.updateNode(HostAndPortWithScheme.fromString((String)"localhost"), LOOKUPS_STATE);
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Thread.interrupted();
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    @Test
    public void testGetLookupsStateNodeWithSuccess() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)this.mapper.writeValueAsString(LOOKUPS_STATE))));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.OK.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        LookupsState resp = lookupsCommunicator.getLookupStateForNode(HostAndPortWithScheme.fromString((String)"localhost"));
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
        Assert.assertEquals((Object)resp, LOOKUPS_STATE);
    }

    @Test
    public void testGetLookupsStateNodeRespondedWithNotOkErrorCode() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"server failed")));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        try {
            lookupsCommunicator.getLookupStateForNode(HostAndPortWithScheme.fromString((String)"localhost"));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    @Test
    public void testGetLookupsStateNodeReturnsWeird() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        future.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"weird")));
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.ACCEPTED.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        try {
            lookupsCommunicator.getLookupStateForNode(HostAndPortWithScheme.fromString((String)"localhost"));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetLookupsStateNodeInterrupted() throws Exception {
        final HttpResponseHandler responseHandler = (HttpResponseHandler)EasyMock.createStrictMock(HttpResponseHandler.class);
        SettableFuture future = SettableFuture.create();
        EasyMock.expect((Object)this.client.go((Request)EasyMock.anyObject(), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject())).andReturn((Object)future).once();
        EasyMock.replay((Object[])new Object[]{this.client, responseHandler});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = new LookupCoordinatorManager.LookupsCommunicator(this.client, this.lookupCoordinatorManagerConfig, this.mapper){

            HttpResponseHandler<InputStream, InputStream> makeResponseHandler(AtomicInteger returnCode, AtomicReference<String> reasonString) {
                returnCode.set(Response.Status.ACCEPTED.getStatusCode());
                reasonString.set("");
                return responseHandler;
            }
        };
        Thread.currentThread().interrupt();
        try {
            lookupsCommunicator.getLookupStateForNode(HostAndPortWithScheme.fromString((String)"localhost"));
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Thread.interrupted();
        }
        EasyMock.verify((Object[])new Object[]{this.client, responseHandler});
    }

    @Test
    public void testUpdateLookupsFailsUnitialized() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return null;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        this.expectedException.expect(ISE.class);
        manager.updateLookups(TIERED_LOOKUP_MAP_V0, auditInfo);
    }

    @Test
    public void testUpdateLookupsInitialization() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return null;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq(EMPTY_TIERED_LOOKUP), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        manager.updateLookups(EMPTY_TIERED_LOOKUP, auditInfo);
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testUpdateLookupAdds() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return EMPTY_TIERED_LOOKUP;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq(TIERED_LOOKUP_MAP_V0), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        manager.updateLookup(LOOKUP_TIER, SINGLE_LOOKUP_NAME, SINGLE_LOOKUP_SPEC_V0, auditInfo);
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testUpdateLookupsAddsNewLookup() {
        final LookupExtractorFactoryMapContainer ignore = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"prop", (Object)"old"));
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo1", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"prop", (Object)"old"))), (Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore));
            }
        };
        manager.start();
        LookupExtractorFactoryMapContainer newSpec = new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"prop", (Object)"new"));
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo1", (Object)ignore, (Object)"foo2", (Object)newSpec), (Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore))), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.updateLookups((Map)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo2", (Object)newSpec)), auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testUpdateLookupsOnlyUpdatesToTier() {
        final LookupExtractorFactoryMapContainer ignore = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"prop", (Object)"old"));
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"prop", (Object)"new"))), (Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore));
            }
        };
        manager.start();
        LookupExtractorFactoryMapContainer newSpec = new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"prop", (Object)"new"));
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo", (Object)newSpec), (Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore))), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.updateLookups((Map)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo", (Object)newSpec)), auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testUpdateLookupsUpdates() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return TIERED_LOOKUP_MAP_V0;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq(TIERED_LOOKUP_MAP_V1), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        manager.updateLookups(TIERED_LOOKUP_MAP_V1, auditInfo);
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testUpdateLookupFailsSameVersionUpdates() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return TIERED_LOOKUP_MAP_V0;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        try {
            manager.updateLookups(TIERED_LOOKUP_MAP_V0, auditInfo);
            Assert.fail();
        }
        catch (IAE iAE) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateLookupsAddsNewTier() {
        final LookupExtractorFactoryMapContainer ignore = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"prop", (Object)"old"));
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore));
            }
        };
        manager.start();
        LookupExtractorFactoryMapContainer newSpec = new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"prop", (Object)"new"));
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo", (Object)newSpec), (Object)"lookup_tier2", (Object)ImmutableMap.of((Object)"ignore", (Object)ignore))), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.updateLookups((Map)ImmutableMap.of((Object)"lookup_tier1", (Object)ImmutableMap.of((Object)"foo", (Object)newSpec)), auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testDeleteTier() {
        final LookupExtractorFactoryMapContainer foo1 = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo1"));
        final LookupExtractorFactoryMapContainer foo2 = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo2"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"foo1", (Object)foo1, (Object)"foo2", (Object)foo2));
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of()), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.deleteTier(LOOKUP_TIER, auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testDeleteLookup() {
        final LookupExtractorFactoryMapContainer ignore = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"ignore"));
        final LookupExtractorFactoryMapContainer lookup = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"foo", (Object)lookup, (Object)"ignore", (Object)ignore));
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)"ignore", (Object)ignore))), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.deleteLookup(LOOKUP_TIER, "foo", auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testDeleteLastLookup() {
        final LookupExtractorFactoryMapContainer lookup = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"foo", (Object)lookup));
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of()), (AuditInfo)EasyMock.eq((Object)auditInfo))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        Assert.assertTrue((boolean)manager.deleteLookup(LOOKUP_TIER, "foo", auditInfo));
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testDeleteLookupIgnoresMissing() {
        final LookupExtractorFactoryMapContainer ignore = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"ignore"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"ignore", (Object)ignore));
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        Assert.assertFalse((boolean)manager.deleteLookup(LOOKUP_TIER, "foo", auditInfo));
    }

    @Test
    public void testDeleteLookupIgnoresNotReady() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return null;
            }
        };
        manager.start();
        AuditInfo auditInfo = new AuditInfo("author", "comment", "localhost");
        Assert.assertFalse((boolean)manager.deleteLookup(LOOKUP_TIER, "foo", auditInfo));
    }

    @Test
    public void testGetLookup() {
        final LookupExtractorFactoryMapContainer lookup = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"foo", (Object)lookup));
            }
        };
        Assert.assertEquals((Object)lookup, (Object)manager.getLookup(LOOKUP_TIER, "foo"));
        Assert.assertNull((Object)manager.getLookup(LOOKUP_TIER, "does not exit"));
        Assert.assertNull((Object)manager.getLookup("not a tier", "foo"));
    }

    @Test
    public void testGetLookupIgnoresMalformed() {
        final LookupExtractorFactoryMapContainer lookup = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"lookup", (Object)"foo"));
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return ImmutableMap.of((Object)LookupCoordinatorManagerTest.LOOKUP_TIER, (Object)ImmutableMap.of((Object)"foo", (Object)lookup, (Object)"bar", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of())));
            }
        };
        Assert.assertEquals((Object)lookup, (Object)manager.getLookup(LOOKUP_TIER, "foo"));
        Assert.assertNull((Object)manager.getLookup(LOOKUP_TIER, "does not exit"));
        Assert.assertNull((Object)manager.getLookup("not a tier", "foo"));
    }

    @Test
    public void testGetLookupIgnoresNotReady() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig){

            public Map<String, Map<String, LookupExtractorFactoryMapContainer>> getKnownLookups() {
                return null;
            }
        };
        Assert.assertNull((Object)manager.getLookup(LOOKUP_TIER, "foo"));
    }

    @Test(timeout=60000L)
    public void testLookupManagementLoop() throws Exception {
        ImmutableMap lookup1 = ImmutableMap.of((Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1")));
        ImmutableMap configuredLookups = ImmutableMap.of((Object)"tier1", (Object)lookup1);
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookupsConfig"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<ImmutableMap>(configuredLookups)).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        HostAndPortWithScheme host1 = HostAndPortWithScheme.fromParts((String)"http", (String)"host1", (int)1234);
        HostAndPortWithScheme host2 = HostAndPortWithScheme.fromParts((String)"http", (String)"host2", (int)3456);
        EasyMock.reset((Object[])new Object[]{this.lookupNodeDiscovery});
        EasyMock.expect((Object)this.lookupNodeDiscovery.getAllTiers()).andReturn((Object)ImmutableSet.of((Object)"tier1")).once();
        EasyMock.expect((Object)this.lookupNodeDiscovery.getNodesInTier("tier1")).andReturn((Object)ImmutableList.of((Object)host1, (Object)host2)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lookupNodeDiscovery});
        LookupCoordinatorManager.LookupsCommunicator lookupsCommunicator = (LookupCoordinatorManager.LookupsCommunicator)EasyMock.createMock(LookupCoordinatorManager.LookupsCommunicator.class);
        EasyMock.expect((Object)lookupsCommunicator.getLookupStateForNode(host1)).andReturn((Object)new LookupsState((Map)ImmutableMap.of((Object)"lookup0", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0"))), null, null)).once();
        LookupsState host1UpdatedState = new LookupsState((Map)lookup1, null, null);
        EasyMock.expect((Object)lookupsCommunicator.updateNode(host1, new LookupsState(null, (Map)lookup1, (Set)ImmutableSet.of((Object)"lookup0")))).andReturn((Object)host1UpdatedState).once();
        EasyMock.expect((Object)lookupsCommunicator.getLookupStateForNode(host2)).andReturn((Object)new LookupsState((Map)ImmutableMap.of((Object)"lookup3", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0")), (Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of((Object)"k0", (Object)"v0"))), null, null)).once();
        LookupsState host2UpdatedState = new LookupsState(null, (Map)lookup1, null);
        EasyMock.expect((Object)lookupsCommunicator.updateNode(host2, new LookupsState(null, (Map)lookup1, (Set)ImmutableSet.of((Object)"lookup3")))).andReturn((Object)host2UpdatedState).once();
        EasyMock.replay((Object[])new Object[]{lookupsCommunicator});
        LookupCoordinatorManagerConfig lookupCoordinatorManagerConfig = new LookupCoordinatorManagerConfig(){

            public long getInitialDelay() {
                return 1L;
            }

            public int getThreadPoolSize() {
                return 2;
            }
        };
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.druidNodeDiscoveryProvider, this.configManager, lookupCoordinatorManagerConfig, lookupsCommunicator, this.lookupNodeDiscovery);
        Assert.assertTrue((boolean)((Map)manager.knownOldState.get()).isEmpty());
        manager.start();
        ImmutableMap expectedKnownState = ImmutableMap.of((Object)host1.getHostAndPort(), (Object)host1UpdatedState, (Object)host2.getHostAndPort(), (Object)host2UpdatedState);
        while (!expectedKnownState.equals(manager.knownOldState.get())) {
            Thread.sleep(100L);
        }
        EasyMock.verify((Object[])new Object[]{this.lookupNodeDiscovery, this.configManager, lookupsCommunicator});
    }

    @Test
    public void testGetToBeLoadedOnNode() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig);
        LookupsState currNodeState = new LookupsState((Map)ImmutableMap.of((Object)"lookup0", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0")), (Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1"))), (Map)ImmutableMap.of((Object)"lookup2", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k2", (Object)"v2")), (Object)"lookup3", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k3", (Object)"v3"))), (Set)ImmutableSet.of((Object)"lookup2", (Object)"lookup4"));
        ImmutableMap stateToBe = ImmutableMap.of((Object)"lookup0", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0")), (Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v2", (Map)ImmutableMap.of((Object)"k1", (Object)"v1")), (Object)"lookup2", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k2", (Object)"v2")));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v2", (Map)ImmutableMap.of((Object)"k1", (Object)"v1")), (Object)"lookup2", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k2", (Object)"v2"))), (Object)manager.getToBeLoadedOnNode(currNodeState, (Map)stateToBe));
    }

    @Test
    public void testToBeDropped() {
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig);
        LookupsState currNodeState = new LookupsState((Map)ImmutableMap.of((Object)"lookup0", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0")), (Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1"))), (Map)ImmutableMap.of((Object)"lookup2", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k2", (Object)"v2")), (Object)"lookup3", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k3", (Object)"v3"))), (Set)ImmutableSet.of((Object)"lookup2", (Object)"lookup4"));
        ImmutableMap stateToBe = ImmutableMap.of((Object)"lookup0", (Object)new LookupExtractorFactoryMapContainer("v1", (Map)ImmutableMap.of((Object)"k0", (Object)"v0")));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"lookup1", (Object)"lookup3"), (Object)manager.getToBeDroppedFromNode(currNodeState, (Map)stateToBe));
    }

    @Test
    public void testStartStop() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookupsConfig"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<Object>(null)).once();
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookups"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<Object>(null)).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig);
        Assert.assertFalse((boolean)manager.isStarted());
        manager.start();
        Assert.assertTrue((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.backgroundManagerIsRunning());
        Assert.assertFalse((boolean)manager.waitForBackgroundTermination(10L));
        manager.stop();
        Assert.assertFalse((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.waitForBackgroundTermination(10L));
        Assert.assertFalse((boolean)manager.backgroundManagerIsRunning());
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testMultipleStartStop() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookupsConfig"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference(Collections.emptyMap())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, this.lookupCoordinatorManagerConfig);
        Assert.assertFalse((boolean)manager.awaitStarted(1L));
        manager.start();
        Assert.assertTrue((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.backgroundManagerIsRunning());
        Assert.assertFalse((boolean)manager.waitForBackgroundTermination(10L));
        manager.stop();
        Assert.assertFalse((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.waitForBackgroundTermination(10L));
        Assert.assertFalse((boolean)manager.backgroundManagerIsRunning());
        manager.start();
        Assert.assertTrue((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.backgroundManagerIsRunning());
        Assert.assertFalse((boolean)manager.waitForBackgroundTermination(10L));
        manager.stop();
        Assert.assertFalse((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.waitForBackgroundTermination(10L));
        Assert.assertFalse((boolean)manager.backgroundManagerIsRunning());
        manager.start();
        Assert.assertTrue((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.backgroundManagerIsRunning());
        Assert.assertFalse((boolean)manager.waitForBackgroundTermination(10L));
        manager.stop();
        Assert.assertFalse((boolean)manager.awaitStarted(1L));
        Assert.assertTrue((boolean)manager.waitForBackgroundTermination(10L));
        Assert.assertFalse((boolean)manager.backgroundManagerIsRunning());
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }

    @Test
    public void testLookupDiscoverAll() {
        ImmutableSet fakeChildren = ImmutableSet.of((Object)"tier1", (Object)"tier2");
        EasyMock.reset((Object[])new Object[]{this.lookupNodeDiscovery});
        EasyMock.expect((Object)this.lookupNodeDiscovery.getAllTiers()).andReturn((Object)fakeChildren).once();
        EasyMock.replay((Object[])new Object[]{this.lookupNodeDiscovery});
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.druidNodeDiscoveryProvider, this.configManager, this.lookupCoordinatorManagerConfig, (LookupCoordinatorManager.LookupsCommunicator)EasyMock.createMock(LookupCoordinatorManager.LookupsCommunicator.class), this.lookupNodeDiscovery);
        manager.start();
        Assert.assertEquals((Object)fakeChildren, (Object)manager.discoverTiers());
        EasyMock.verify((Object[])new Object[]{this.lookupNodeDiscovery});
    }

    @Test
    public void testDiscoverNodesInTier() {
        EasyMock.reset((Object[])new Object[]{this.lookupNodeDiscovery});
        EasyMock.expect((Object)this.lookupNodeDiscovery.getNodesInTier("tier")).andReturn((Object)ImmutableSet.of((Object)HostAndPortWithScheme.fromParts((String)"http", (String)"h1", (int)8080), (Object)HostAndPortWithScheme.fromParts((String)"http", (String)"h2", (int)8080))).once();
        EasyMock.replay((Object[])new Object[]{this.lookupNodeDiscovery});
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.druidNodeDiscoveryProvider, this.configManager, this.lookupCoordinatorManagerConfig, (LookupCoordinatorManager.LookupsCommunicator)EasyMock.createMock(LookupCoordinatorManager.LookupsCommunicator.class), this.lookupNodeDiscovery);
        manager.start();
        Assert.assertEquals((Object)ImmutableSet.of((Object)HostAndPort.fromParts((String)"h1", (int)8080), (Object)HostAndPort.fromParts((String)"h2", (int)8080)), (Object)ImmutableSet.copyOf((Collection)manager.discoverNodesInTier("tier")));
        EasyMock.verify((Object[])new Object[]{this.lookupNodeDiscovery});
    }

    @Test
    public void testBackwardCompatibilityMigration() {
        EasyMock.reset((Object[])new Object[]{this.configManager});
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookupsConfig"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<Object>(null)).once();
        EasyMock.expect((Object)this.configManager.watch((String)EasyMock.eq((Object)"lookups"), (TypeReference)EasyMock.anyObject(), EasyMock.isNull())).andReturn(new AtomicReference<ImmutableMap>(ImmutableMap.of((Object)"tier1", (Object)ImmutableMap.of((Object)"lookup1", (Object)ImmutableMap.of((Object)"k", (Object)"v"))))).once();
        EasyMock.expect((Object)this.configManager.set((String)EasyMock.eq((Object)"lookupsConfig"), EasyMock.eq((Object)ImmutableMap.of((Object)"tier1", (Object)ImmutableMap.of((Object)"lookup1", (Object)new LookupExtractorFactoryMapContainer(null, (Map)ImmutableMap.of((Object)"k", (Object)"v"))))), (AuditInfo)EasyMock.anyObject(AuditInfo.class))).andReturn((Object)ConfigManager.SetResult.ok()).once();
        EasyMock.replay((Object[])new Object[]{this.configManager});
        LookupCoordinatorManager manager = new LookupCoordinatorManager(this.client, this.druidNodeDiscoveryProvider, this.mapper, this.configManager, new LookupCoordinatorManagerConfig(){

            public long getPeriod() {
                return 1L;
            }
        });
        manager.start();
        EasyMock.verify((Object[])new Object[]{this.configManager});
    }
}

