/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.TaskSlotCountStatsMonitor;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskSlotCountStatsMonitorTest {
    private TaskSlotCountStatsProvider statsProvider;

    @Before
    public void setUp() {
        this.statsProvider = new TaskSlotCountStatsProvider(){

            public Map<String, Long> getTotalTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getIdleTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getUsedTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getLazyTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getBlacklistedTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }
        };
    }

    @Test
    public void testMonitor() {
        TaskSlotCountStatsMonitor monitor = new TaskSlotCountStatsMonitor(this.statsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getEvents().size());
        Assert.assertEquals((Object)"taskSlot/total/count", (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1L, (Object)((Event)emitter.getEvents().get(0)).toMap().get((Object)"value"));
        Assert.assertEquals((Object)"taskSlot/idle/count", (Object)((Event)emitter.getEvents().get(1)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1L, (Object)((Event)emitter.getEvents().get(1)).toMap().get((Object)"value"));
        Assert.assertEquals((Object)"taskSlot/used/count", (Object)((Event)emitter.getEvents().get(2)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1L, (Object)((Event)emitter.getEvents().get(2)).toMap().get((Object)"value"));
        Assert.assertEquals((Object)"taskSlot/lazy/count", (Object)((Event)emitter.getEvents().get(3)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1L, (Object)((Event)emitter.getEvents().get(3)).toMap().get((Object)"value"));
        Assert.assertEquals((Object)"taskSlot/blacklisted/count", (Object)((Event)emitter.getEvents().get(4)).toMap().get((Object)"metric"));
        Assert.assertEquals((Object)1L, (Object)((Event)emitter.getEvents().get(4)).toMap().get((Object)"value"));
    }
}

