/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HiLoQueryLaningStrategyTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Druids.TimeseriesQueryBuilder queryBuilder;
    private HiLoQueryLaningStrategy strategy;

    @Before
    public void setup() {
        this.queryBuilder = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).granularity(Granularities.DAY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("count")});
        this.strategy = new HiLoQueryLaningStrategy(Integer.valueOf(40));
    }

    @Test
    public void testMaxPercentageThreadsRequired() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("maxLowPercent must be set");
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(null);
    }

    @Test
    public void testMaxLowPercentMustBeGreaterThanZero() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("maxLowPercent must be in the range 1 to 100");
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(Integer.valueOf(-1));
    }

    @Test
    public void testMaxLowPercentMustBeLessThanOrEqual100() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("maxLowPercent must be in the range 1 to 100");
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(Integer.valueOf(9000));
    }

    @Test
    public void testMaxLowPercentZero() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("maxLowPercent must be in the range 1 to 100");
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(Integer.valueOf(0));
    }

    @Test
    public void testMaxLowPercent100() {
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(Integer.valueOf(100));
        Object2IntMap laneConfig = strategy.getLaneLimits(25);
        Assert.assertEquals((long)1L, (long)laneConfig.size());
        Assert.assertTrue((boolean)laneConfig.containsKey((Object)"low"));
        Assert.assertEquals((long)25L, (long)laneConfig.getInt((Object)"low"));
    }

    @Test
    public void testMaxLowPercentRoundsUp() {
        HiLoQueryLaningStrategy strategyRoundLow = new HiLoQueryLaningStrategy(Integer.valueOf(1));
        Object2IntMap laneConfigRoundLow = strategyRoundLow.getLaneLimits(25);
        Assert.assertEquals((long)1L, (long)laneConfigRoundLow.size());
        Assert.assertTrue((boolean)laneConfigRoundLow.containsKey((Object)"low"));
        Assert.assertEquals((long)1L, (long)laneConfigRoundLow.getInt((Object)"low"));
        HiLoQueryLaningStrategy strategy = new HiLoQueryLaningStrategy(Integer.valueOf(96));
        Object2IntMap laneConfig = strategy.getLaneLimits(25);
        Assert.assertEquals((long)1L, (long)laneConfig.size());
        Assert.assertTrue((boolean)laneConfig.containsKey((Object)"low"));
        Assert.assertEquals((long)24L, (long)laneConfig.getInt((Object)"low"));
        HiLoQueryLaningStrategy strategyRounded = new HiLoQueryLaningStrategy(Integer.valueOf(97));
        Object2IntMap laneConfigRounded = strategyRounded.getLaneLimits(25);
        Assert.assertEquals((long)1L, (long)laneConfigRounded.size());
        Assert.assertTrue((boolean)laneConfigRounded.containsKey((Object)"low"));
        Assert.assertEquals((long)25L, (long)laneConfigRounded.getInt((Object)"low"));
    }

    @Test
    public void testLaneLimits() {
        Object2IntMap laneConfig = this.strategy.getLaneLimits(5);
        Assert.assertEquals((long)1L, (long)laneConfig.size());
        Assert.assertTrue((boolean)laneConfig.containsKey((Object)"low"));
        Assert.assertEquals((long)2L, (long)laneConfig.getInt((Object)"low"));
    }

    @Test
    public void testLaningNoPriority() {
        TimeseriesQuery query = this.queryBuilder.build();
        Assert.assertFalse((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testLaningZeroPriority() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)0)).build();
        Assert.assertFalse((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testLaningInteractivePriority() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)100)).build();
        Assert.assertFalse((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testLaningInteractivePriority_String() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)"100")).build();
        Assert.assertFalse((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
    }

    @Test
    public void testLaningLowPriority() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)-1)).build();
        Assert.assertTrue((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
        Assert.assertEquals((Object)"low", this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }

    @Test
    public void testLaningLowPriority_String() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)"-1")).build();
        Assert.assertTrue((boolean)this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).isPresent());
        Assert.assertEquals((Object)"low", this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }

    @Test
    public void testLaningPreservesManualSetLane() {
        TimeseriesQuery query = this.queryBuilder.context((Map)ImmutableMap.of((Object)"priority", (Object)100, (Object)"lane", (Object)"low")).build();
        Assert.assertEquals((Object)"low", this.strategy.computeLane(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of()).get());
    }
}

