/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.utils.CollectionUtils;

public class DataSourcesSnapshot {
    private final Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> usedSegmentsTimelinesPerDataSource;
    private final ImmutableSet<SegmentId> overshadowedSegments;

    public static DataSourcesSnapshot fromUsedSegments(Iterable<DataSegment> segments, ImmutableMap<String, String> dataSourceProperties) {
        HashMap dataSources = new HashMap();
        segments.forEach(segment -> dataSources.computeIfAbsent(segment.getDataSource(), dsName -> new DruidDataSource((String)dsName, (Map<String, String>)dataSourceProperties)).addSegmentIfAbsent((DataSegment)segment));
        return new DataSourcesSnapshot(CollectionUtils.mapValues(dataSources, DruidDataSource::toImmutableDruidDataSource));
    }

    public static DataSourcesSnapshot fromUsedSegmentsTimelines(Map<String, VersionedIntervalTimeline<String, DataSegment>> usedSegmentsTimelinesPerDataSource, ImmutableMap<String, String> dataSourceProperties) {
        HashMap dataSourcesWithAllUsedSegments = Maps.newHashMapWithExpectedSize((int)usedSegmentsTimelinesPerDataSource.size());
        usedSegmentsTimelinesPerDataSource.forEach((dataSourceName, usedSegmentsTimeline) -> {
            DruidDataSource dataSource = new DruidDataSource((String)dataSourceName, (Map<String, String>)dataSourceProperties);
            usedSegmentsTimeline.iterateAllObjects().forEach(dataSource::addSegment);
            dataSourcesWithAllUsedSegments.put(dataSourceName, dataSource.toImmutableDruidDataSource());
        });
        return new DataSourcesSnapshot(dataSourcesWithAllUsedSegments, usedSegmentsTimelinesPerDataSource);
    }

    public DataSourcesSnapshot(Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments) {
        this(dataSourcesWithAllUsedSegments, CollectionUtils.mapValues(dataSourcesWithAllUsedSegments, dataSource -> VersionedIntervalTimeline.forSegments(dataSource.getSegments())));
    }

    private DataSourcesSnapshot(Map<String, ImmutableDruidDataSource> dataSourcesWithAllUsedSegments, Map<String, VersionedIntervalTimeline<String, DataSegment>> usedSegmentsTimelinesPerDataSource) {
        this.dataSourcesWithAllUsedSegments = dataSourcesWithAllUsedSegments;
        this.usedSegmentsTimelinesPerDataSource = usedSegmentsTimelinesPerDataSource;
        this.overshadowedSegments = ImmutableSet.copyOf(this.determineOvershadowedSegments());
    }

    public Collection<ImmutableDruidDataSource> getDataSourcesWithAllUsedSegments() {
        return this.dataSourcesWithAllUsedSegments.values();
    }

    public Map<String, ImmutableDruidDataSource> getDataSourcesMap() {
        return this.dataSourcesWithAllUsedSegments;
    }

    @Nullable
    public ImmutableDruidDataSource getDataSource(String dataSourceName) {
        return this.dataSourcesWithAllUsedSegments.get(dataSourceName);
    }

    public Map<String, VersionedIntervalTimeline<String, DataSegment>> getUsedSegmentsTimelinesPerDataSource() {
        return this.usedSegmentsTimelinesPerDataSource;
    }

    public ImmutableSet<SegmentId> getOvershadowedSegments() {
        return this.overshadowedSegments;
    }

    public Iterable<DataSegment> iterateAllUsedSegmentsInSnapshot() {
        return () -> this.dataSourcesWithAllUsedSegments.values().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator();
    }

    private List<SegmentId> determineOvershadowedSegments() {
        ArrayList<SegmentId> overshadowedSegments = new ArrayList<SegmentId>();
        for (ImmutableDruidDataSource dataSource : this.dataSourcesWithAllUsedSegments.values()) {
            VersionedIntervalTimeline<String, DataSegment> usedSegmentsTimeline = this.usedSegmentsTimelinesPerDataSource.get(dataSource.getName());
            for (DataSegment segment : dataSource.getSegments()) {
                if (!usedSegmentsTimeline.isOvershadowed(segment.getInterval(), (Object)segment.getVersion(), (Overshadowable)segment)) continue;
                overshadowedSegments.add(segment.getId());
            }
        }
        return overshadowedSegments;
    }
}

