/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.plumber.FlushingPlumber;
import org.apache.druid.segment.realtime.plumber.Plumber;
import org.apache.druid.segment.realtime.plumber.RealtimePlumberSchool;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.joda.time.Duration;

public class FlushingPlumberSchool
extends RealtimePlumberSchool {
    private static final Duration DEFAULT_FLUSH_DURATION = new Duration((Object)"PT1H");
    private final Duration flushDuration;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final QueryProcessingPool queryProcessingPool;
    private final JoinableFactory joinableFactory;
    private final IndexMergerV9 indexMergerV9;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final ObjectMapper objectMapper;

    @JsonCreator
    public FlushingPlumberSchool(@JsonProperty(value="flushDuration") Duration flushDuration, @JacksonInject ServiceEmitter emitter, @JacksonInject QueryRunnerFactoryConglomerate conglomerate, @JacksonInject DataSegmentAnnouncer segmentAnnouncer, @JacksonInject QueryProcessingPool queryProcessingPool, @JacksonInject JoinableFactory joinableFactory, @JacksonInject IndexMergerV9 indexMergerV9, @JacksonInject IndexIO indexIO, @JacksonInject Cache cache, @JacksonInject CacheConfig cacheConfig, @JacksonInject CachePopulatorStats cachePopulatorStats, @JacksonInject ObjectMapper objectMapper) {
        super(emitter, conglomerate, null, segmentAnnouncer, null, null, queryProcessingPool, joinableFactory, indexMergerV9, indexIO, cache, cacheConfig, cachePopulatorStats, objectMapper);
        this.flushDuration = flushDuration == null ? DEFAULT_FLUSH_DURATION : flushDuration;
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryProcessingPool = queryProcessingPool;
        this.joinableFactory = joinableFactory;
        this.indexMergerV9 = (IndexMergerV9)Preconditions.checkNotNull((Object)indexMergerV9, (Object)"Null IndexMergerV9");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.objectMapper = objectMapper;
    }

    @Override
    public Plumber findPlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics) {
        this.verifyState();
        return new FlushingPlumber(this.flushDuration, schema, config, metrics, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryProcessingPool, this.joinableFactory, (IndexMerger)this.indexMergerV9, this.indexIO, this.cache, this.cacheConfig, this.cachePopulatorStats, this.objectMapper);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

