/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.CatalogTest;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CatalogTest.class})
public class PropertyDefnTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testString() {
        ModelProperties.StringPropertyDefn prop = new ModelProperties.StringPropertyDefn("prop");
        Assert.assertEquals((Object)"prop", (Object)prop.name());
        Assert.assertEquals((Object)"String", (Object)prop.typeName());
        Assert.assertNull((Object)prop.decode(null, this.mapper));
        Assert.assertEquals((Object)"value", (Object)prop.decode((Object)"value", this.mapper));
        prop.validate((Object)"value", this.mapper);
        Assert.assertEquals((Object)"10", (Object)prop.decode((Object)10, this.mapper));
        prop.validate((Object)10, this.mapper);
        Assert.assertThrows(Exception.class, () -> {
            String cfr_ignored_0 = (String)prop.decode(Arrays.asList("a", "b"), this.mapper);
        });
        Assert.assertThrows(Exception.class, () -> prop.validate(Arrays.asList("a", "b"), this.mapper));
    }

    @Test
    public void testBoolean() {
        ModelProperties.BooleanPropertyDefn prop = new ModelProperties.BooleanPropertyDefn("prop");
        Assert.assertEquals((Object)"prop", (Object)prop.name());
        Assert.assertEquals((Object)"Boolean", (Object)prop.typeName());
        Assert.assertNull((Object)prop.decode(null, this.mapper));
        Assert.assertTrue((boolean)((Boolean)prop.decode((Object)"true", this.mapper)));
        Assert.assertTrue((boolean)((Boolean)prop.decode((Object)true, this.mapper)));
        Assert.assertFalse((boolean)((Boolean)prop.decode((Object)"false", this.mapper)));
        Assert.assertFalse((boolean)((Boolean)prop.decode((Object)false, this.mapper)));
        Assert.assertFalse((boolean)((Boolean)prop.decode((Object)0, this.mapper)));
        Assert.assertTrue((boolean)((Boolean)prop.decode((Object)10, this.mapper)));
    }

    @Test
    public void testInt() {
        ModelProperties.IntPropertyDefn prop = new ModelProperties.IntPropertyDefn("prop");
        Assert.assertEquals((Object)"prop", (Object)prop.name());
        Assert.assertEquals((Object)"Integer", (Object)prop.typeName());
        Assert.assertNull((Object)prop.decode(null, this.mapper));
        Assert.assertEquals((Object)0, (Object)prop.decode((Object)0, this.mapper));
        Assert.assertEquals((Object)0, (Object)prop.decode((Object)"0", this.mapper));
        Assert.assertEquals((Object)10, (Object)prop.decode((Object)10, this.mapper));
        Assert.assertEquals((Object)10, (Object)prop.decode((Object)"10", this.mapper));
        Assert.assertThrows(Exception.class, () -> {
            Integer cfr_ignored_0 = (Integer)prop.decode((Object)"foo", this.mapper);
        });
    }

    @Test
    public void testStringList() {
        ModelProperties.StringListPropertyDefn prop = new ModelProperties.StringListPropertyDefn("prop");
        Assert.assertEquals((Object)"prop", (Object)prop.name());
        Assert.assertEquals((Object)"string list", (Object)prop.typeName());
        Assert.assertNull((Object)prop.decode(null, this.mapper));
        prop.validate(null, this.mapper);
        List<String> value = Arrays.asList("a", "b");
        Assert.assertEquals(value, (Object)prop.decode(value, this.mapper));
        prop.validate(value, this.mapper);
        Assert.assertThrows(Exception.class, () -> {
            List cfr_ignored_0 = (List)prop.decode((Object)"foo", this.mapper);
        });
        Assert.assertThrows(Exception.class, () -> prop.validate((Object)"foo", this.mapper));
    }

    @Test
    public void testClusterKeyList() {
        ModelProperties.ListPropertyDefn prop = new ModelProperties.ListPropertyDefn("prop", "cluster key list", (TypeReference)new TypeReference<List<ClusterKeySpec>>(){});
        Assert.assertEquals((Object)"prop", (Object)prop.name());
        Assert.assertEquals((Object)"cluster key list", (Object)prop.typeName());
        Assert.assertNull((Object)prop.decode(null, this.mapper));
        List<Map> value = Arrays.asList(ImmutableMap.of((Object)"column", (Object)"a"), ImmutableMap.of((Object)"column", (Object)"b", (Object)"desc", (Object)true));
        List<ClusterKeySpec> expected = Arrays.asList(new ClusterKeySpec("a", Boolean.valueOf(false)), new ClusterKeySpec("b", Boolean.valueOf(true)));
        Assert.assertEquals(expected, (Object)prop.decode(value, this.mapper));
        Assert.assertThrows(Exception.class, () -> {
            List cfr_ignored_0 = (List)prop.decode((Object)"foo", this.mapper);
        });
    }
}

