/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.druid.query.lookup.LookupModule;
import org.apache.druid.server.DruidNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LookupListeningAnnouncerConfigTest {
    private static final String PROPERTY_BASE = "some.property";
    private final Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

        public void configure(Binder binder) {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, false, null, null, true, false));
            binder.bind(Key.get(String.class, (Annotation)Names.named((String)"druidDataSource"))).toInstance((Object)"some_datasource");
        }
    }, (Object)new LookupModule()));
    private final Properties properties = (Properties)this.injector.getInstance(Properties.class);

    @Before
    public void setUp() {
        this.properties.clear();
    }

    @Test
    public void testDefaultInjection() {
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        configProvider.inject(this.properties, configurator);
        LookupListeningAnnouncerConfig config = (LookupListeningAnnouncerConfig)configProvider.get().get();
        Assert.assertEquals((Object)"__default", (Object)config.getLookupTier());
    }

    @Test
    public void testSimpleInjection() {
        String lookupTier = "some_tier";
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        this.properties.put("some.property.lookupTier", "some_tier");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        configProvider.inject(this.properties, configurator);
        LookupListeningAnnouncerConfig config = (LookupListeningAnnouncerConfig)configProvider.get().get();
        Assert.assertEquals((Object)"some_tier", (Object)config.getLookupTier());
    }

    @Test(expected=NullPointerException.class)
    public void testFailsOnEmptyTier() {
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        this.properties.put("some.property.lookupTier", "");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        configProvider.inject(this.properties, configurator);
        LookupListeningAnnouncerConfig config = (LookupListeningAnnouncerConfig)configProvider.get().get();
        config.getLookupTier();
    }

    @Test
    public void testDatasourceInjection() {
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        this.properties.put("some.property.lookupTierIsDatasource", "true");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        configProvider.inject(this.properties, configurator);
        LookupListeningAnnouncerConfig config = (LookupListeningAnnouncerConfig)configProvider.get().get();
        Assert.assertEquals((Object)"some_datasource", (Object)config.getLookupTier());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsInjection() {
        String lookupTier = "some_tier";
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        this.properties.put("some.property.lookupTier", "some_tier");
        this.properties.put("some.property.lookupTierIsDatasource", "true");
        JsonConfigProvider configProvider = JsonConfigProvider.of((String)PROPERTY_BASE, LookupListeningAnnouncerConfig.class);
        configProvider.inject(this.properties, configurator);
        LookupListeningAnnouncerConfig config = (LookupListeningAnnouncerConfig)configProvider.get().get();
        Assert.assertEquals((Object)"some_tier", (Object)config.getLookupTier());
    }
}

