/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheLoader;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.TombstoneLoadSpec;
import org.apache.druid.segment.loading.TombstoneSegmentizerFactory;
import org.apache.druid.server.coordination.TestStorageLocation;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentLocalCacheLoaderTest {
    private static final long MAX_SIZE = 1000L;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TestStorageLocation storageLoc;
    private ObjectMapper objectMapper;
    private SegmentLocalCacheLoader segmentLocalCacheLoader;

    @Before
    public void setUp() throws IOException {
        this.storageLoc = new TestStorageLocation(this.temporaryFolder);
        SegmentLoaderConfig config = new SegmentLoaderConfig().withLocations(Collections.singletonList(this.storageLoc.toStorageLocationConfig(1000L, null))).withInfoDir(this.storageLoc.getInfoDir());
        this.objectMapper = TestHelper.makeJsonMapper();
        this.objectMapper.registerSubtypes(new Class[]{TombstoneLoadSpec.class});
        this.objectMapper.registerSubtypes(new Class[]{TombstoneSegmentizerFactory.class});
        SegmentLocalCacheManager cacheManager = new SegmentLocalCacheManager(config, this.objectMapper);
        this.segmentLocalCacheLoader = new SegmentLocalCacheLoader((SegmentCacheManager)cacheManager, null, this.objectMapper);
        TombstoneLoadSpec.writeFactoryFile((File)this.storageLoc.getCacheDir());
    }

    @Test
    public void testGetSegmentWithTombstones() throws SegmentLoadingException {
        Interval interval = Intervals.of((String)"2014-01-01/2014-01-02");
        DataSegment tombstone = new DataSegment("foo", interval, "version", (Map)ImmutableMap.of((Object)"type", (Object)"tombstone"), null, null, (ShardSpec)new TombstoneShardSpec(), null, 0L);
        ReferenceCountingSegment segment = this.segmentLocalCacheLoader.getSegment(tombstone, false, null);
        Assert.assertNotNull((Object)segment.getId());
        Assert.assertEquals((Object)interval, (Object)segment.getDataInterval());
        Assert.assertNotNull((Object)segment.asStorageAdapter());
        Assert.assertTrue((boolean)segment.asQueryableIndex().isFromTombstone());
        Assert.assertEquals((Object)interval, (Object)segment.asQueryableIndex().getDataInterval());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getMetadata());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getNumRows());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getAvailableDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getBitmapFactoryForDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getDimensionHandlers());
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getColumnHolder(null));
        Assert.assertThrows(UnsupportedOperationException.class, () -> segment.asQueryableIndex().getColumnHolder(null));
    }
}

