/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.ForwardingQueryProcessingPool;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.query.timeseries.TimeseriesQueryQueryToolChest;
import org.apache.druid.query.timeseries.TimeseriesQueryRunnerFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.NoopJoinableFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.NoopDataSegmentAnnouncer;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;

public class StreamAppenderatorTester
implements AutoCloseable {
    public static final String DATASOURCE = "foo";
    private final DataSchema schema;
    private final RealtimeTuningConfig tuningConfig;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final Appenderator appenderator;
    private final ExecutorService queryExecutor;
    private final ServiceEmitter emitter;
    private final List<DataSegment> pushedSegments = new CopyOnWriteArrayList<DataSegment>();

    public StreamAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, File basePersistDirectory, final boolean enablePushFailure, RowIngestionMeters rowIngestionMeters, boolean skipBytesInMemoryOverheadCheck) {
        this.objectMapper = new DefaultObjectMapper();
        this.objectMapper.registerSubtypes(new Class[]{LinearShardSpec.class});
        Map parserMap = (Map)this.objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), DimensionsSpec.EMPTY, null, null, null)), Map.class);
        this.schema = new DataSchema(DATASOURCE, parserMap, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null, this.objectMapper);
        this.tuningConfig = new RealtimeTuningConfig(null, Integer.valueOf(maxRowsInMemory), Long.valueOf(maxSizeInBytes == 0L ? this.getDefaultMaxBytesInMemory() : maxSizeInBytes), Boolean.valueOf(skipBytesInMemoryOverheadCheck), null, null, basePersistDirectory, null, null, null, null, null, null, 0, 0, null, null, null, null, null);
        this.metrics = new FireDepartmentMetrics();
        this.queryExecutor = Execs.singleThreaded((String)"queryExecutor(%d)");
        IndexIO indexIO = new IndexIO(this.objectMapper, new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        IndexMergerV9 indexMerger = new IndexMergerV9(this.objectMapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.emitter = new ServiceEmitter("test", "test", (Emitter)new NoopEmitter());
        this.emitter.start();
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.dataSegmentPusher = new DataSegmentPusher(){
            private boolean mustFail = true;

            @Deprecated
            public String getPathForHadoop(String dataSource) {
                return this.getPathForHadoop();
            }

            public String getPathForHadoop() {
                throw new UnsupportedOperationException();
            }

            public DataSegment push(File file, DataSegment segment, boolean useUniquePath) throws IOException {
                if (enablePushFailure && this.mustFail) {
                    this.mustFail = false;
                    throw new IOException("Push failure test");
                }
                if (enablePushFailure) {
                    this.mustFail = true;
                }
                StreamAppenderatorTester.this.pushedSegments.add(segment);
                return segment;
            }

            public Map<String, Object> makeLoadSpec(URI uri) {
                throw new UnsupportedOperationException();
            }
        };
        this.appenderator = Appenderators.createRealtime((String)this.schema.getDataSource(), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (FireDepartmentMetrics)this.metrics, (DataSegmentPusher)this.dataSegmentPusher, (ObjectMapper)this.objectMapper, (IndexIO)indexIO, (IndexMerger)indexMerger, (QueryRunnerFactoryConglomerate)new DefaultQueryRunnerFactoryConglomerate((Map)ImmutableMap.of(TimeseriesQuery.class, (Object)new TimeseriesQueryRunnerFactory(new TimeseriesQueryQueryToolChest(), new TimeseriesQueryEngine(), QueryRunnerTestHelper.NOOP_QUERYWATCHER), ScanQuery.class, (Object)new ScanQueryRunnerFactory(new ScanQueryQueryToolChest(new ScanQueryConfig(), (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory()), new ScanQueryEngine(), new ScanQueryConfig()))), (DataSegmentAnnouncer)new NoopDataSegmentAnnouncer(), (ServiceEmitter)this.emitter, (QueryProcessingPool)new ForwardingQueryProcessingPool(this.queryExecutor), (JoinableFactory)NoopJoinableFactory.INSTANCE, (Cache)MapCache.create((long)2048L), (CacheConfig)new CacheConfig(), (CachePopulatorStats)new CachePopulatorStats(), (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)true);
    }

    private long getDefaultMaxBytesInMemory() {
        return Runtime.getRuntime().totalMemory() / 3L;
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public RealtimeTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }

    public DataSegmentPusher getDataSegmentPusher() {
        return this.dataSegmentPusher;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Appenderator getAppenderator() {
        return this.appenderator;
    }

    public List<DataSegment> getPushedSegments() {
        return this.pushedSegments;
    }

    @Override
    public void close() throws Exception {
        this.appenderator.close();
        this.queryExecutor.shutdownNow();
        this.emitter.close();
        FileUtils.deleteDirectory((File)this.tuningConfig.getBasePersistDirectory());
    }

    public static class Builder {
        private int maxRowsInMemory;
        private long maxSizeInBytes = -1L;
        private File basePersistDirectory;
        private boolean enablePushFailure;
        private RowIngestionMeters rowIngestionMeters;
        private boolean skipBytesInMemoryOverheadCheck;

        public Builder maxRowsInMemory(int maxRowsInMemory) {
            this.maxRowsInMemory = maxRowsInMemory;
            return this;
        }

        public Builder maxSizeInBytes(long maxSizeInBytes) {
            this.maxSizeInBytes = maxSizeInBytes;
            return this;
        }

        public Builder basePersistDirectory(File basePersistDirectory) {
            this.basePersistDirectory = basePersistDirectory;
            return this;
        }

        public Builder enablePushFailure(boolean enablePushFailure) {
            this.enablePushFailure = enablePushFailure;
            return this;
        }

        public Builder rowIngestionMeters(RowIngestionMeters rowIngestionMeters) {
            this.rowIngestionMeters = rowIngestionMeters;
            return this;
        }

        public Builder skipBytesInMemoryOverheadCheck(boolean skipBytesInMemoryOverheadCheck) {
            this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck;
            return this;
        }

        public StreamAppenderatorTester build() {
            return new StreamAppenderatorTester(this.maxRowsInMemory, this.maxSizeInBytes, (File)Preconditions.checkNotNull((Object)this.basePersistDirectory, (Object)"basePersistDirectory"), this.enablePushFailure, (RowIngestionMeters)(this.rowIngestionMeters == null ? new SimpleRowIngestionMeters() : this.rowIngestionMeters), this.skipBytesInMemoryOverheadCheck);
        }
    }
}

