/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.server.audit.SQLAuditManager;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

@RunWith(value=MockitoJUnitRunner.class)
public class SQLAuditManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private AuditManager auditManager;
    private final String PAYLOAD_DIMENSION_KEY = "payload";
    private ConfigSerde<String> stringConfigSerde;
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.connector.createAuditTable();
        this.auditManager = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig());
        this.stringConfigSerde = new ConfigSerde<String>(){

            public byte[] serialize(String obj) {
                try {
                    return SQLAuditManagerTest.this.mapper.writeValueAsBytes((Object)obj);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }

            public String serializeToString(String obj, boolean skipNull) {
                return obj;
            }

            public String deserialize(byte[] bytes) {
                return (String)JacksonUtils.readValue((ObjectMapper)SQLAuditManagerTest.this.mapper, (byte[])bytes, String.class);
            }
        };
    }

    @Test(timeout=60000L)
    public void testAuditEntrySerde() throws IOException {
        AuditEntry entry = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        AuditEntry serde = (AuditEntry)mapper.readValue(mapper.writeValueAsString((Object)entry), AuditEntry.class);
        Assert.assertEquals((Object)entry, (Object)serde);
    }

    @Test
    public void testAuditMetricEventBuilderConfig() {
        AuditEntry entry = new AuditEntry("testKey", "testType", new AuditInfo("testAuthor", "testComment", "127.0.0.1"), "testPayload", DateTimes.of((String)"2013-01-01T00:00:00Z"));
        SQLAuditManager auditManagerWithPayloadAsDimension = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig(){

            public boolean getIncludePayloadAsDimensionInMetric() {
                return true;
            }
        });
        ServiceMetricEvent.Builder auditEntryBuilder = ((SQLAuditManager)this.auditManager).getAuditMetricEventBuilder(entry);
        Assert.assertEquals(null, (Object)auditEntryBuilder.getDimension("payload"));
        ServiceMetricEvent.Builder auditEntryBuilderWithPayload = auditManagerWithPayloadAsDimension.getAuditMetricEventBuilder(entry);
        Assert.assertEquals((Object)"testPayload", (Object)auditEntryBuilderWithPayload.getDimension("payload"));
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntry() throws IOException {
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistory() {
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        List auditEntries = this.auditManager.fetchAuditHistory("testKey", "testType", Intervals.of((String)"2000-01-01T00:00:00Z/2100-01-03T00:00:00Z"));
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry1Key, (Object)((AuditEntry)auditEntries.get(0)).getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)((AuditEntry)auditEntries.get(0)).getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)((AuditEntry)auditEntries.get(0)).getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)((AuditEntry)auditEntries.get(0)).getAuditInfo());
        Assert.assertEquals((Object)entry1Key, (Object)((AuditEntry)auditEntries.get(1)).getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)((AuditEntry)auditEntries.get(1)).getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)((AuditEntry)auditEntries.get(1)).getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)((AuditEntry)auditEntries.get(1)).getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByKeyAndTypeWithLimit() {
        String entry1Key = "testKey1";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload";
        String entry2Key = "testKey2";
        String entry2Type = "testType";
        AuditInfo entry2AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry2Payload = "testPayload";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        this.auditManager.doAudit(entry2Key, entry2Type, entry2AuditInfo, (Object)entry2Payload, this.stringConfigSerde);
        List auditEntries = this.auditManager.fetchAuditHistory("testKey1", "testType", 1);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry1Key, (Object)((AuditEntry)auditEntries.get(0)).getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)((AuditEntry)auditEntries.get(0)).getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)((AuditEntry)auditEntries.get(0)).getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)((AuditEntry)auditEntries.get(0)).getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testRemoveAuditLogsOlderThanWithEntryOlderThanTime() throws IOException {
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
        this.auditManager.removeAuditLogsOlderThan(System.currentTimeMillis());
        payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        Assert.assertNull((Object)payload);
    }

    @Test(timeout=60000L)
    public void testRemoveAuditLogsOlderThanWithEntryNotOlderThanTime() throws IOException {
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
        this.auditManager.removeAuditLogsOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis());
        payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByTypeWithLimit() {
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "testPayload1";
        String entry2Key = "testKey";
        String entry2Type = "testType";
        AuditInfo entry2AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry2Payload = "testPayload2";
        String entry3Key = "testKey";
        String entry3Type = "testType";
        AuditInfo entry3AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry3Payload = "testPayload3";
        this.auditManager.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        this.auditManager.doAudit(entry2Key, entry2Type, entry2AuditInfo, (Object)entry2Payload, this.stringConfigSerde);
        this.auditManager.doAudit(entry3Key, entry3Type, entry3AuditInfo, (Object)entry3Payload, this.stringConfigSerde);
        List auditEntries = this.auditManager.fetchAuditHistory("testType", 2);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry3Key, (Object)((AuditEntry)auditEntries.get(0)).getKey());
        Assert.assertEquals((Object)entry3Payload, (Object)((AuditEntry)auditEntries.get(0)).getPayload());
        Assert.assertEquals((Object)entry3Type, (Object)((AuditEntry)auditEntries.get(0)).getType());
        Assert.assertEquals((Object)entry3AuditInfo, (Object)((AuditEntry)auditEntries.get(0)).getAuditInfo());
        Assert.assertEquals((Object)entry2Key, (Object)((AuditEntry)auditEntries.get(1)).getKey());
        Assert.assertEquals((Object)entry2Payload, (Object)((AuditEntry)auditEntries.get(1)).getPayload());
        Assert.assertEquals((Object)entry2Type, (Object)((AuditEntry)auditEntries.get(1)).getType());
        Assert.assertEquals((Object)entry2AuditInfo, (Object)((AuditEntry)auditEntries.get(1)).getAuditInfo());
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitBelowZero() {
        this.auditManager.fetchAuditHistory("testType", -1);
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitZero() {
        this.auditManager.fetchAuditHistory("testType", 0);
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithPayloadOverSkipPayloadLimit() throws IOException {
        final int maxPayloadSize = 10;
        SQLAuditManager auditManagerWithMaxPayloadSizeBytes = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig(){

            public long getMaxPayloadSizeBytes() {
                return maxPayloadSize;
            }
        });
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "payload audit to store";
        auditManagerWithMaxPayloadSizeBytes.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertNotEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)StringUtils.format((String)"Payload was not stored as its size exceeds the limit [%d] configured by druid.audit.manager.maxPayloadSizeBytes", (Object[])new Object[]{maxPayloadSize}), (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithPayloadUnderSkipPayloadLimit() throws IOException {
        SQLAuditManager auditManagerWithMaxPayloadSizeBytes = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig(){

            public long getMaxPayloadSizeBytes() {
                return 500L;
            }
        });
        String entry1Key = "testKey";
        String entry1Type = "testType";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        String entry1Payload = "payload audit to store";
        auditManagerWithMaxPayloadSizeBytes.doAudit(entry1Key, entry1Type, entry1AuditInfo, (Object)entry1Payload, this.stringConfigSerde);
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", "testKey");
        AuditEntry dbEntry = (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
        Assert.assertEquals((Object)entry1Key, (Object)dbEntry.getKey());
        Assert.assertEquals((Object)entry1Payload, (Object)dbEntry.getPayload());
        Assert.assertEquals((Object)entry1Type, (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry1AuditInfo, (Object)dbEntry.getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithSkipNullConfigTrue() {
        ConfigSerde mockConfigSerde = (ConfigSerde)Mockito.mock(ConfigSerde.class);
        SQLAuditManager auditManagerWithSkipNull = new SQLAuditManager((SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig(){

            public boolean isSkipNullField() {
                return true;
            }
        });
        String entry1Key = "test1Key";
        String entry1Type = "test1Type";
        AuditInfo entry1AuditInfo = new AuditInfo("testAuthor", "testComment", "127.0.0.1");
        HashMap<String, String> entryPayload1WithNull = new HashMap<String, String>();
        entryPayload1WithNull.put("version", "x");
        entryPayload1WithNull.put("something", null);
        auditManagerWithSkipNull.doAudit(entry1Key, entry1Type, entry1AuditInfo, entryPayload1WithNull, mockConfigSerde);
        ((ConfigSerde)Mockito.verify((Object)mockConfigSerde)).serializeToString(ArgumentMatchers.eq(entryPayload1WithNull), ArgumentMatchers.eq((boolean)true));
    }

    @After
    public void cleanup() {
        this.dropTable(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable());
    }

    private void dropTable(final String tableName) {
        Assert.assertNull((Object)this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        }));
    }
}

