/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.server.ServerTestHelper;
import org.apache.druid.server.coordination.DataSegmentChangeRequest;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.HttpLoadQueuePeon;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.joda.time.Duration;
import org.junit.Test;

public class HttpLoadQueuePeonTest {
    final DataSegment segment1 = new DataSegment("test1", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
    final DataSegment segment2 = new DataSegment("test2", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
    final DataSegment segment3 = new DataSegment("test3", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
    final DataSegment segment4 = new DataSegment("test4", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
    final TestDruidCoordinatorConfig config = new TestDruidCoordinatorConfig.Builder().withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).withHttpLoadQueuePeonBatchSize(2).build();

    @Test(timeout=60000L)
    public void testSimple() throws Exception {
        HttpLoadQueuePeon httpLoadQueuePeon = new HttpLoadQueuePeon("http://dummy:4000", ServerTestHelper.MAPPER, (HttpClient)new TestHttpClient(), (DruidCoordinatorConfig)this.config, Executors.newScheduledThreadPool(2, Execs.makeThreadFactory((String)"HttpLoadQueuePeonTest-%s")), Execs.singleThreaded((String)"HttpLoadQueuePeonTest"));
        httpLoadQueuePeon.start();
        ImmutableMap latches = ImmutableMap.of((Object)this.segment1.getId(), (Object)new CountDownLatch(1), (Object)this.segment2.getId(), (Object)new CountDownLatch(1), (Object)this.segment3.getId(), (Object)new CountDownLatch(1), (Object)this.segment4.getId(), (Object)new CountDownLatch(1));
        httpLoadQueuePeon.dropSegment(this.segment1, arg_0 -> this.lambda$testSimple$0((Map)latches, arg_0));
        httpLoadQueuePeon.loadSegment(this.segment2, arg_0 -> this.lambda$testSimple$1((Map)latches, arg_0));
        httpLoadQueuePeon.dropSegment(this.segment3, arg_0 -> this.lambda$testSimple$2((Map)latches, arg_0));
        httpLoadQueuePeon.loadSegment(this.segment4, arg_0 -> this.lambda$testSimple$3((Map)latches, arg_0));
        ((CountDownLatch)latches.get(this.segment1.getId())).await();
        ((CountDownLatch)latches.get(this.segment2.getId())).await();
        ((CountDownLatch)latches.get(this.segment3.getId())).await();
        ((CountDownLatch)latches.get(this.segment4.getId())).await();
        httpLoadQueuePeon.stop();
    }

    @Test(timeout=60000L)
    public void testLoadDropAfterStop() throws Exception {
        HttpLoadQueuePeon httpLoadQueuePeon = new HttpLoadQueuePeon("http://dummy:4000", ServerTestHelper.MAPPER, (HttpClient)new TestHttpClient(), (DruidCoordinatorConfig)this.config, Executors.newScheduledThreadPool(2, Execs.makeThreadFactory((String)"HttpLoadQueuePeonTest-%s")), Execs.singleThreaded((String)"HttpLoadQueuePeonTest"));
        httpLoadQueuePeon.start();
        ImmutableMap latches = ImmutableMap.of((Object)this.segment1.getId(), (Object)new CountDownLatch(1), (Object)this.segment2.getId(), (Object)new CountDownLatch(1), (Object)this.segment3.getId(), (Object)new CountDownLatch(1), (Object)this.segment4.getId(), (Object)new CountDownLatch(1));
        httpLoadQueuePeon.dropSegment(this.segment1, arg_0 -> this.lambda$testLoadDropAfterStop$4((Map)latches, arg_0));
        httpLoadQueuePeon.loadSegment(this.segment2, arg_0 -> this.lambda$testLoadDropAfterStop$5((Map)latches, arg_0));
        ((CountDownLatch)latches.get(this.segment1.getId())).await();
        ((CountDownLatch)latches.get(this.segment2.getId())).await();
        httpLoadQueuePeon.stop();
        httpLoadQueuePeon.dropSegment(this.segment3, arg_0 -> this.lambda$testLoadDropAfterStop$6((Map)latches, arg_0));
        httpLoadQueuePeon.loadSegment(this.segment4, arg_0 -> this.lambda$testLoadDropAfterStop$7((Map)latches, arg_0));
        ((CountDownLatch)latches.get(this.segment3.getId())).await();
        ((CountDownLatch)latches.get(this.segment4.getId())).await();
    }

    private /* synthetic */ void lambda$testLoadDropAfterStop$7(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment4.getId())).countDown();
    }

    private /* synthetic */ void lambda$testLoadDropAfterStop$6(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment3.getId())).countDown();
    }

    private /* synthetic */ void lambda$testLoadDropAfterStop$5(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment2.getId())).countDown();
    }

    private /* synthetic */ void lambda$testLoadDropAfterStop$4(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment1.getId())).countDown();
    }

    private /* synthetic */ void lambda$testSimple$3(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment4.getId())).countDown();
    }

    private /* synthetic */ void lambda$testSimple$2(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment3.getId())).countDown();
    }

    private /* synthetic */ void lambda$testSimple$1(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment2.getId())).countDown();
    }

    private /* synthetic */ void lambda$testSimple$0(Map latches, boolean success) {
        ((CountDownLatch)latches.get(this.segment1.getId())).countDown();
    }

    private static class TestHttpClient
    implements HttpClient {
        private TestHttpClient() {
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            httpResponse.setContent(ChannelBuffers.buffer((int)0));
            httpResponseHandler.handleResponse((HttpResponse)httpResponse, null);
            try {
                List changeRequests = (List)ServerTestHelper.MAPPER.readValue(request.getContent().array(), (TypeReference)new TypeReference<List<DataSegmentChangeRequest>>(){});
                ArrayList<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus> statuses = new ArrayList<SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus>(changeRequests.size());
                for (DataSegmentChangeRequest cr : changeRequests) {
                    statuses.add(new SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus(cr, SegmentLoadDropHandler.Status.SUCCESS));
                }
                return Futures.immediateFuture((Object)new ByteArrayInputStream(ServerTestHelper.MAPPER.writerWithType(HttpLoadQueuePeon.RESPONSE_ENTITY_TYPE_REF).writeValueAsBytes(statuses)));
            }
            catch (Exception ex) {
                throw new RE((Throwable)ex, "Unexpected exception.", new Object[0]);
            }
        }
    }
}

