/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.RunRulesTest;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.MarkAsUnusedOvershadowedSegments;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class MarkAsUnusedOvershadowedSegmentsTest {
    MarkAsUnusedOvershadowedSegments markAsUnusedOvershadowedSegments;
    DruidCoordinator coordinator = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    private List<DataSegment> usedSegments;
    DateTime start = DateTimes.of((String)"2012-01-01");
    DruidCluster druidCluster;
    private LoadQueuePeon mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
    private ImmutableDruidServer druidServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
    private ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createMock(ImmutableDruidDataSource.class);
    private DataSegment segmentV0 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("0").size(0L).build();
    private DataSegment segmentV1 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("1").size(0L).build();
    private DataSegment segmentV2 = new DataSegment.Builder().dataSource("test").interval(new Interval((ReadableInstant)this.start, (ReadableInstant)this.start.plusHours(1))).version("2").size(0L).build();

    @Test
    @Parameters(value={"historical", "broker"})
    public void testRun(String serverTypeString) {
        ServerType serverType = ServerType.fromString((String)serverTypeString);
        this.markAsUnusedOvershadowedSegments = new MarkAsUnusedOvershadowedSegments(this.coordinator);
        this.usedSegments = ImmutableList.of((Object)this.segmentV1, (Object)this.segmentV0, (Object)this.segmentV2);
        EasyMock.expect((Object)this.mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getMaxSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getCurrSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)this.druidServer.getName()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getHost()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getTier()).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.druidServer.getType()).andReturn((Object)serverType).anyTimes();
        EasyMock.expect((Object)this.druidServer.getDataSources()).andReturn((Object)ImmutableList.of((Object)this.druidDataSource)).anyTimes();
        EasyMock.expect((Object)this.druidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)this.segmentV1, (Object)this.segmentV2)).anyTimes();
        EasyMock.expect((Object)this.druidDataSource.getName()).andReturn((Object)"test").anyTimes();
        this.coordinator.markSegmentsAsUnused("test", (Set)ImmutableSet.of((Object)this.segmentV1.getId(), (Object)this.segmentV0.getId()));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mockPeon, this.coordinator, this.druidServer, this.druidDataSource});
        this.druidCluster = DruidClusterBuilder.newBuilder().addTier("normal", new ServerHolder(this.druidServer, this.mockPeon)).build();
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withUsedSegmentsInTest(this.usedSegments).withCoordinatorStats(new CoordinatorStats()).withDruidCluster(this.druidCluster).withDynamicConfigs(RunRulesTest.COORDINATOR_CONFIG_WITH_ZERO_LEADING_TIME_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS).build();
        this.markAsUnusedOvershadowedSegments.run(params);
        EasyMock.verify((Object[])new Object[]{this.coordinator, this.druidDataSource, this.druidServer});
    }
}

