/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.LoggingEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CachingCostBalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CoordinatorRuntimeParamsTestHelpers;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ReplicationThrottler;
import org.apache.druid.server.coordinator.RoundRobinServerSelector;
import org.apache.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.cost.ClusterCostCache;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LoadRuleTest {
    private static final Logger log = new Logger(LoadRuleTest.class);
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();
    private static final ServiceEmitter EMITTER = new ServiceEmitter("service", "host", (Emitter)new LoggingEmitter(log, LoggingEmitter.Level.ERROR, JSON_MAPPER));
    private ReplicationThrottler throttler;
    private ListeningExecutorService exec;
    private BalancerStrategy balancerStrategy;
    private CachingCostBalancerStrategy cachingCostBalancerStrategy;
    private final boolean useRoundRobinAssignment;
    private BalancerStrategy mockBalancerStrategy;
    private static final AtomicInteger SERVER_ID = new AtomicInteger();

    @Parameterized.Parameters(name="useRoundRobin = {0}")
    public static List<Boolean> getTestParams() {
        return Arrays.asList(true, false);
    }

    public LoadRuleTest(boolean useRoundRobinAssignment) {
        this.useRoundRobinAssignment = useRoundRobinAssignment;
    }

    @Before
    public void setUp() {
        EmittingLogger.registerEmitter((ServiceEmitter)EMITTER);
        EMITTER.start();
        this.throttler = (ReplicationThrottler)EasyMock.createMock(ReplicationThrottler.class);
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));
        this.balancerStrategy = new CostBalancerStrategyFactory().createBalancerStrategy(this.exec);
        this.cachingCostBalancerStrategy = new CachingCostBalancerStrategy(ClusterCostCache.builder().build(), this.exec);
        this.mockBalancerStrategy = (BalancerStrategy)EasyMock.createMock(BalancerStrategy.class);
    }

    @After
    public void tearDown() throws Exception {
        this.exec.shutdown();
        EMITTER.close();
    }

    @Test
    public void testLoad() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1, (Object)"_default_tier", (Object)2));
        DataSegment segment = this.createDataSegment("foo");
        this.throttler.registerReplicantCreation("_default_tier", segment.getId(), "hostNorm");
        EasyMock.expectLastCall().once();
        if (!this.useRoundRobinAssignment) {
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(3);
        }
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer(), mockPeon)).addTier("_default_tier", new ServerHolder(new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), mockPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "_default_tier"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    private DruidCoordinatorRuntimeParams makeCoordinatorRuntimeParams(DruidCluster druidCluster, DataSegment ... usedSegments) {
        return CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false)).withReplicationManager(this.throttler).withDynamicConfigs(CoordinatorDynamicConfig.builder().withUseRoundRobinSegmentAssignment(this.useRoundRobinAssignment).build()).withRoundRobinServerSelector(this.useRoundRobinAssignment ? new RoundRobinServerSelector(druidCluster) : null).withBalancerStrategy(this.mockBalancerStrategy).withUsedSegmentsInTest(usedSegments).build();
    }

    private DruidCoordinatorRuntimeParams makeCoordinatorRuntimeParamsWithLoadReplicationOnTimeout(DruidCluster druidCluster, DataSegment ... usedSegments) {
        return CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)true)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withUsedSegmentsInTest(usedSegments).build();
    }

    @Test
    public void testLoadPrimaryAssignDoesNotOverAssign() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        ImmutableDruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        ImmutableDruidServer server2 = new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, mockPeon), new ServerHolder(server2, mockPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        LoadQueuePeon loadingPeon = LoadRuleTest.createLoadingPeon((List<DataSegment>)ImmutableList.of((Object)segment), false);
        EasyMock.replay((Object[])new Object[]{loadingPeon});
        DruidCluster afterLoad = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, loadingPeon), new ServerHolder(server2, mockPeon)).build();
        CoordinatorStats statsAfterLoadPrimary = rule.run(null, this.makeCoordinatorRuntimeParams(afterLoad, segment), segment);
        Assert.assertEquals((long)0L, (long)statsAfterLoadPrimary.getTieredStat("assignedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testOverAssignForTimedOutSegments() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon emptyPeon = LoadRuleTest.createEmptyPeon();
        emptyPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.throttler, emptyPeon, this.mockBalancerStrategy});
        ImmutableDruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        ImmutableDruidServer server2 = new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, emptyPeon), new ServerHolder(server2, emptyPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParamsWithLoadReplicationOnTimeout(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        LoadQueuePeon slowLoadingPeon = LoadRuleTest.createLoadingPeon((List<DataSegment>)ImmutableList.of((Object)segment), true);
        EasyMock.replay((Object[])new Object[]{slowLoadingPeon});
        DruidCluster withLoadTimeout = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, slowLoadingPeon), new ServerHolder(server2, emptyPeon)).build();
        CoordinatorStats statsAfterLoadPrimary = rule.run(null, this.makeCoordinatorRuntimeParamsWithLoadReplicationOnTimeout(withLoadTimeout, segment), segment);
        Assert.assertEquals((long)1L, (long)statsAfterLoadPrimary.getTieredStat("assignedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, emptyPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testSkipReplicationForTimedOutSegments() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon emptyPeon = LoadRuleTest.createEmptyPeon();
        emptyPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.throttler, emptyPeon, this.mockBalancerStrategy});
        ImmutableDruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        ImmutableDruidServer server2 = new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 1).toImmutableDruidServer();
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, emptyPeon), new ServerHolder(server2, emptyPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        LoadQueuePeon slowLoadingPeon = LoadRuleTest.createLoadingPeon((List<DataSegment>)ImmutableList.of((Object)segment), true);
        EasyMock.replay((Object[])new Object[]{slowLoadingPeon});
        DruidCluster withLoadTimeout = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1, slowLoadingPeon), new ServerHolder(server2, emptyPeon)).build();
        CoordinatorStats statsAfterLoadPrimary = rule.run(null, this.makeCoordinatorRuntimeParams(withLoadTimeout, segment), segment);
        Assert.assertEquals((long)0L, (long)statsAfterLoadPrimary.getTieredStat("assignedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, emptyPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testLoadUsedSegmentsForAllSegmentGranularityAndCachingCostBalancerStrategy() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)false).anyTimes();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1));
        DataSegment segment0 = this.createDataSegmentWithIntervalAndPartition(this.createDataSegment("foo"), -4611686018427387904L, 0x3FFFFFFFFFFFFFFFL, 0);
        DataSegment segment1 = this.createDataSegmentWithIntervalAndPartition(this.createDataSegment("foo"), -4611686018427387904L, 0x3FFFFFFFFFFFFFFFL, 1);
        LoadQueuePeon loadingPeon = LoadRuleTest.createLoadingPeon((List<DataSegment>)ImmutableList.of((Object)segment0), true);
        loadingPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.isNull());
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.cachingCostBalancerStrategy).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.throttler, loadingPeon, this.mockBalancerStrategy});
        ImmutableDruidServer server = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "tier1", 1).toImmutableDruidServer();
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", new ServerHolder(server, loadingPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParamsWithLoadReplicationOnTimeout(druidCluster, segment0, segment1), segment1);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "tier1"));
        EasyMock.verify((Object[])new Object[]{this.throttler, loadingPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testLoadPriority() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)false).anyTimes();
        LoadQueuePeon mockPeon1 = LoadRuleTest.createEmptyPeon();
        LoadQueuePeon mockPeon2 = LoadRuleTest.createEmptyPeon();
        mockPeon2.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.isNull());
        EasyMock.expectLastCall().once();
        if (!this.useRoundRobinAssignment) {
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(2);
        }
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)10, (Object)"tier2", (Object)10));
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "tier1", 0).toImmutableDruidServer(), mockPeon1)).addTier("tier2", new ServerHolder(new DruidServer("server2", "host2", null, 1000L, ServerType.HISTORICAL, "tier2", 1).toImmutableDruidServer(), mockPeon2), new ServerHolder(new DruidServer("server3", "host3", null, 1000L, ServerType.HISTORICAL, "tier2", 1).toImmutableDruidServer(), mockPeon2)).build();
        DataSegment segment = this.createDataSegment("foo");
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)0L, (long)stats.getTieredStat("assignedCount", "tier1"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "tier2"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, this.mockBalancerStrategy});
    }

    @Test
    public void testDrop() {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.expect((Object)this.mockBalancerStrategy.pickServersToDrop((DataSegment)EasyMock.anyObject(), (NavigableSet)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(4);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)0, (Object)"_default_tier", (Object)0));
        DataSegment segment = this.createDataSegment("foo");
        DruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(segment);
        DruidServer server2 = new DruidServer("serverNorm", "hostNorm", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0);
        server2.addDataSegment(segment);
        DruidServer server3 = new DruidServer("serverNormNotServing", "hostNorm", null, 10L, ServerType.HISTORICAL, "_default_tier", 0);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1.toImmutableDruidServer(), mockPeon)).addTier("_default_tier", new ServerHolder(server2.toImmutableDruidServer(), mockPeon), new ServerHolder(server3.toImmutableDruidServer(), mockPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "_default_tier"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon});
    }

    @Test
    public void testLoadWithNonExistentTier() {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(1);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"nonExistentTier", (Object)1, (Object)"hot", (Object)1));
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), mockPeon)).build();
        DataSegment segment = this.createDataSegment("foo");
        CoordinatorStats stats = rule.run(null, CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster(), (boolean)false)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withUsedSegmentsInTest(new DataSegment[]{segment}).build(), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testDropWithNonExistentTier() {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().atLeastOnce();
        EasyMock.expect((Object)this.mockBalancerStrategy.pickServersToDrop((DataSegment)EasyMock.anyObject(), (NavigableSet)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(2);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"nonExistentTier", (Object)1, (Object)"hot", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        DruidServer server1 = new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        DruidServer server2 = new DruidServer("serverHot2", "hostHot2", null, 1000L, ServerType.HISTORICAL, "hot", 0);
        server1.addDataSegment(segment);
        server2.addDataSegment(segment);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(server1.toImmutableDruidServer(), mockPeon), new ServerHolder(server2.toImmutableDruidServer(), mockPeon)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
    }

    @Test
    public void testMaxLoadingQueueSize() {
        int maxSegmentsInLoadQueue = 2;
        EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(2);
        EasyMock.replay((Object[])new Object[]{this.throttler, this.mockBalancerStrategy});
        LoadQueuePeonTester peon = new LoadQueuePeonTester();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"hot", (Object)1));
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("hot", new ServerHolder(new DruidServer("serverHot", "hostHot", null, 1000L, ServerType.HISTORICAL, "hot", 0).toImmutableDruidServer(), (LoadQueuePeon)peon, false, 2)).build();
        DataSegment dataSegment1 = this.createDataSegment("ds1");
        DataSegment dataSegment2 = this.createDataSegment("ds2");
        DataSegment dataSegment3 = this.createDataSegment("ds3");
        DruidCoordinatorRuntimeParams params = CoordinatorRuntimeParamsTestHelpers.newBuilder().withDruidCluster(druidCluster).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)druidCluster, (boolean)false)).withReplicationManager(this.throttler).withBalancerStrategy(this.mockBalancerStrategy).withUsedSegmentsInTest(new DataSegment[]{dataSegment1, dataSegment2, dataSegment3}).withDynamicConfigs(CoordinatorDynamicConfig.builder().withMaxSegmentsInNodeLoadingQueue(2).build()).build();
        CoordinatorStats stats1 = rule.run(null, params, dataSegment1);
        CoordinatorStats stats2 = rule.run(null, params, dataSegment2);
        CoordinatorStats stats3 = rule.run(null, params, dataSegment3);
        Assert.assertEquals((long)1L, (long)stats1.getTieredStat("assignedCount", "hot"));
        Assert.assertEquals((long)1L, (long)stats2.getTieredStat("assignedCount", "hot"));
        Assert.assertFalse((boolean)stats3.getTiers("assignedCount").contains("hot"));
        EasyMock.verify((Object[])new Object[]{this.throttler, this.mockBalancerStrategy});
    }

    @Test
    public void testLoadDecommissioning() {
        LoadQueuePeon mockPeon1 = LoadRuleTest.createEmptyPeon();
        LoadQueuePeon mockPeon2 = LoadRuleTest.createOneCallPeonMock();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)1, (Object)"tier2", (Object)1));
        DataSegment segment = this.createDataSegment("foo");
        if (!this.useRoundRobinAssignment) {
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator((DataSegment)EasyMock.anyObject(), (List)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(1);
        }
        EasyMock.replay((Object[])new Object[]{mockPeon1, mockPeon2, this.mockBalancerStrategy});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", LoadRuleTest.createServerHolder("tier1", mockPeon1, true)).addTier("tier2", LoadRuleTest.createServerHolder("tier2", mockPeon2, false)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "tier2"));
        EasyMock.verify((Object[])new Object[]{mockPeon1, mockPeon2, this.mockBalancerStrategy});
    }

    @Test
    public void testLoadReplicaDuringDecommissioning() {
        EasyMock.expect((Object)this.throttler.canCreateReplicant(EasyMock.anyString())).andReturn((Object)true).anyTimes();
        LoadQueuePeon mockPeon1 = LoadRuleTest.createEmptyPeon();
        LoadQueuePeon mockPeon2 = LoadRuleTest.createOneCallPeonMock();
        LoadQueuePeon mockPeon3 = LoadRuleTest.createOneCallPeonMock();
        LoadQueuePeon mockPeon4 = LoadRuleTest.createOneCallPeonMock();
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)2, (Object)"tier2", (Object)2));
        DataSegment segment = this.createDataSegment("foo");
        this.throttler.registerReplicantCreation((String)EasyMock.eq((Object)"tier2"), (SegmentId)EasyMock.anyObject(), (String)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        ServerHolder holder1 = LoadRuleTest.createServerHolder("tier1", mockPeon1, true);
        ServerHolder holder2 = LoadRuleTest.createServerHolder("tier1", mockPeon2, false);
        ServerHolder holder3 = LoadRuleTest.createServerHolder("tier2", mockPeon3, false);
        ServerHolder holder4 = LoadRuleTest.createServerHolder("tier2", mockPeon4, false);
        if (!this.useRoundRobinAssignment) {
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator(segment, (List)ImmutableList.of((Object)holder2))).andReturn((Object)holder2);
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator(segment, (List)ImmutableList.of((Object)holder4, (Object)holder3))).andReturn((Object)holder3);
            EasyMock.expect((Object)this.mockBalancerStrategy.findNewSegmentHomeReplicator(segment, (List)ImmutableList.of((Object)holder4))).andReturn((Object)holder4);
        }
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, mockPeon3, mockPeon4, this.mockBalancerStrategy});
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", holder1, holder2).addTier("tier2", holder3, holder4).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment), segment);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("assignedCount", "tier1"));
        Assert.assertEquals((long)2L, (long)stats.getTieredStat("assignedCount", "tier2"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon1, mockPeon2, mockPeon3, mockPeon4, this.mockBalancerStrategy});
    }

    @Test
    public void testDropDuringDecommissioning() {
        LoadQueuePeon mockPeon = LoadRuleTest.createEmptyPeon();
        mockPeon.dropSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.mockBalancerStrategy.pickServersToDrop((DataSegment)EasyMock.anyObject(), (NavigableSet)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(4);
        EasyMock.replay((Object[])new Object[]{this.throttler, mockPeon, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)0));
        DataSegment segment1 = this.createDataSegment("foo1");
        DataSegment segment2 = this.createDataSegment("foo2");
        DruidServer server1 = LoadRuleTest.createServer("tier1");
        server1.addDataSegment(segment1);
        DruidServer server2 = LoadRuleTest.createServer("tier1");
        server2.addDataSegment(segment2);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", new ServerHolder(server1.toImmutableDruidServer(), mockPeon, true), new ServerHolder(server2.toImmutableDruidServer(), mockPeon, false)).build();
        DruidCoordinatorRuntimeParams params = this.makeCoordinatorRuntimeParams(druidCluster, segment1, segment2);
        CoordinatorStats stats = rule.run(null, params, segment1);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "tier1"));
        stats = rule.run(null, params, segment2);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "tier1"));
        EasyMock.verify((Object[])new Object[]{this.throttler, mockPeon});
    }

    @Test
    public void testRedundantReplicaDropDuringDecommissioning() {
        LoadQueuePeonTester mockPeon1 = new LoadQueuePeonTester();
        LoadQueuePeonTester mockPeon2 = new LoadQueuePeonTester();
        LoadQueuePeonTester mockPeon3 = new LoadQueuePeonTester();
        EasyMock.expect((Object)this.mockBalancerStrategy.pickServersToDrop((DataSegment)EasyMock.anyObject(), (NavigableSet)EasyMock.anyObject())).andDelegateTo((Object)this.balancerStrategy).times(4);
        EasyMock.replay((Object[])new Object[]{this.throttler, this.mockBalancerStrategy});
        LoadRule rule = LoadRuleTest.createLoadRule((Map<String, Integer>)ImmutableMap.of((Object)"tier1", (Object)2));
        DataSegment segment1 = this.createDataSegment("foo1");
        DruidServer server1 = LoadRuleTest.createServer("tier1");
        server1.addDataSegment(segment1);
        DruidServer server2 = LoadRuleTest.createServer("tier1");
        server2.addDataSegment(segment1);
        DruidServer server3 = LoadRuleTest.createServer("tier1");
        server3.addDataSegment(segment1);
        DruidCluster druidCluster = DruidClusterBuilder.newBuilder().addTier("tier1", new ServerHolder(server1.toImmutableDruidServer(), (LoadQueuePeon)mockPeon1, false), new ServerHolder(server2.toImmutableDruidServer(), (LoadQueuePeon)mockPeon2, true), new ServerHolder(server3.toImmutableDruidServer(), (LoadQueuePeon)mockPeon3, false)).build();
        CoordinatorStats stats = rule.run(null, this.makeCoordinatorRuntimeParams(druidCluster, segment1), segment1);
        Assert.assertEquals((long)1L, (long)stats.getTieredStat("droppedCount", "tier1"));
        Assert.assertEquals((long)0L, (long)mockPeon1.getSegmentsToDrop().size());
        Assert.assertEquals((long)1L, (long)mockPeon2.getSegmentsToDrop().size());
        Assert.assertEquals((long)0L, (long)mockPeon3.getSegmentsToDrop().size());
        EasyMock.verify((Object[])new Object[]{this.throttler});
    }

    private DataSegment createDataSegment(String dataSource) {
        return new DataSegment(dataSource, Intervals.of((String)"0/3000"), DateTimes.nowUtc().toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
    }

    private DataSegment createDataSegmentWithIntervalAndPartition(DataSegment dataSegment, long startMillis, long endMillis, int partitionNum) {
        return new DataSegment.Builder(dataSegment).interval(new Interval(startMillis, endMillis, dataSegment.getInterval().getChronology())).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(partitionNum))).build();
    }

    private static LoadRule createLoadRule(final Map<String, Integer> tieredReplicants) {
        return new LoadRule(){

            public Map<String, Integer> getTieredReplicants() {
                return tieredReplicants;
            }

            public int getNumReplicants(String tier) {
                return (Integer)tieredReplicants.get(tier);
            }

            public String getType() {
                return "test";
            }

            public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
                return true;
            }

            public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
                return true;
            }
        };
    }

    private static LoadQueuePeon createEmptyPeon() {
        LoadQueuePeon mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)mockPeon.getSegmentsToLoad()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)mockPeon.getSegmentsMarkedToDrop()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)mockPeon.getLoadQueueSize()).andReturn((Object)0L).anyTimes();
        EasyMock.expect((Object)mockPeon.getNumberOfSegmentsInQueue()).andReturn((Object)0).anyTimes();
        return mockPeon;
    }

    private static LoadQueuePeon createLoadingPeon(List<DataSegment> segments, boolean slowLoading) {
        ImmutableSet segs = ImmutableSet.copyOf(segments);
        long loadingSize = segs.stream().mapToLong(DataSegment::getSize).sum();
        LoadQueuePeon mockPeon = (LoadQueuePeon)EasyMock.createMock(LoadQueuePeon.class);
        EasyMock.expect((Object)mockPeon.getSegmentsToLoad()).andReturn((Object)segs).anyTimes();
        EasyMock.expect((Object)mockPeon.getSegmentsMarkedToDrop()).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)mockPeon.getLoadQueueSize()).andReturn((Object)loadingSize).anyTimes();
        EasyMock.expect((Object)mockPeon.getNumberOfSegmentsInQueue()).andReturn((Object)segs.size()).anyTimes();
        if (slowLoading) {
            EasyMock.expect((Object)mockPeon.getTimedOutSegments()).andReturn(new HashSet<DataSegment>(segments)).anyTimes();
        } else {
            EasyMock.expect((Object)mockPeon.getTimedOutSegments()).andReturn(new HashSet()).anyTimes();
        }
        return mockPeon;
    }

    private static DruidServer createServer(String tier) {
        int serverId = SERVER_ID.incrementAndGet();
        return new DruidServer("server" + serverId, "127.0.0.1:800" + serverId, null, 1000L, ServerType.HISTORICAL, tier, 0);
    }

    private static LoadQueuePeon createOneCallPeonMock() {
        LoadQueuePeon mockPeon2 = LoadRuleTest.createEmptyPeon();
        mockPeon2.loadSegment((DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        return mockPeon2;
    }

    private static ServerHolder createServerHolder(String tier, LoadQueuePeon mockPeon1, boolean isDecommissioning) {
        return new ServerHolder(LoadRuleTest.createServer(tier).toImmutableDruidServer(), mockPeon1, isDecommissioning);
    }
}

