/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ObjectDefn;
import org.apache.druid.java.util.common.IAE;

public class ColumnDefn
extends ObjectDefn {
    public ColumnDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> fields) {
        super(name, typeValue, fields);
    }

    public ColumnSpec merge(ColumnSpec spec, ColumnSpec update) {
        String updateType = update.type();
        if (updateType != null && !spec.type().equals(updateType)) {
            throw new IAE("The update type must be null or [%s]", new Object[]{spec.type()});
        }
        String revisedType = update.sqlType() == null ? spec.sqlType() : update.sqlType();
        Map<String, Object> revisedProps = this.mergeProperties(spec.properties(), update.properties());
        return new ColumnSpec(spec.type(), spec.name(), revisedType, revisedProps);
    }

    public void validate(ColumnSpec spec, ObjectMapper jsonMapper) {
        spec.validate();
    }

    public void validateScalarColumn(ColumnSpec spec) {
        Columns.validateScalarColumn(spec.name(), spec.sqlType());
    }

    public static class ResolvedColumn {
        private final ColumnDefn defn;
        private final ColumnSpec spec;

        public ResolvedColumn(ColumnDefn defn, ColumnSpec spec) {
            this.defn = defn;
            this.spec = spec;
        }

        public ColumnDefn defn() {
            return this.defn;
        }

        public ColumnSpec spec() {
            return this.spec;
        }

        public ResolvedColumn merge(ColumnSpec update) {
            return new ResolvedColumn(this.defn, this.defn.merge(this.spec, update));
        }

        public void validate(ObjectMapper jsonMapper) {
            this.defn.validate(this.spec, jsonMapper);
        }
    }
}

