/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.java.util.common.IAE;

public class ColumnSpec {
    private final String type;
    private final String name;
    private final String sqlType;
    private final Map<String, Object> properties;

    @JsonCreator
    public ColumnSpec(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name, @JsonProperty(value="sqlType") @Nullable String sqlType, @JsonProperty(value="properties") @Nullable Map<String, Object> properties) {
        this.type = type;
        this.name = name;
        this.sqlType = sqlType;
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @JsonProperty(value="sqlType")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String sqlType() {
        return this.sqlType;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> properties() {
        return this.properties;
    }

    public void validate() {
        if (Strings.isNullOrEmpty((String)this.type)) {
            throw new IAE("Column type is required", new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)this.name)) {
            throw new IAE("Column name is required", new Object[0]);
        }
    }

    public String toString() {
        return CatalogUtils.toString(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ColumnSpec other = (ColumnSpec)o;
        return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.sqlType, other.sqlType) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.sqlType, this.properties);
    }
}

