/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Period;

public interface ModelProperties {

    public static class StringListPropertyDefn
    extends ListPropertyDefn<String> {
        public StringListPropertyDefn(String name) {
            super(name, "string list", new TypeReference<List<String>>(){});
        }
    }

    public static class ListPropertyDefn<T>
    extends TypeRefPropertyDefn<List<T>> {
        public ListPropertyDefn(String name, String typeName, TypeReference<List<T>> valueType) {
            super(name, typeName, valueType);
        }

        @Override
        public Object merge(Object existing, Object updates) {
            List updatesList;
            List existingList;
            if (updates == null) {
                return existing;
            }
            if (existing == null) {
                return updates;
            }
            try {
                existingList = (List)existing;
                updatesList = (List)updates;
            }
            catch (ClassCastException e) {
                throw new IAE("Value of field %s must be a list, found %s", new Object[]{this.name, updates.getClass().getSimpleName()});
            }
            HashSet existingSet = new HashSet(existingList);
            ArrayList revised = new ArrayList(existingList);
            for (Object col : updatesList) {
                if (existingSet.contains(col)) continue;
                revised.add(col);
            }
            return revised;
        }
    }

    public static class BooleanPropertyDefn
    extends SimplePropertyDefn<Boolean> {
        public BooleanPropertyDefn(String name) {
            super(name, Boolean.class);
        }
    }

    public static class IntPropertyDefn
    extends SimplePropertyDefn<Integer> {
        public IntPropertyDefn(String name) {
            super(name, Integer.class);
        }
    }

    public static class GranularityPropertyDefn
    extends StringPropertyDefn {
        public GranularityPropertyDefn(String name) {
            super(name);
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            String gran = (String)this.decode(value, jsonMapper);
            this.validateGranularity(gran);
        }

        public void validateGranularity(String value) {
            if (value == null) {
                return;
            }
            try {
                new PeriodGranularity(new Period((Object)value), null, null);
            }
            catch (IllegalArgumentException e) {
                throw new IAE(StringUtils.format((String)"[%s] is an invalid granularity string", (Object[])new Object[]{value}), new Object[0]);
            }
        }
    }

    public static class StringPropertyDefn
    extends SimplePropertyDefn<String> {
        public StringPropertyDefn(String name) {
            super(name, String.class);
        }
    }

    public static class TypeRefPropertyDefn<T>
    extends BasePropertyDefn<T> {
        public final String typeName;
        public final TypeReference<T> valueType;

        public TypeRefPropertyDefn(String name, String typeName, TypeReference<T> valueType) {
            super(name);
            this.typeName = (String)Preconditions.checkNotNull((Object)typeName);
            this.valueType = valueType;
        }

        @Override
        public String typeName() {
            return this.typeName;
        }

        @Override
        public T decode(Object value, ObjectMapper jsonMapper) {
            if (value == null) {
                return null;
            }
            try {
                return (T)jsonMapper.convertValue(value, this.valueType);
            }
            catch (Exception e) {
                throw new IAE("Value [%s] is not valid for property [%s], expected %s", new Object[]{value, this.name, this.typeName()});
            }
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            this.decode(value, jsonMapper);
        }
    }

    public static class SimplePropertyDefn<T>
    extends BasePropertyDefn<T> {
        public final Class<T> valueClass;

        public SimplePropertyDefn(String name, Class<T> valueClass) {
            super(name);
            this.valueClass = valueClass;
        }

        @Override
        public String typeName() {
            return this.valueClass.getSimpleName();
        }

        @Override
        public T decode(Object value, ObjectMapper jsonMapper) {
            if (value == null) {
                return null;
            }
            try {
                return (T)jsonMapper.convertValue(value, this.valueClass);
            }
            catch (Exception e) {
                throw new IAE("Value [%s] is not valid for property [%s], expected %s", new Object[]{value, this.name, this.typeName()});
            }
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            this.decode(value, jsonMapper);
        }
    }

    public static abstract class BasePropertyDefn<T>
    implements PropertyDefn<T> {
        protected final String name;

        public BasePropertyDefn(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Object merge(Object existing, Object update) {
            return update == null ? existing : update;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{name: " + this.name + ", type: " + this.typeName() + "}";
        }
    }

    public static interface PropertyDefn<T> {
        public String name();

        public String typeName();

        public void validate(Object var1, ObjectMapper var2);

        public Object merge(Object var1, Object var2);

        public T decode(Object var1, ObjectMapper var2);
    }
}

