/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnDefn;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class AbstractDatasourceDefn
extends TableDefn {
    public static final String SEGMENT_GRANULARITY_PROPERTY = "segmentGranularity";
    public static final String TARGET_SEGMENT_ROWS_PROPERTY = "targetSegmentRows";
    public static final String CLUSTER_KEYS_PROPERTY = "clusterKeys";
    public static final String HIDDEN_COLUMNS_PROPERTY = "hiddenColumns";

    public AbstractDatasourceDefn(String name, String typeValue, List<ModelProperties.PropertyDefn<?>> properties, List<ColumnDefn> columnDefns) {
        super(name, typeValue, CatalogUtils.concatLists(Arrays.asList(new SegmentGranularityFieldDefn(), new ModelProperties.IntPropertyDefn(TARGET_SEGMENT_ROWS_PROPERTY), new ModelProperties.ListPropertyDefn<ClusterKeySpec>(CLUSTER_KEYS_PROPERTY, "cluster keys", new TypeReference<List<ClusterKeySpec>>(){}), new HiddenColumnsDefn()), properties), columnDefns);
    }

    public static boolean isDatasource(String tableType) {
        return "datasource".equals(tableType);
    }

    public static boolean isDatasource(ResolvedTable table) {
        return table.defn() instanceof AbstractDatasourceDefn;
    }

    public static Set<String> tableTypes() {
        return ImmutableSet.of((Object)"datasource");
    }

    public static class HiddenColumnsDefn
    extends ModelProperties.StringListPropertyDefn {
        public HiddenColumnsDefn() {
            super(AbstractDatasourceDefn.HIDDEN_COLUMNS_PROPERTY);
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            if (value == null) {
                return;
            }
            List hiddenColumns = (List)this.decode(value, jsonMapper);
            for (String col : hiddenColumns) {
                if (!"__time".equals(col)) continue;
                throw new IAE(StringUtils.format((String)"Cannot hide column %s", (Object[])new Object[]{col}), new Object[0]);
            }
        }
    }

    public static class SegmentGranularityFieldDefn
    extends ModelProperties.GranularityPropertyDefn {
        public SegmentGranularityFieldDefn() {
            super(AbstractDatasourceDefn.SEGMENT_GRANULARITY_PROPERTY);
        }

        @Override
        public void validate(Object value, ObjectMapper jsonMapper) {
            String gran = (String)this.decode(value, jsonMapper);
            if (Strings.isNullOrEmpty((String)gran)) {
                throw new IAE("Segment granularity is required.", new Object[0]);
            }
            this.validateGranularity(gran);
        }
    }
}

