/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.catalog.model.ParameterizedDefn;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.InputFormats;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.LocalInputSource;
import org.apache.druid.utils.CollectionUtils;

public class LocalTableDefn
extends ExternalTableDefn.FormattedExternalTableDefn
implements ParameterizedDefn {
    public static final String TABLE_TYPE = "local";
    public static final String BASE_DIR_PROPERTY = "baseDir";
    public static final String FILE_FILTER_PROPERTY = "fileFilter";
    public static final String FILES_PROPERTY = "files";

    public LocalTableDefn() {
        super("Local file input table", TABLE_TYPE, Arrays.asList(new ModelProperties.StringPropertyDefn(BASE_DIR_PROPERTY), new ModelProperties.StringPropertyDefn(FILE_FILTER_PROPERTY), new ModelProperties.StringListPropertyDefn(FILES_PROPERTY)), Collections.singletonList(INPUT_COLUMN_DEFN), InputFormats.ALL_FORMATS, Arrays.asList(new ParameterizedDefn.ParameterImpl(FILE_FILTER_PROPERTY, String.class), new ParameterizedDefn.ParameterImpl(FILES_PROPERTY, String.class)));
    }

    @Override
    public ResolvedTable mergeParameters(ResolvedTable table, Map<String, Object> values) {
        String filesParam = CatalogUtils.safeGet(values, FILES_PROPERTY, String.class);
        String filterParam = CatalogUtils.safeGet(values, FILE_FILTER_PROPERTY, String.class);
        HashMap<String, Object> revisedProps = new HashMap<String, Object>(table.properties());
        if (filesParam != null) {
            revisedProps.put(FILES_PROPERTY, CatalogUtils.stringToList(filesParam));
        }
        if (filterParam != null) {
            revisedProps.put(FILE_FILTER_PROPERTY, filterParam);
        }
        return table.withProperties(revisedProps);
    }

    @Override
    protected InputSource convertSource(ResolvedTable table) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("type", TABLE_TYPE);
        String baseDir = table.stringProperty(BASE_DIR_PROPERTY);
        jsonMap.put(BASE_DIR_PROPERTY, baseDir);
        List<String> files = table.stringListProperty(FILES_PROPERTY);
        jsonMap.put(FILES_PROPERTY, files);
        String filter = table.stringProperty(FILE_FILTER_PROPERTY);
        if (baseDir != null && !CollectionUtils.isNullOrEmpty(files) && filter == null) {
            filter = "*";
        }
        jsonMap.put("filter", filter);
        return this.convertObject(table.jsonMapper(), jsonMap, LocalInputSource.class);
    }

    @Override
    public void validate(ResolvedTable table) {
        super.validate(table);
        this.formatDefn(table).validate(table);
        if (table.hasProperty(BASE_DIR_PROPERTY) || table.hasProperty(FILES_PROPERTY)) {
            this.convertSource(table);
        }
    }
}

