/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableDefn;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.TableSpec;
import org.apache.druid.catalog.model.table.ClusterKeySpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class TableBuilder {
    private TableId id;
    private TableDefn defn;
    private String tableType;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<ColumnSpec> columns = new ArrayList<ColumnSpec>();

    public static TableBuilder datasource(String name, String granularity) {
        return new TableBuilder().datasource(name).type("datasource").segmentGranularity(granularity);
    }

    public static TableBuilder external(String type, String name) {
        return new TableBuilder().external(name).type(type);
    }

    public static TableBuilder updateFor(TableMetadata table) {
        return new TableBuilder().id(table.id()).type(table.spec().type());
    }

    public static TableBuilder copyOf(TableMetadata table) {
        return TableBuilder.copyOf(table.id(), table.spec());
    }

    public static TableBuilder copyOf(TableId newId, TableSpec from) {
        return new TableBuilder().id(newId).type(from.type()).properties(new HashMap<String, Object>(from.properties())).columns(new ArrayList<ColumnSpec>(from.columns()));
    }

    public static TableBuilder of(TableDefn defn) {
        TableBuilder builder = new TableBuilder();
        builder.defn = defn;
        builder.tableType = defn.typeValue();
        return builder;
    }

    public TableBuilder copy() {
        TableBuilder builder = new TableBuilder();
        builder.defn = this.defn;
        builder.tableType = this.tableType;
        builder.id = this.id;
        builder.properties.putAll(this.properties);
        builder.columns.addAll(this.columns);
        return builder;
    }

    public TableBuilder id(TableId id) {
        this.id = id;
        return this;
    }

    public TableBuilder datasource(String name) {
        this.id = TableId.datasource(name);
        return this;
    }

    public TableBuilder external(String name) {
        this.id = TableId.of("extern", name);
        return this;
    }

    public TableBuilder path(String schema, String name) {
        this.id = TableId.of(schema, name);
        return this;
    }

    public TableBuilder type(String tableType) {
        this.tableType = tableType;
        return this;
    }

    public TableBuilder properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public TableBuilder property(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public TableBuilder description(String description) {
        return this.property("description", description);
    }

    public TableBuilder segmentGranularity(String segmentGranularity) {
        return this.property("segmentGranularity", segmentGranularity);
    }

    public TableBuilder clusterColumns(ClusterKeySpec ... clusterKeys) {
        return this.property("clusterKeys", Arrays.asList(clusterKeys));
    }

    public TableBuilder columns(List<ColumnSpec> columns) {
        this.columns = columns;
        return this;
    }

    public List<ColumnSpec> columns() {
        return this.columns;
    }

    public TableBuilder column(ColumnSpec column) {
        if (Strings.isNullOrEmpty((String)column.name())) {
            throw new IAE("Column name is required", new Object[0]);
        }
        this.columns.add(column);
        return this;
    }

    public TableBuilder timeColumn() {
        return this.column("__time", "TIMESTAMP");
    }

    public TableBuilder column(String name, String sqlType) {
        String colType;
        Preconditions.checkNotNull((Object)this.tableType);
        if (TableBuilder.isInputTable(this.tableType)) {
            colType = "extern";
        } else if ("datasource".equals(this.tableType)) {
            colType = "column";
        } else {
            throw new ISE("Unknown table type: %s", new Object[]{this.tableType});
        }
        return this.column(colType, name, sqlType);
    }

    public static boolean isInputTable(String tableType) {
        switch (tableType) {
            case "inline": 
            case "http": 
            case "local": {
                return true;
            }
        }
        return false;
    }

    public TableBuilder column(String colType, String name, String sqlType) {
        return this.column(new ColumnSpec(colType, name, sqlType, null));
    }

    public TableBuilder hiddenColumns(List<String> hiddenColumns) {
        return this.property("hiddenColumns", hiddenColumns);
    }

    public TableBuilder hiddenColumns(String ... hiddenColumns) {
        return this.hiddenColumns(Arrays.asList(hiddenColumns));
    }

    public TableBuilder format(String format) {
        return this.property("format", format);
    }

    public TableBuilder data(List<String> data) {
        return this.property("data", data);
    }

    public TableBuilder data(String ... data) {
        return this.data(Arrays.asList(data));
    }

    public TableSpec buildSpec() {
        return new TableSpec(this.tableType, this.properties, this.columns);
    }

    public TableMetadata build() {
        return TableMetadata.newTable(this.id, this.buildSpec());
    }

    public ResolvedTable buildResolved(ObjectMapper mapper) {
        Preconditions.checkNotNull((Object)this.defn);
        return new ResolvedTable(this.defn, this.buildSpec(), mapper);
    }
}

