/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.GetDataWatchBackgroundStatable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.utils.ZKPaths;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.curator.cache.PathChildrenCacheFactory;
import org.apache.druid.curator.discovery.CuratorDruidNodeAnnouncer;
import org.apache.druid.discovery.BaseNodeRoleWatcher;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.utils.CloseableUtils;

@ManageLifecycle
public class CuratorDruidNodeDiscoveryProvider
extends DruidNodeDiscoveryProvider {
    private static final Logger log = new Logger(CuratorDruidNodeDiscoveryProvider.class);
    private final CuratorFramework curatorFramework;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;
    private ExecutorService listenerExecutor;
    private final ConcurrentHashMap<NodeRole, NodeRoleWatcher> nodeRoleWatchers = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<NodeDiscoverer> nodeDiscoverers = new ConcurrentLinkedQueue();
    private final LifecycleLock lifecycleLock = new LifecycleLock();

    @Inject
    public CuratorDruidNodeDiscoveryProvider(CuratorFramework curatorFramework, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.curatorFramework = curatorFramework;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public BooleanSupplier getForNode(DruidNode node, NodeRole nodeRole) {
        Preconditions.checkState((boolean)this.lifecycleLock.isStarted());
        log.debug("Creating a NodeDiscoverer for node [%s] and role [%s]", new Object[]{node, nodeRole});
        NodeDiscoverer nodeDiscoverer = new NodeDiscoverer(this.config, this.jsonMapper, this.curatorFramework, node, nodeRole);
        this.nodeDiscoverers.add(nodeDiscoverer);
        return () -> nodeDiscoverer.nodeDiscovered();
    }

    @Override
    public DruidNodeDiscovery getForNodeRole(NodeRole nodeRole) {
        Preconditions.checkState((boolean)this.lifecycleLock.isStarted());
        return this.nodeRoleWatchers.computeIfAbsent(nodeRole, role -> {
            log.debug("Creating NodeRoleWatcher for nodeRole [%s].", new Object[]{role});
            NodeRoleWatcher nodeRoleWatcher = new NodeRoleWatcher(this.listenerExecutor, this.curatorFramework, this.config.getInternalDiscoveryPath(), this.jsonMapper, (NodeRole)role);
            log.debug("Created NodeRoleWatcher for nodeRole [%s].", new Object[]{role});
            return nodeRoleWatcher;
        });
    }

    @LifecycleStart
    public void start() {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.listenerExecutor = Execs.singleThreaded((String)"CuratorDruidNodeDiscoveryProvider-ListenerExecutor");
            log.debug("Started.", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @LifecycleStop
    public void stop() throws IOException {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        log.debug("Stopping.", new Object[0]);
        Closer closer = Closer.create();
        closer.registerAll(this.nodeRoleWatchers.values());
        closer.registerAll(this.nodeDiscoverers);
        Closeable[] closeableArray = new Closeable[1];
        closeableArray[0] = this.listenerExecutor::shutdownNow;
        CloseableUtils.closeAll((Closeable)closer, (Closeable[])closeableArray);
    }

    private static class NodeDiscoverer
    implements Closeable {
        private final ObjectMapper jsonMapper;
        private final NodeCache nodeCache;
        private final NodeRole nodeRole;

        private NodeDiscoverer(ZkPathsConfig config, ObjectMapper jsonMapper, CuratorFramework curatorFramework, DruidNode node, NodeRole nodeRole) {
            this.jsonMapper = jsonMapper;
            String path = CuratorDruidNodeAnnouncer.makeNodeAnnouncementPath(config, nodeRole, node);
            this.nodeCache = new NodeCache(curatorFramework, path, true);
            this.nodeRole = nodeRole;
            try {
                this.nodeCache.start(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean nodeDiscovered() {
            DiscoveryDruidNode druidNode;
            ChildData currentChild = this.nodeCache.getCurrentData();
            if (currentChild == null) {
                return false;
            }
            byte[] data = currentChild.getData();
            try {
                druidNode = (DiscoveryDruidNode)this.jsonMapper.readValue(data, DiscoveryDruidNode.class);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Exception occurred when reading node's value", new Object[0]);
                return false;
            }
            if (!this.nodeRole.equals(druidNode.getNodeRole())) {
                log.error("Node[%s] of role[%s] add is discovered by node watcher of different node role. Ignored.", new Object[]{druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName()});
                return false;
            }
            log.info("Node[%s] of role[%s] appeared.", new Object[]{druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName()});
            return true;
        }

        @Override
        public void close() throws IOException {
            this.nodeCache.close();
        }
    }

    private static class NodeRoleWatcher
    implements DruidNodeDiscovery,
    Closeable {
        private static final Logger log = new Logger(NodeRoleWatcher.class);
        private final CuratorFramework curatorFramework;
        private final NodeRole nodeRole;
        private final ObjectMapper jsonMapper;
        private final BaseNodeRoleWatcher baseNodeRoleWatcher;
        private final PathChildrenCache cache;
        private final ExecutorService cacheExecutor;
        private final Object lock = new Object();

        NodeRoleWatcher(ExecutorService listenerExecutor, CuratorFramework curatorFramework, String basePath, ObjectMapper jsonMapper, NodeRole nodeRole) {
            this.curatorFramework = curatorFramework;
            this.nodeRole = nodeRole;
            this.jsonMapper = jsonMapper;
            this.baseNodeRoleWatcher = new BaseNodeRoleWatcher(listenerExecutor, nodeRole);
            this.cacheExecutor = Execs.singleThreaded((String)StringUtils.format((String)"NodeRoleWatcher[%s]", (Object[])new Object[]{StringUtils.encodeForFormat((String)nodeRole.toString())}));
            this.cache = new PathChildrenCacheFactory.Builder().withCacheData(true).withCompressed(true).withExecutorService(this.cacheExecutor).build().make(curatorFramework, ZKPaths.makePath((String)basePath, (String)nodeRole.toString()));
            try {
                this.cache.getListenable().addListener((client, event) -> this.handleChildEvent(event));
                this.cache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            Closeable[] closeableArray = new Closeable[1];
            closeableArray[0] = this.cacheExecutor::shutdownNow;
            CloseableUtils.closeAll((Closeable)this.cache, (Closeable[])closeableArray);
        }

        @Override
        public Collection<DiscoveryDruidNode> getAllNodes() {
            return this.baseNodeRoleWatcher.getAllNodes();
        }

        @Override
        public void registerListener(DruidNodeDiscovery.Listener listener) {
            this.baseNodeRoleWatcher.registerListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleChildEvent(PathChildrenCacheEvent event) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    switch (event.getType()) {
                        case CHILD_ADDED: {
                            this.childAdded(event);
                            break;
                        }
                        case CHILD_REMOVED: {
                            this.childRemoved(event);
                            break;
                        }
                        case INITIALIZED: {
                            this.baseNodeRoleWatcher.cacheInitialized();
                            break;
                        }
                        default: {
                            log.warn("Ignored event type [%s] for node watcher of role [%s].", new Object[]{event.getType(), this.nodeRole.getJsonName()});
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    log.error((Throwable)ex, "Unknown error in node watcher of role [%s].", new Object[]{this.nodeRole.getJsonName()});
                }
            }
        }

        @GuardedBy(value="lock")
        private void childAdded(PathChildrenCacheEvent event) throws IOException {
            byte[] data = this.getZkDataForNode(event.getData());
            if (data == null) {
                log.error("Failed to get data for path [%s]. Ignoring a child addition event.", new Object[]{event.getData().getPath()});
                return;
            }
            this.baseNodeRoleWatcher.childAdded((DiscoveryDruidNode)this.jsonMapper.readValue(data, DiscoveryDruidNode.class));
        }

        @GuardedBy(value="lock")
        private void childRemoved(PathChildrenCacheEvent event) throws IOException {
            byte[] data = event.getData().getData();
            if (data == null) {
                log.error("Failed to get data for path [%s]. Ignoring a child removal event.", new Object[]{event.getData().getPath()});
                return;
            }
            this.baseNodeRoleWatcher.childRemoved((DiscoveryDruidNode)this.jsonMapper.readValue(data, DiscoveryDruidNode.class));
        }

        @Nullable
        private byte[] getZkDataForNode(ChildData child) {
            try {
                return (byte[])((GetDataWatchBackgroundStatable)this.curatorFramework.getData().decompressed()).forPath(child.getPath());
            }
            catch (Exception ex) {
                log.error((Throwable)ex, "Exception while getting data for node %s", new Object[]{child.getPath()});
                return null;
            }
        }
    }
}

