/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.overlord.supervisor.NoopSupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLMetadataSupervisorManager
implements MetadataSupervisorManager {
    private static final Logger log = new Logger(SQLMetadataSupervisorManager.class);
    private final ObjectMapper jsonMapper;
    private final SQLMetadataConnector connector;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final IDBI dbi;

    @Inject
    public SQLMetadataSupervisorManager(@Json ObjectMapper jsonMapper, SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables) {
        this.jsonMapper = jsonMapper;
        this.connector = connector;
        this.dbTables = dbTables;
        this.dbi = connector.getDBI();
    }

    @Override
    @LifecycleStart
    public void start() {
        this.connector.createSupervisorsTable();
    }

    @Override
    public void insert(final String id, final SupervisorSpec spec) {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s (spec_id, created_date, payload) VALUES (:spec_id, :created_date, :payload)", (Object[])new Object[]{SQLMetadataSupervisorManager.this.getSupervisorsTable()})).bind("spec_id", id)).bind("created_date", DateTimes.nowUtc().toString())).bind("payload", SQLMetadataSupervisorManager.this.jsonMapper.writeValueAsBytes((Object)spec))).execute();
                return null;
            }
        });
    }

    @Override
    public Map<String, List<VersionedSupervisorSpec>> getAll() {
        return ImmutableMap.copyOf((Map)((Map)this.dbi.withHandle((HandleCallback)new HandleCallback<Map<String, List<VersionedSupervisorSpec>>>(){

            public Map<String, List<VersionedSupervisorSpec>> withHandle(Handle handle) {
                return (Map)handle.createQuery(StringUtils.format((String)"SELECT id, spec_id, created_date, payload FROM %1$s ORDER BY id DESC", (Object[])new Object[]{SQLMetadataSupervisorManager.this.getSupervisorsTable()})).map((ResultSetMapper)new ResultSetMapper<Pair<String, VersionedSupervisorSpec>>(){

                    public Pair<String, VersionedSupervisorSpec> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        return Pair.of((Object)r.getString("spec_id"), (Object)SQLMetadataSupervisorManager.this.createVersionSupervisorSpecFromResponse(r));
                    }
                }).fold(new HashMap(), (Folder3)new Folder3<Map<String, List<VersionedSupervisorSpec>>, Pair<String, VersionedSupervisorSpec>>(){

                    public Map<String, List<VersionedSupervisorSpec>> fold(Map<String, List<VersionedSupervisorSpec>> retVal, Pair<String, VersionedSupervisorSpec> pair, FoldController foldController, StatementContext statementContext) {
                        try {
                            String specId = (String)pair.lhs;
                            retVal.computeIfAbsent(specId, sId -> new ArrayList()).add(pair.rhs);
                            return retVal;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        })));
    }

    @Override
    public List<VersionedSupervisorSpec> getAllForId(final String id) {
        return ImmutableList.copyOf((Collection)((Collection)this.dbi.withHandle((HandleCallback)new HandleCallback<List<VersionedSupervisorSpec>>(){

            public List<VersionedSupervisorSpec> withHandle(Handle handle) {
                return ((Query)handle.createQuery(StringUtils.format((String)"SELECT id, spec_id, created_date, payload FROM %1$s WHERE spec_id = :spec_id ORDER BY id DESC", (Object[])new Object[]{SQLMetadataSupervisorManager.this.getSupervisorsTable()})).bind("spec_id", id)).map((ResultSetMapper)new ResultSetMapper<VersionedSupervisorSpec>(){

                    public VersionedSupervisorSpec map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        return SQLMetadataSupervisorManager.this.createVersionSupervisorSpecFromResponse(r);
                    }
                }).list();
            }
        })));
    }

    private VersionedSupervisorSpec createVersionSupervisorSpecFromResponse(ResultSet r) throws SQLException {
        SupervisorSpec payload;
        try {
            payload = (SupervisorSpec)this.jsonMapper.readValue(r.getBytes("payload"), (TypeReference)new TypeReference<SupervisorSpec>(){});
        }
        catch (JsonParseException | JsonMappingException e) {
            log.warn("Failed to deserialize payload for spec_id[%s]", new Object[]{r.getString("spec_id")});
            payload = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new VersionedSupervisorSpec(payload, r.getString("created_date"));
    }

    @Override
    public Map<String, SupervisorSpec> getLatest() {
        return ImmutableMap.copyOf((Map)((Map)this.dbi.withHandle((HandleCallback)new HandleCallback<Map<String, SupervisorSpec>>(){

            public Map<String, SupervisorSpec> withHandle(Handle handle) {
                return (Map)handle.createQuery(StringUtils.format((String)"SELECT r.spec_id, r.payload FROM %1$s r INNER JOIN(SELECT spec_id, max(id) as id FROM %1$s GROUP BY spec_id) latest ON r.id = latest.id", (Object[])new Object[]{SQLMetadataSupervisorManager.this.getSupervisorsTable()})).map((ResultSetMapper)new ResultSetMapper<Pair<String, SupervisorSpec>>(){

                    public Pair<String, SupervisorSpec> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of((Object)r.getString("spec_id"), (Object)SQLMetadataSupervisorManager.this.jsonMapper.readValue(r.getBytes("payload"), (TypeReference)new TypeReference<SupervisorSpec>(){}));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).fold(new HashMap(), (Folder3)new Folder3<Map<String, SupervisorSpec>, Pair<String, SupervisorSpec>>(){

                    public Map<String, SupervisorSpec> fold(Map<String, SupervisorSpec> retVal, Pair<String, SupervisorSpec> stringObjectMap, FoldController foldController, StatementContext statementContext) {
                        try {
                            retVal.put((String)stringObjectMap.lhs, (SupervisorSpec)stringObjectMap.rhs);
                            return retVal;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        })));
    }

    @Override
    public Map<String, SupervisorSpec> getLatestActiveOnly() {
        Map<String, SupervisorSpec> supervisors = this.getLatest();
        HashMap<String, SupervisorSpec> activeSupervisors = new HashMap<String, SupervisorSpec>();
        for (Map.Entry<String, SupervisorSpec> entry : supervisors.entrySet()) {
            if (entry.getValue() instanceof NoopSupervisorSpec) continue;
            activeSupervisors.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf(activeSupervisors);
    }

    @Override
    public Map<String, SupervisorSpec> getLatestTerminatedOnly() {
        Map<String, SupervisorSpec> supervisors = this.getLatest();
        HashMap<String, SupervisorSpec> activeSupervisors = new HashMap<String, SupervisorSpec>();
        for (Map.Entry<String, SupervisorSpec> entry : supervisors.entrySet()) {
            if (!(entry.getValue() instanceof NoopSupervisorSpec)) continue;
            activeSupervisors.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf(activeSupervisors);
    }

    @Override
    public int removeTerminatedSupervisorsOlderThan(long timestamp) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        Map<String, SupervisorSpec> terminatedSupervisors = this.getLatestTerminatedOnly();
        return (Integer)this.dbi.withHandle(handle -> {
            PreparedBatch batch = handle.prepareBatch(StringUtils.format((String)"DELETE FROM %1$s WHERE spec_id = :spec_id AND created_date < '%2$s'", (Object[])new Object[]{this.getSupervisorsTable(), dateTime.toString()}));
            for (Map.Entry supervisor : terminatedSupervisors.entrySet()) {
                ((PreparedBatch)batch.bind("spec_id", (String)supervisor.getKey())).add();
            }
            int[] result = batch.execute();
            return IntStream.of(result).sum();
        });
    }

    private String getSupervisorsTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getSupervisorTable();
    }
}

