/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.input.SqlEntity;
import org.apache.druid.segment.realtime.firehose.PrefetchSqlFirehoseFactory;

public class SqlFirehoseFactory
extends PrefetchSqlFirehoseFactory<String> {
    @JsonProperty
    private final List<String> sqls;
    @Nullable
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    private final ObjectMapper objectMapper;
    @JsonProperty
    private final SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector;
    private final boolean foldCase;

    @JsonCreator
    public SqlFirehoseFactory(@JsonProperty(value="sqls") List<String> sqls, @JsonProperty(value="maxCacheCapacityBytes") Long maxCacheCapacityBytes, @JsonProperty(value="maxFetchCapacityBytes") Long maxFetchCapacityBytes, @JsonProperty(value="prefetchTriggerBytes") Long prefetchTriggerBytes, @JsonProperty(value="fetchTimeout") Long fetchTimeout, @JsonProperty(value="foldCase") boolean foldCase, @JsonProperty(value="database") SQLFirehoseDatabaseConnector sqlFirehoseDatabaseConnector, @JacksonInject @Smile ObjectMapper objectMapper) {
        super(maxCacheCapacityBytes, maxFetchCapacityBytes, prefetchTriggerBytes, fetchTimeout, objectMapper);
        Preconditions.checkArgument((sqls.size() > 0 ? 1 : 0) != 0, (Object)"No SQL queries provided");
        this.sqls = sqls;
        this.objectMapper = objectMapper;
        this.sqlFirehoseDatabaseConnector = (SQLFirehoseDatabaseConnector)Preconditions.checkNotNull((Object)sqlFirehoseDatabaseConnector, (Object)"SQL Metadata Connector not configured!");
        this.foldCase = foldCase;
        this.connectorConfig = null;
    }

    @Override
    protected InputStream openObjectStream(String sql, File fileName) throws IOException {
        SqlEntity.openCleanableFile(sql, this.sqlFirehoseDatabaseConnector, this.objectMapper, this.foldCase, fileName);
        return new FileInputStream(fileName);
    }

    @Override
    protected Collection<String> initObjects() {
        return this.sqls;
    }

    public FiniteFirehoseFactory<InputRowParser<Map<String, Object>>, String> withSplit(InputSplit<String> split) {
        return new SqlFirehoseFactory(Collections.singletonList(split.get()), this.getMaxCacheCapacityBytes(), this.getMaxFetchCapacityBytes(), this.getPrefetchTriggerBytes(), this.getFetchTimeout(), this.foldCase, this.sqlFirehoseDatabaseConnector, this.objectMapper);
    }
}

