/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;

public class RandomBalancerStrategy
implements BalancerStrategy {
    @Override
    public ServerHolder findNewSegmentHomeReplicator(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        List usableServerHolders = serverHolders.stream().filter(serverHolder -> serverHolder.getAvailableSize() >= proposalSegment.getSize() && !serverHolder.isServingSegment(proposalSegment)).collect(Collectors.toList());
        if (usableServerHolders.size() == 0) {
            return null;
        }
        return (ServerHolder)usableServerHolders.get(ThreadLocalRandom.current().nextInt(usableServerHolders.size()));
    }

    @Override
    public ServerHolder findNewSegmentHomeBalancer(DataSegment proposalSegment, List<ServerHolder> serverHolders) {
        return null;
    }

    @Override
    public Iterator<ServerHolder> pickServersToDrop(DataSegment toDropSegment, NavigableSet<ServerHolder> serverHolders) {
        ArrayList<ServerHolder> serverList = new ArrayList<ServerHolder>(serverHolders);
        Collections.shuffle(serverList);
        return serverList.iterator();
    }

    @Override
    public void emitStats(String tier, CoordinatorStats stats, List<ServerHolder> serverHolderList) {
    }
}

