/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;

@NotThreadSafe
public class RoundRobinServerSelector {
    private final Map<String, CircularServerList> tierToServers = new HashMap<String, CircularServerList>();

    public RoundRobinServerSelector(DruidCluster cluster) {
        cluster.getHistoricals().forEach((tier, servers) -> this.tierToServers.put((String)tier, new CircularServerList((Set<ServerHolder>)servers)));
    }

    public Iterator<ServerHolder> getServersInTierToLoadSegment(String tier, DataSegment segment) {
        CircularServerList iterator = this.tierToServers.get(tier);
        if (iterator == null) {
            return Collections.emptyIterator();
        }
        return new EligibleServerIterator(segment, iterator);
    }

    private static class CircularServerList {
        final List<ServerHolder> servers = new ArrayList<ServerHolder>();
        int currentPosition;

        CircularServerList(Set<ServerHolder> servers) {
            this.servers.addAll(servers);
        }

        void advanceCursor() {
            if (++this.currentPosition >= this.servers.size()) {
                this.currentPosition = 0;
            }
        }

        ServerHolder peekNext() {
            int nextPosition = this.currentPosition < this.servers.size() ? this.currentPosition : 0;
            return this.servers.get(nextPosition);
        }
    }

    private static class EligibleServerIterator
    implements Iterator<ServerHolder> {
        final CircularServerList delegate;
        final DataSegment segment;
        ServerHolder nextEligible;
        int remainingIterations;

        EligibleServerIterator(DataSegment segment, CircularServerList delegate) {
            this.delegate = delegate;
            this.segment = segment;
            this.remainingIterations = delegate.servers.size();
            this.nextEligible = this.search();
        }

        @Override
        public boolean hasNext() {
            return this.nextEligible != null;
        }

        @Override
        public ServerHolder next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ServerHolder previous = this.nextEligible;
            this.delegate.advanceCursor();
            this.nextEligible = this.search();
            return previous;
        }

        ServerHolder search() {
            while (this.remainingIterations-- > 0) {
                ServerHolder nextServer = this.delegate.peekNext();
                if (nextServer.canLoadSegment(this.segment)) {
                    return nextServer;
                }
                this.delegate.advanceCursor();
            }
            return null;
        }
    }
}

