/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.function.Function;
import org.apache.druid.common.exception.SanitizableException;

public class ForbiddenException
extends RuntimeException
implements SanitizableException {
    public ForbiddenException() {
        super("Unauthorized");
    }

    @JsonCreator
    public ForbiddenException(@JsonProperty(value="errorMessage") String msg) {
        super(msg);
    }

    @JsonProperty
    public String getErrorMessage() {
        return super.getMessage();
    }

    public ForbiddenException sanitize(Function<String, String> errorMessageTransformFunction) {
        String transformedErrorMessage = errorMessageTransformFunction.apply(this.getMessage());
        if (Strings.isNullOrEmpty((String)transformedErrorMessage)) {
            return new ForbiddenException();
        }
        return new ForbiddenException(transformedErrorMessage);
    }
}

