/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.junit.Assert;
import org.junit.Test;

public class CsvInputFormatTest
extends BaseExternTableTest {
    @Test
    public void testDefaults() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(CSV_FORMAT).column("a", "VARCHAR").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("csv");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        CsvInputFormat csvFormat = (CsvInputFormat)inputFormat;
        Assert.assertEquals((long)0L, (long)csvFormat.getSkipHeaderRows());
        Assert.assertFalse((boolean)csvFormat.isFindColumnsFromHeader());
        Assert.assertNull((Object)csvFormat.getListDelimiter());
        Assert.assertEquals(Collections.singletonList("a"), (Object)csvFormat.getColumns());
    }

    @Test
    public void testConversion() {
        CsvInputFormat format = new CsvInputFormat(Collections.singletonList("a"), ";", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(this.formatToMap((InputFormat)format)).column("a", "VARCHAR").column("b", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("csv");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        CsvInputFormat csvFormat = (CsvInputFormat)inputFormat;
        Assert.assertEquals((long)1L, (long)csvFormat.getSkipHeaderRows());
        Assert.assertFalse((boolean)csvFormat.isFindColumnsFromHeader());
        Assert.assertEquals((Object)";", (Object)csvFormat.getListDelimiter());
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)csvFormat.getColumns());
    }

    @Test
    public void testFunctionParams() {
        InputFormatDefn defn = this.registry.inputFormatDefnFor("csv");
        List params = defn.parameters();
        Assert.assertEquals((long)2L, (long)params.size());
    }

    @Test
    public void testCreateFromArgs() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("listDelimiter", ";");
        args.put("skipHeaderRows", 1);
        InputFormatDefn defn = this.registry.inputFormatDefnFor("csv");
        List<ColumnSpec> columns = Collections.singletonList(new ColumnSpec("a", null, null));
        InputFormat inputFormat = defn.convertFromArgs(args, columns, this.mapper);
        CsvInputFormat csvFormat = (CsvInputFormat)inputFormat;
        Assert.assertEquals((long)1L, (long)csvFormat.getSkipHeaderRows());
        Assert.assertFalse((boolean)csvFormat.isFindColumnsFromHeader());
        Assert.assertEquals((Object)";", (Object)csvFormat.getListDelimiter());
        Assert.assertEquals(Collections.singletonList("a"), (Object)csvFormat.getColumns());
    }
}

