/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.junit.Assert;
import org.junit.Test;

public class DelimitedInputFormatTest
extends BaseExternTableTest {
    @Test
    public void testDefaults() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat((Map)ImmutableMap.of((Object)"type", (Object)"tsv", (Object)"delimiter", (Object)"|")).column("a", "VARCHAR").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("tsv");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        DelimitedInputFormat delmited = (DelimitedInputFormat)inputFormat;
        Assert.assertEquals((long)0L, (long)delmited.getSkipHeaderRows());
        Assert.assertFalse((boolean)delmited.isFindColumnsFromHeader());
        Assert.assertNull((Object)delmited.getListDelimiter());
        Assert.assertEquals((Object)"|", (Object)delmited.getDelimiter());
        Assert.assertEquals(Collections.singletonList("a"), (Object)delmited.getColumns());
    }

    @Test
    public void testConversion() {
        DelimitedInputFormat format = new DelimitedInputFormat(Collections.singletonList("a"), ";", "|", Boolean.valueOf(false), Boolean.valueOf(false), 1);
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(this.formatToMap((InputFormat)format)).column("a", "VARCHAR").column("b", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("tsv");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        DelimitedInputFormat delmited = (DelimitedInputFormat)inputFormat;
        Assert.assertEquals((long)1L, (long)delmited.getSkipHeaderRows());
        Assert.assertFalse((boolean)delmited.isFindColumnsFromHeader());
        Assert.assertEquals((Object)";", (Object)delmited.getListDelimiter());
        Assert.assertEquals((Object)"|", (Object)delmited.getDelimiter());
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)delmited.getColumns());
    }

    @Test
    public void testFunctionParams() {
        InputFormatDefn defn = this.registry.inputFormatDefnFor("tsv");
        List params = defn.parameters();
        Assert.assertEquals((long)3L, (long)params.size());
        Assert.assertTrue((boolean)this.hasParam(params, "delimiter"));
    }

    @Test
    public void testCreateFromArgs() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("delimiter", "|");
        args.put("listDelimiter", ";");
        args.put("skipHeaderRows", 1);
        InputFormatDefn defn = this.registry.inputFormatDefnFor("tsv");
        List<ColumnSpec> columns = Collections.singletonList(new ColumnSpec("a", null, null));
        InputFormat inputFormat = defn.convertFromArgs(args, columns, this.mapper);
        DelimitedInputFormat delmited = (DelimitedInputFormat)inputFormat;
        Assert.assertEquals((long)1L, (long)delmited.getSkipHeaderRows());
        Assert.assertFalse((boolean)delmited.isFindColumnsFromHeader());
        Assert.assertEquals((Object)";", (Object)delmited.getListDelimiter());
        Assert.assertEquals((Object)"|", (Object)delmited.getDelimiter());
        Assert.assertEquals(Collections.singletonList("a"), (Object)delmited.getColumns());
    }
}

