/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.fasterxml.jackson.databind.InjectableValues;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.ExternalTableDefn;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.InputSourceDefn;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.druid.data.input.impl.HttpInputSource;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.EnvironmentVariablePasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpInputSourceDefnTest
extends BaseExternTableTest {
    @Before
    public void setup() {
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(HttpInputSourceConfig.class, (Object)new HttpInputSourceConfig(HttpInputSourceConfig.DEFAULT_ALLOWED_PROTOCOLS)));
    }

    @Test
    public void testEmptyInputSource() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"http")).inputFormat(CSV_FORMAT).column("x", "VARCHAR").column("y", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testInvalidTemplate() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"http")).property("uriTemplate", (Object)"http://example.com/").inputFormat(CSV_FORMAT).column("x", "VARCHAR").column("y", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testNoFormatWithURI() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://example.com/file.csv")), null, null, new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).column("x", "VARCHAR").column("y", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testNoColumnsWithUri() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://example.com/file.csv")), null, null, new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testNoFormatWithTemplate() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"http")).property("uriTemplate", (Object)"http://example.com/{}").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
    }

    @Test
    public void testURIAndTemplate() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://example.com/file.csv")), null, null, new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).property("uriTemplate", (Object)"http://example.com/{}").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertThrows(IAE.class, () -> resolved.validate());
    }

    @Test
    public void testAdHocBadFormat() {
        InputSourceDefn httpDefn = this.registry.inputSourceDefnFor("http");
        TableFunction fn = httpDefn.adHocTableFn();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("uris", new String[]{"http://foo.com/my.csv"});
        args.put("format", "bogus");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
    }

    @Test
    public void testAdHocBadUri() {
        InputSourceDefn httpDefn = this.registry.inputSourceDefnFor("http");
        TableFunction fn = httpDefn.adHocTableFn();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("uris", new String[]{"bogus"});
        args.put("format", "csv");
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, COLUMNS, this.mapper));
    }

    @Test
    public void testAdHocHappyPath() {
        InputSourceDefn httpDefn = this.registry.inputSourceDefnFor("http");
        TableFunction fn = httpDefn.adHocTableFn();
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
        Assert.assertTrue((boolean)this.hasParam(fn, "userName"));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("uris", Collections.singletonList("http://foo.com/my.csv"));
        args.put("userName", "bob");
        args.put("password", "secret");
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        this.validateHappyPath(externSpec, true);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", args, Collections.emptyList(), this.mapper));
    }

    @Test
    public void testFullTableSpecHappyPath() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://foo.com/my.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertNotNull((Object)resolved);
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        ExternalTableSpec externSpec = externDefn.convert(resolved);
        this.validateHappyPath(externSpec, true);
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertTrue((boolean)fn.parameters().isEmpty());
        externSpec = fn.apply("x", Collections.emptyMap(), Collections.emptyList(), this.mapper);
        this.validateHappyPath(externSpec, true);
        Assert.assertThrows(IAE.class, () -> fn.apply("x", Collections.emptyMap(), COLUMNS, this.mapper));
    }

    @Test
    public void testTemplateSpecWithFormatHappyPath() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"http")).inputFormat(CSV_FORMAT).property("uriTemplate", (Object)"http://foo.com/{}").column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertNotNull((Object)resolved);
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        Assert.assertThrows(IAE.class, () -> externDefn.convert(resolved));
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertEquals((long)4L, (long)fn.parameters().size());
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        Assert.assertTrue((boolean)this.hasParam(fn, "userName"));
        Assert.assertTrue((boolean)this.hasParam(fn, "password"));
        Assert.assertTrue((boolean)this.hasParam(fn, "passwordEnvVar"));
        ExternalTableSpec externSpec = fn.apply("x", (Map)ImmutableMap.of((Object)"uris", Collections.singletonList("my.csv")), Collections.emptyList(), this.mapper);
        this.validateHappyPath(externSpec, false);
    }

    @Test
    public void testTemplateSpecWithFormatAndPassword() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource((Map)ImmutableMap.of((Object)"type", (Object)"http", (Object)"httpAuthenticationUsername", (Object)"bob", (Object)"httpAuthenticationPassword", (Object)ImmutableMap.of((Object)"type", (Object)"default", (Object)"password", (Object)"secret"))).inputFormat(CSV_FORMAT).property("uriTemplate", (Object)"http://foo.com/{}").column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        Assert.assertNotNull((Object)resolved);
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        Assert.assertThrows(IAE.class, () -> externDefn.convert(resolved));
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertEquals((long)1L, (long)fn.parameters().size());
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        ExternalTableSpec externSpec = fn.apply("x", (Map)ImmutableMap.of((Object)"uris", Collections.singletonList("my.csv")), Collections.emptyList(), this.mapper);
        this.validateHappyPath(externSpec, true);
    }

    @Test
    public void testTemplateSpecWithoutFormatHappyPath() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://foo.com/my.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.httpToMap(inputSource)).property("uriTemplate", (Object)"http://foo.com/{}").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        Assert.assertThrows(IAE.class, () -> externDefn.convert(resolved));
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
        Assert.assertFalse((boolean)this.hasParam(fn, "userName"));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("uris", Collections.singletonList("my.csv"));
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        this.validateHappyPath(externSpec, true);
    }

    @Test
    public void testMultipleURIsInTableSpec() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Arrays.asList(new URI("http://foo.com/foo.csv"), new URI("http://foo.com/bar.csv")), "bob", (PasswordProvider)new EnvironmentVariablePasswordProvider("SECRET"), new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        ExternalTableSpec externSpec = externDefn.convert(resolved);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)CatalogUtils.stringListToUriList(Arrays.asList("http://foo.com/foo.csv", "http://foo.com/bar.csv")), (Object)sourceSpec.getUris());
        Assert.assertEquals(Collections.singleton("http"), (Object)externSpec.inputSourceTypesSupplier.get());
    }

    @Test
    public void testMultipleURIsWithTemplate() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://foo.com/my.csv")), "bob", (PasswordProvider)new DefaultPasswordProvider("secret"), new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.httpToMap(inputSource)).inputFormat(CSV_FORMAT).property("uriTemplate", (Object)"http://foo.com/{}").column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        TableFunction fn = externDefn.tableFn(resolved);
        Assert.assertEquals((long)1L, (long)fn.parameters().size());
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        ExternalTableSpec externSpec = fn.apply("x", (Map)ImmutableMap.of((Object)"uris", Arrays.asList("my.csv", "bar.csv")), Collections.emptyList(), this.mapper);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)CatalogUtils.stringListToUriList(Arrays.asList("http://foo.com/my.csv", "http://foo.com/bar.csv")), (Object)sourceSpec.getUris());
        Assert.assertEquals(Collections.singleton("http"), (Object)externSpec.inputSourceTypesSupplier.get());
    }

    @Test
    public void testMultipleURIsAdHoc() {
        InputSourceDefn httpDefn = this.registry.inputSourceDefnFor("http");
        TableFunction fn = httpDefn.adHocTableFn();
        Assert.assertTrue((boolean)this.hasParam(fn, "uris"));
        Assert.assertTrue((boolean)this.hasParam(fn, "format"));
        Assert.assertTrue((boolean)this.hasParam(fn, "userName"));
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("uris", Arrays.asList("http://foo.com/foo.csv", "http://foo.com/bar.csv"));
        args.put("format", "csv");
        ExternalTableSpec externSpec = fn.apply("x", args, COLUMNS, this.mapper);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)CatalogUtils.stringListToUriList(Arrays.asList("http://foo.com/foo.csv", "http://foo.com/bar.csv")), (Object)sourceSpec.getUris());
        Assert.assertEquals(Collections.singleton("http"), (Object)externSpec.inputSourceTypesSupplier.get());
    }

    @Test
    public void testEnvPassword() throws URISyntaxException {
        HttpInputSource inputSource = new HttpInputSource(Collections.singletonList(new URI("http://foo.com/my.csv")), "bob", (PasswordProvider)new EnvironmentVariablePasswordProvider("SECRET"), new HttpInputSourceConfig(null));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(inputSource)).inputFormat(CSV_FORMAT).column("x", "VARCHAR").column("y", "BIGINT").build();
        table.validate();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        ExternalTableDefn externDefn = (ExternalTableDefn)resolved.defn();
        ExternalTableSpec externSpec = externDefn.convert(resolved);
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource;
        Assert.assertEquals((Object)"bob", (Object)sourceSpec.getHttpAuthenticationUsername());
        Assert.assertEquals((Object)"SECRET", (Object)((EnvironmentVariablePasswordProvider)sourceSpec.getHttpAuthenticationPasswordProvider()).getVariable());
        Assert.assertEquals(Collections.singleton("http"), (Object)externSpec.inputSourceTypesSupplier.get());
    }

    private void validateHappyPath(ExternalTableSpec externSpec, boolean withUser) {
        HttpInputSource sourceSpec = (HttpInputSource)externSpec.inputSource;
        if (withUser) {
            Assert.assertEquals((Object)"bob", (Object)sourceSpec.getHttpAuthenticationUsername());
            Assert.assertEquals((Object)"secret", (Object)((DefaultPasswordProvider)sourceSpec.getHttpAuthenticationPasswordProvider()).getPassword());
        }
        Assert.assertEquals((Object)"http://foo.com/my.csv", (Object)((URI)sourceSpec.getUris().get(0)).toString());
        CsvInputFormat csvFormat = (CsvInputFormat)externSpec.inputFormat;
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)csvFormat.getColumns());
        RowSignature sig = externSpec.signature;
        Assert.assertEquals(Arrays.asList("x", "y"), (Object)sig.getColumnNames());
        Assert.assertEquals((Object)ColumnType.STRING, sig.getColumnType(0).get());
        Assert.assertEquals((Object)ColumnType.LONG, sig.getColumnType(1).get());
        Assert.assertEquals(Collections.singleton("http"), (Object)externSpec.inputSourceTypesSupplier.get());
    }

    private Map<String, Object> httpToMap(HttpInputSource source) {
        Map<String, Object> sourceMap = this.toMap(source);
        sourceMap.remove("uris");
        return sourceMap;
    }
}

