/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableMetadata;
import org.apache.druid.catalog.model.table.BaseExternTableTest;
import org.apache.druid.catalog.model.table.InputFormatDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class JsonInputFormatTest
extends BaseExternTableTest {
    @Test
    public void testDefaults() {
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat((Map)ImmutableMap.of((Object)"type", (Object)"json")).column("a", "VARCHAR").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("json");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        JsonInputFormat jsonFormat = (JsonInputFormat)inputFormat;
        Assert.assertNull((Object)jsonFormat.getFlattenSpec());
        Assert.assertTrue((boolean)jsonFormat.getFeatureSpec().isEmpty());
        Assert.assertFalse((boolean)jsonFormat.isKeepNullColumns());
        Assert.assertFalse((boolean)jsonFormat.isAssumeNewlineDelimited());
        Assert.assertFalse((boolean)jsonFormat.isUseJsonNodeReader());
    }

    @Test
    public void testConversion() {
        JsonInputFormat format = new JsonInputFormat(null, null, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        TableMetadata table = TableBuilder.external((String)"foo").inputSource(this.toMap(new InlineInputSource("a\n"))).inputFormat(this.formatToMap((InputFormat)format)).column("a", "VARCHAR").column("b", "BIGINT").build();
        ResolvedTable resolved = this.registry.resolve(table.spec());
        resolved.validate();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("json");
        InputFormat inputFormat = defn.convertFromTable(new ResolvedExternalTable(resolved));
        JsonInputFormat jsonFormat = (JsonInputFormat)inputFormat;
        Assert.assertNull((Object)jsonFormat.getFlattenSpec());
        Assert.assertTrue((boolean)jsonFormat.getFeatureSpec().isEmpty());
        Assert.assertTrue((boolean)jsonFormat.isKeepNullColumns());
        Assert.assertTrue((boolean)jsonFormat.isAssumeNewlineDelimited());
        Assert.assertFalse((boolean)jsonFormat.isUseJsonNodeReader());
    }

    @Test
    public void testFunctionParams() {
        InputFormatDefn defn = this.registry.inputFormatDefnFor("json");
        List params = defn.parameters();
        Assert.assertEquals((long)0L, (long)params.size());
    }

    @Test
    public void testCreateFromArgs() {
        HashMap args = new HashMap();
        InputFormatDefn defn = this.registry.inputFormatDefnFor("json");
        List<ColumnSpec> columns = Collections.singletonList(new ColumnSpec("a", null, null));
        InputFormat inputFormat = defn.convertFromArgs(args, columns, this.mapper);
        JsonInputFormat jsonFormat = (JsonInputFormat)inputFormat;
        Assert.assertNull((Object)jsonFormat.getFlattenSpec());
        Assert.assertTrue((boolean)jsonFormat.getFeatureSpec().isEmpty());
        Assert.assertFalse((boolean)jsonFormat.isKeepNullColumns());
        Assert.assertFalse((boolean)jsonFormat.isAssumeNewlineDelimited());
        Assert.assertFalse((boolean)jsonFormat.isUseJsonNodeReader());
    }
}

