/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.HttpIndexingServiceClient;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.segment.NestedDataDimensionSchema;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpIndexingServiceClientTest {
    private HttpIndexingServiceClient httpIndexingServiceClient;
    private ObjectMapper jsonMapper;
    private DruidLeaderClient druidLeaderClient;
    private ObjectMapper mockMapper;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.jsonMapper = new DefaultObjectMapper();
        this.druidLeaderClient = (DruidLeaderClient)EasyMock.createMock(DruidLeaderClient.class);
        this.mockMapper = (ObjectMapper)EasyMock.createMock(ObjectMapper.class);
        this.httpIndexingServiceClient = new HttpIndexingServiceClient(this.jsonMapper, this.druidLeaderClient);
    }

    @Test
    public void testSample() throws Exception {
        final SamplerResponse samplerResponse = new SamplerResponse(2, 2, (List)ImmutableList.of((Object)new StringDimensionSchema("x"), (Object)new StringDimensionSchema("y")), (List)ImmutableList.of((Object)new NestedDataDimensionSchema("x"), (Object)new NestedDataDimensionSchema("y")), RowSignature.builder().addTimeColumn().add("x", ColumnType.STRING).add("y", ColumnType.STRING).build(), (List)ImmutableList.of((Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), Boolean.valueOf(false), null)));
        SamplerSpec samplerSpec = new SamplerSpec(){

            public SamplerResponse sample() {
                return samplerResponse;
            }
        };
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)samplerResponse));
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/sampler")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/sampler"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        SamplerResponse actualResponse = this.httpIndexingServiceClient.sample(samplerSpec);
        Assert.assertEquals((Object)samplerResponse, (Object)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testSampleError() throws Exception {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Failed to sample with sampler spec");
        this.expectedException.expectMessage("Please check overlord log");
        final SamplerResponse samplerResponse = new SamplerResponse(2, 2, (List)ImmutableList.of((Object)new StringDimensionSchema("x"), (Object)new StringDimensionSchema("y")), (List)ImmutableList.of((Object)new NestedDataDimensionSchema("x"), (Object)new NestedDataDimensionSchema("y")), RowSignature.builder().addTimeColumn().add("x", ColumnType.STRING).add("y", ColumnType.STRING).build(), (List)ImmutableList.of((Object)new SamplerResponse.SamplerResponseRow((Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), (Map)ImmutableMap.of((Object)"time", (Object)"2020-01-01", (Object)"x", (Object)"123", (Object)"y", (Object)"456"), Boolean.valueOf(false), null)));
        SamplerSpec samplerSpec = new SamplerSpec(){

            public SamplerResponse sample() {
                return samplerResponse;
            }
        };
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk("");
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/sampler")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/sampler"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        this.httpIndexingServiceClient.sample(samplerSpec);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testGetTaskReport() throws Exception {
        String taskId = "testTaskId";
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        ImmutableMap dummyResponse = ImmutableMap.of((Object)"test", (Object)"value");
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)dummyResponse));
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports")).andReturn((Object)new Request(HttpMethod.GET, new URL("http://localhost:8090/druid/indexer/v1/task/testTaskId/reports"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        Map actualResponse = this.httpIndexingServiceClient.getTaskReport(taskId);
        Assert.assertEquals((Object)dummyResponse, (Object)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testGetTaskReportStatusNotFound() throws Exception {
        String taskId = "testTaskId";
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        String errorMsg = "No task reports were found for this task. The task may not exist, or it may not have completed yet.";
        ChannelBuffer buf = ChannelBuffers.buffer((int)errorMsg.length());
        buf.writeBytes(errorMsg.getBytes(StandardCharsets.UTF_8));
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.NOT_FOUND).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)buf);
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk("");
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports")).andReturn((Object)new Request(HttpMethod.GET, new URL("http://localhost:8090/druid/indexer/v1/task/testTaskId/reports"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        Map actualResponse = this.httpIndexingServiceClient.getTaskReport(taskId);
        Assert.assertNull((Object)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testGetTaskReportEmpty() throws Exception {
        String taskId = "testTaskId";
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk("");
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/task/testTaskId/reports")).andReturn((Object)new Request(HttpMethod.GET, new URL("http://localhost:8090/druid/indexer/v1/task/testTaskId/reports"))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        Map actualResponse = this.httpIndexingServiceClient.getTaskReport(taskId);
        Assert.assertNull((Object)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient, response});
    }

    @Test
    public void testCompact() throws Exception {
        DataSegment segment = new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"bucket", (Object)"bucket", (Object)"path", (Object)"test/2015-04-12T00:00:00.000Z_2015-04-13T00:00:00.000Z/1/0/index.zip"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L);
        Capture captureTask = EasyMock.newCapture();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"task", (Object)"aaa")));
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/task"))).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.mockMapper.writeValueAsBytes(EasyMock.capture((Capture)captureTask))).andReturn((Object)new byte[]{1, 2, 3}).anyTimes();
        EasyMock.expect((Object)this.mockMapper.readValue(EasyMock.anyString(), (TypeReference)EasyMock.eq((Object)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT))).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient, this.mockMapper});
        HttpIndexingServiceClient httpIndexingServiceClient = new HttpIndexingServiceClient(this.mockMapper, this.druidLeaderClient);
        try {
            httpIndexingServiceClient.compactSegments("test-compact", (List)ImmutableList.of((Object)segment), 50, null, null, null, null, null, null, null);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)IllegalStateException.class.getName(), (Object)e.getCause().getClass().getName());
        }
        ClientCompactionTaskQuery taskQuery = (ClientCompactionTaskQuery)captureTask.getValue();
        Assert.assertEquals((Object)Intervals.of((String)"2015-04-12/2015-04-13"), (Object)taskQuery.getIoConfig().getInputSpec().getInterval());
        Assert.assertNull((Object)taskQuery.getGranularitySpec());
        Assert.assertNull((Object)taskQuery.getIoConfig().getInputSpec().getSha256OfSortedSegmentIds());
    }

    @Test
    public void testCompactWithSegmentGranularity() throws Exception {
        DataSegment segment = new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"bucket", (Object)"bucket", (Object)"path", (Object)"test/2015-04-12T00:00:00.000Z_2015-04-13T00:00:00.000Z/1/0/index.zip"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L);
        Capture captureTask = EasyMock.newCapture();
        HttpResponse response = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)response.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)response.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{response});
        StringFullResponseHolder responseHolder = new StringFullResponseHolder(response, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"task", (Object)"aaa")));
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task")).andReturn((Object)new Request(HttpMethod.POST, new URL("http://localhost:8090/druid/indexer/v1/task"))).anyTimes();
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)responseHolder).anyTimes();
        EasyMock.expect((Object)this.mockMapper.writeValueAsBytes(EasyMock.capture((Capture)captureTask))).andReturn((Object)new byte[]{1, 2, 3}).anyTimes();
        EasyMock.expect((Object)this.mockMapper.readValue(EasyMock.anyString(), (TypeReference)EasyMock.eq((Object)JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT))).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient, this.mockMapper});
        HttpIndexingServiceClient httpIndexingServiceClient = new HttpIndexingServiceClient(this.mockMapper, this.druidLeaderClient);
        try {
            httpIndexingServiceClient.compactSegments("test-compact", (List)ImmutableList.of((Object)segment), 50, null, new ClientCompactionTaskGranularitySpec(Granularities.YEAR, null, null), null, null, null, null, null);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)IllegalStateException.class.getName(), (Object)e.getCause().getClass().getName());
        }
        ClientCompactionTaskQuery taskQuery = (ClientCompactionTaskQuery)captureTask.getValue();
        Assert.assertEquals((Object)Intervals.of((String)"2015-01-01/2016-01-01"), (Object)taskQuery.getIoConfig().getInputSpec().getInterval());
        Assert.assertEquals((Object)Granularities.YEAR, (Object)taskQuery.getGranularitySpec().getSegmentGranularity());
        Assert.assertNull((Object)taskQuery.getIoConfig().getInputSpec().getSha256OfSortedSegmentIds());
    }

    @Test
    public void testGetTotalWorkerCapacityWithAutoScale() throws Exception {
        int currentClusterCapacity = 5;
        int maximumCapacityWithAutoScale = 10;
        HttpResponse totalWorkerCapacityResponse = (HttpResponse)EasyMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)totalWorkerCapacityResponse.getStatus()).andReturn((Object)HttpResponseStatus.OK).anyTimes();
        EasyMock.expect((Object)totalWorkerCapacityResponse.getContent()).andReturn((Object)new BigEndianHeapChannelBuffer(0));
        EasyMock.replay((Object[])new Object[]{totalWorkerCapacityResponse});
        IndexingTotalWorkerCapacityInfo indexingTotalWorkerCapacityInfo = new IndexingTotalWorkerCapacityInfo(currentClusterCapacity, maximumCapacityWithAutoScale);
        StringFullResponseHolder autoScaleResponseHolder = new StringFullResponseHolder(totalWorkerCapacityResponse, StandardCharsets.UTF_8).addChunk(this.jsonMapper.writeValueAsString((Object)indexingTotalWorkerCapacityInfo));
        EasyMock.expect((Object)this.druidLeaderClient.go((Request)EasyMock.anyObject(Request.class))).andReturn((Object)autoScaleResponseHolder).once();
        EasyMock.expect((Object)this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/totalWorkerCapacity")).andReturn((Object)new Request(HttpMethod.GET, new URL("http://localhost:8090/druid/indexer/v1/totalWorkerCapacity"))).once();
        EasyMock.replay((Object[])new Object[]{this.druidLeaderClient});
        int actualResponse = this.httpIndexingServiceClient.getTotalWorkerCapacityWithAutoScale();
        Assert.assertEquals((long)maximumCapacityWithAutoScale, (long)actualResponse);
        EasyMock.verify((Object[])new Object[]{this.druidLeaderClient});
    }
}

