/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.security;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.security.DruidAuthModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.server.security.AuthConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidAuthModuleTest {
    private Injector injector;
    private DruidAuthModule authModule;

    @Before
    public void setup() {
        this.authModule = new DruidAuthModule();
        this.injector = Guice.createInjector((Module[])new Module[]{new JacksonModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
        }, this.authModule});
    }

    @Test
    public void testAuthConfigSingleton() {
        AuthConfig config1 = (AuthConfig)this.injector.getInstance(AuthConfig.class);
        AuthConfig config2 = (AuthConfig)this.injector.getInstance(AuthConfig.class);
        Assert.assertNotNull((Object)config1);
        Assert.assertSame((Object)config1, (Object)config2);
    }

    @Test
    public void testAuthConfigDefault() {
        Properties properties = new Properties();
        AuthConfig authConfig = this.injectProperties(properties);
        Assert.assertNotNull((Object)authConfig);
        Assert.assertNull((Object)authConfig.getAuthenticatorChain());
        Assert.assertNull((Object)authConfig.getAuthorizers());
        Assert.assertTrue((boolean)authConfig.getUnsecuredPaths().isEmpty());
        Assert.assertFalse((boolean)authConfig.isAllowUnauthenticatedHttpOptions());
        Assert.assertFalse((boolean)authConfig.authorizeQueryContextParams());
    }

    @Test
    public void testAuthConfigSet() {
        Properties properties = new Properties();
        properties.setProperty("druid.auth.authenticatorChain", "[\"chain\", \"of\", \"authenticators\"]");
        properties.setProperty("druid.auth.authorizers", "[\"authorizers\", \"list\"]");
        properties.setProperty("druid.auth.unsecuredPaths", "[\"path1\", \"path2\"]");
        properties.setProperty("druid.auth.allowUnauthenticatedHttpOptions", "true");
        properties.setProperty("druid.auth.authorizeQueryContextParams", "true");
        AuthConfig authConfig = this.injectProperties(properties);
        Assert.assertNotNull((Object)authConfig);
        Assert.assertEquals((Object)ImmutableList.of((Object)"chain", (Object)"of", (Object)"authenticators"), (Object)authConfig.getAuthenticatorChain());
        Assert.assertEquals((Object)ImmutableList.of((Object)"authorizers", (Object)"list"), (Object)authConfig.getAuthorizers());
        Assert.assertEquals((Object)ImmutableList.of((Object)"path1", (Object)"path2"), (Object)authConfig.getUnsecuredPaths());
        Assert.assertTrue((boolean)authConfig.authorizeQueryContextParams());
    }

    private AuthConfig injectProperties(Properties properties) {
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.auth", AuthConfig.class);
        provider.inject(properties, (JsonConfigurator)this.injector.getInstance(JsonConfigurator.class));
        return (AuthConfig)provider.get().get();
    }
}

