/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.ClosedSegmensSinksBatchAppenderatorTester;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;

public class OpenAndClosedSegmentsAppenderatorTester
implements AutoCloseable {
    public static final String DATASOURCE = "foo";
    private final DataSchema schema;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentPusher dataSegmentPusher;
    private final ObjectMapper objectMapper;
    private final Appenderator appenderator;
    private final IndexIO indexIO;
    private final IndexMergerV9 indexMerger;
    private final ServiceEmitter emitter;
    private final AppenderatorConfig tuningConfig;
    private final List<DataSegment> pushedSegments = new CopyOnWriteArrayList<DataSegment>();

    public OpenAndClosedSegmentsAppenderatorTester(int maxRowsInMemory, boolean enablePushFailure, boolean batchMemoryMappedIndex) {
        this(maxRowsInMemory, -1L, null, enablePushFailure, batchMemoryMappedIndex);
    }

    public OpenAndClosedSegmentsAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, File basePersistDirectory, boolean enablePushFailure, boolean batchMemoryMappedIndex) {
        this(maxRowsInMemory, maxSizeInBytes, basePersistDirectory, enablePushFailure, (RowIngestionMeters)new SimpleRowIngestionMeters(), false, batchMemoryMappedIndex);
    }

    public OpenAndClosedSegmentsAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, File basePersistDirectory, final boolean enablePushFailure, RowIngestionMeters rowIngestionMeters, boolean skipBytesInMemoryOverheadCheck, boolean batchMemoryMappedIndex) {
        this.objectMapper = new DefaultObjectMapper();
        this.objectMapper.registerSubtypes(new Class[]{LinearShardSpec.class});
        Map parserMap = (Map)this.objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), DimensionsSpec.EMPTY, null, null, null)), Map.class);
        this.schema = new DataSchema(DATASOURCE, parserMap, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}, (GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null), null, this.objectMapper);
        this.tuningConfig = new ClosedSegmensSinksBatchAppenderatorTester.TestIndexTuningConfig(TuningConfig.DEFAULT_APPENDABLE_INDEX, maxRowsInMemory, maxSizeInBytes == 0L ? this.getDefaultMaxBytesInMemory() : maxSizeInBytes, skipBytesInMemoryOverheadCheck, IndexSpec.DEFAULT, 0, false, 0L, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), -1, basePersistDirectory == null ? OpenAndClosedSegmentsAppenderatorTester.createNewBasePersistDirectory() : basePersistDirectory);
        this.metrics = new FireDepartmentMetrics();
        this.indexIO = new IndexIO(this.objectMapper, new ColumnConfig(){

            public int columnCacheSizeBytes() {
                return 0;
            }
        });
        this.indexMerger = new IndexMergerV9(this.objectMapper, this.indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.emitter = new ServiceEmitter("test", "test", (Emitter)new NoopEmitter());
        this.emitter.start();
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.dataSegmentPusher = new DataSegmentPusher(){
            private boolean mustFail = true;

            @Deprecated
            public String getPathForHadoop(String dataSource) {
                return this.getPathForHadoop();
            }

            public String getPathForHadoop() {
                throw new UnsupportedOperationException();
            }

            public DataSegment push(File file, DataSegment segment, boolean useUniquePath) throws IOException {
                if (enablePushFailure && this.mustFail) {
                    this.mustFail = false;
                    throw new IOException("Push failure test");
                }
                if (enablePushFailure) {
                    this.mustFail = true;
                }
                OpenAndClosedSegmentsAppenderatorTester.this.pushedSegments.add(segment);
                return segment;
            }

            public Map<String, Object> makeLoadSpec(URI uri) {
                throw new UnsupportedOperationException();
            }
        };
        this.appenderator = batchMemoryMappedIndex ? Appenderators.createOpenSegmentsOffline((String)this.schema.getDataSource(), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (FireDepartmentMetrics)this.metrics, (DataSegmentPusher)this.dataSegmentPusher, (ObjectMapper)this.objectMapper, (IndexIO)this.indexIO, (IndexMerger)this.indexMerger, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)true) : Appenderators.createClosedSegmentsOffline((String)this.schema.getDataSource(), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (FireDepartmentMetrics)this.metrics, (DataSegmentPusher)this.dataSegmentPusher, (ObjectMapper)this.objectMapper, (IndexIO)this.indexIO, (IndexMerger)this.indexMerger, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (boolean)true);
    }

    private long getDefaultMaxBytesInMemory() {
        return Runtime.getRuntime().totalMemory() / 3L;
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public AppenderatorConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }

    public DataSegmentPusher getDataSegmentPusher() {
        return this.dataSegmentPusher;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Appenderator getAppenderator() {
        return this.appenderator;
    }

    public List<DataSegment> getPushedSegments() {
        return this.pushedSegments;
    }

    @Override
    public void close() throws Exception {
        this.appenderator.close();
        this.emitter.close();
        FileUtils.deleteDirectory((File)this.tuningConfig.getBasePersistDirectory());
    }

    private static File createNewBasePersistDirectory() {
        return FileUtils.createTempDir((String)"druid-batch-persist");
    }
}

