/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.Druids;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContextTest;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryLifecycleTest {
    private static final String DATASOURCE = "some_datasource";
    private static final String IDENTITY = "some_identity";
    private static final String AUTHORIZER = "some_authorizer";
    private final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("some_datasource").intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).build();
    QueryToolChestWarehouse toolChestWarehouse;
    QuerySegmentWalker texasRanger;
    GenericQueryMetricsFactory metricsFactory;
    ServiceEmitter emitter;
    RequestLogger requestLogger;
    AuthorizerMapper authzMapper;
    DefaultQueryConfig queryConfig;
    QueryToolChest toolChest;
    QueryRunner runner;
    QueryMetrics metrics;
    AuthenticationResult authenticationResult;
    Authorizer authorizer;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setup() {
        this.toolChestWarehouse = (QueryToolChestWarehouse)EasyMock.createMock(QueryToolChestWarehouse.class);
        this.texasRanger = (QuerySegmentWalker)EasyMock.createMock(QuerySegmentWalker.class);
        this.metricsFactory = (GenericQueryMetricsFactory)EasyMock.createMock(GenericQueryMetricsFactory.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        this.requestLogger = (RequestLogger)EasyMock.createNiceMock(RequestLogger.class);
        this.authorizer = (Authorizer)EasyMock.createMock(Authorizer.class);
        this.authzMapper = new AuthorizerMapper((Map)ImmutableMap.of((Object)AUTHORIZER, (Object)this.authorizer));
        this.queryConfig = (DefaultQueryConfig)EasyMock.createMock(DefaultQueryConfig.class);
        this.toolChest = (QueryToolChest)EasyMock.createMock(QueryToolChest.class);
        this.runner = (QueryRunner)EasyMock.createMock(QueryRunner.class);
        this.metrics = (QueryMetrics)EasyMock.createNiceMock(QueryMetrics.class);
        this.authenticationResult = (AuthenticationResult)EasyMock.createMock(AuthenticationResult.class);
    }

    private QueryLifecycle createLifecycle(AuthConfig authConfig) {
        long nanos = System.nanoTime();
        long millis = System.currentTimeMillis();
        return new QueryLifecycle(this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.authzMapper, this.queryConfig, authConfig, millis, nanos);
    }

    @After
    public void teardown() {
        EasyMock.verify((Object[])new Object[]{this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }

    @Test
    public void testRunSimplePreauthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.texasRanger.getQueryRunnerForIntervals((Query)EasyMock.anyObject(), (Iterable)EasyMock.anyObject())).andReturn((Object)this.runner).once();
        EasyMock.expect((Object)this.runner.run((QueryPlus)EasyMock.anyObject(), (ResponseContext)EasyMock.anyObject())).andReturn((Object)Sequences.empty()).once();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle(new AuthConfig());
        lifecycle.runSimple((Query)this.query, this.authenticationResult, Access.OK);
    }

    @Test
    public void testRunSimpleUnauthorized() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage("Unauthorized");
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        EasyMock.expect((Object)this.toolChest.makeMetrics((Query)EasyMock.anyObject())).andReturn((Object)this.metrics).anyTimes();
        this.replayAll();
        QueryLifecycle lifecycle = this.createLifecycle(new AuthConfig());
        lifecycle.runSimple((Query)this.query, this.authenticationResult, new Access(false));
    }

    @Test
    public void testAuthorizeQueryContext_authorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("baz", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    @Test
    public void testAuthorizeQueryContext_notAuthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.DENIED);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    @Test
    public void testAuthorizeQueryContext_unsecuredKeys() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setUnsecuredContextKeys((Set)ImmutableSet.of((Object)"foo", (Object)"baz")).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    @Test
    public void testAuthorizeQueryContext_securedKeys() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setSecuredContextKeys((Set)ImmutableSet.of((Object)"foo2", (Object)"baz2")).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        HashMap revisedContext = new HashMap(lifecycle.getQuery().getContext());
        Assert.assertTrue((boolean)lifecycle.getQuery().getContext().containsKey("queryId"));
        revisedContext.remove("queryId");
        Assert.assertEquals((Object)userContext, revisedContext);
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    @Test
    public void testAuthorizeQueryContext_securedKeysNotAuthorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource(DATASOURCE, "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.DENIED);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        ImmutableMap userContext = ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)Intervals.ETERNITY)).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).context((Map)userContext).build();
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).setSecuredContextKeys((Set)ImmutableSet.of((Object)"foo", (Object)"baz2")).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        Assert.assertFalse((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    @Test
    public void testAuthorizeLegacyQueryContext_authorized() {
        EasyMock.expect((Object)this.queryConfig.getContext()).andReturn((Object)ImmutableMap.of()).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getIdentity()).andReturn((Object)IDENTITY).anyTimes();
        EasyMock.expect((Object)this.authenticationResult.getAuthorizerName()).andReturn((Object)AUTHORIZER).anyTimes();
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("fake", "DATASOURCE"), Action.READ)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("foo", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.authorizer.authorize(this.authenticationResult, new Resource("baz", "QUERY_CONTEXT"), Action.WRITE)).andReturn((Object)Access.OK);
        EasyMock.expect((Object)this.toolChestWarehouse.getToolChest((Query)EasyMock.anyObject())).andReturn((Object)this.toolChest).once();
        this.replayAll();
        QueryContextTest.LegacyContextQuery query = new QueryContextTest.LegacyContextQuery((Map)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"qux"));
        AuthConfig authConfig = AuthConfig.newBuilder().setAuthorizeQueryContextParams(true).build();
        QueryLifecycle lifecycle = this.createLifecycle(authConfig);
        lifecycle.initialize((Query)query);
        Map revisedContext = lifecycle.getQuery().getContext();
        Assert.assertNotNull((Object)revisedContext);
        Assert.assertTrue((boolean)revisedContext.containsKey("foo"));
        Assert.assertTrue((boolean)revisedContext.containsKey("baz"));
        Assert.assertTrue((boolean)revisedContext.containsKey("queryId"));
        Assert.assertTrue((boolean)lifecycle.authorize(this.mockRequest()).isAllowed());
    }

    private HttpServletRequest mockRequest() {
        HttpServletRequest request = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Authentication-Result"))).andReturn((Object)this.authenticationResult).anyTimes();
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Allow-Unsecured-Path"))).andReturn(null).anyTimes();
        EasyMock.expect((Object)request.getAttribute((String)EasyMock.eq((Object)"Druid-Authorization-Checked"))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        return request;
    }

    private void replayAll() {
        EasyMock.replay((Object[])new Object[]{this.toolChestWarehouse, this.texasRanger, this.metricsFactory, this.emitter, this.requestLogger, this.queryConfig, this.toolChest, this.runner, this.metrics, this.authenticationResult, this.authorizer});
    }
}

