/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.client.DruidServer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerStrategy;
import org.apache.druid.server.coordinator.CostBalancerStrategy;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.RandomBalancerStrategy;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BalancerStrategyTest {
    private final BalancerStrategy balancerStrategy;
    private DataSegment proposedDataSegment;
    private List<ServerHolder> serverHolders;

    @Parameterized.Parameters(name="{index}: BalancerStrategy:{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({new CostBalancerStrategy(Execs.directExecutor())}, {new RandomBalancerStrategy()});
    }

    public BalancerStrategyTest(BalancerStrategy balancerStrategy) {
        this.balancerStrategy = balancerStrategy;
    }

    @Before
    public void setUp() {
        this.proposedDataSegment = new DataSegment("datasource1", Intervals.utc((long)0L, (long)1L), "", new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 11L);
    }

    @Test
    public void findNewSegmentHomeReplicatorNotEnoughSpace() {
        ServerHolder serverHolder = new ServerHolder(new DruidServer("server1", "host1", null, 10L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.proposedDataSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.serverHolders = new ArrayList<ServerHolder>();
        this.serverHolders.add(serverHolder);
        ServerHolder foundServerHolder = this.balancerStrategy.findNewSegmentHomeReplicator(this.proposedDataSegment, this.serverHolders);
        Assert.assertNull((Object)foundServerHolder);
    }

    @Test(timeout=5000L)
    public void findNewSegmentHomeReplicatorNotEnoughNodesForReplication() {
        ServerHolder serverHolder1 = new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.proposedDataSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        ServerHolder serverHolder2 = new ServerHolder(new DruidServer("server2", "host2", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).addDataSegment(this.proposedDataSegment).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.serverHolders = new ArrayList<ServerHolder>();
        this.serverHolders.add(serverHolder1);
        this.serverHolders.add(serverHolder2);
        ServerHolder foundServerHolder = this.balancerStrategy.findNewSegmentHomeReplicator(this.proposedDataSegment, this.serverHolders);
        Assert.assertNull((Object)foundServerHolder);
    }

    @Test
    public void findNewSegmentHomeReplicatorEnoughSpace() {
        ServerHolder serverHolder = new ServerHolder(new DruidServer("server1", "host1", null, 1000L, ServerType.HISTORICAL, "_default_tier", 0).toImmutableDruidServer(), (LoadQueuePeon)new LoadQueuePeonTester());
        this.serverHolders = new ArrayList<ServerHolder>();
        this.serverHolders.add(serverHolder);
        ServerHolder foundServerHolder = this.balancerStrategy.findNewSegmentHomeReplicator(this.proposedDataSegment, this.serverHolders);
        Assert.assertEquals((Object)serverHolder, (Object)foundServerHolder);
    }
}

