/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.carrotsearch.junitbenchmarks.AbstractBenchmark;
import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.coordinator.CostBalancerStrategy;
import org.apache.druid.server.coordinator.CostBalancerStrategyTest;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Ignore
@RunWith(value=Parameterized.class)
public class CostBalancerStrategyBenchmark
extends AbstractBenchmark {
    private final CostBalancerStrategy strategy;
    private static List<ServerHolder> serverHolderList;
    volatile ServerHolder selected;
    private final Interval interval1 = Intervals.of((String)"2015-01-01T01:00:00Z/2015-01-01T02:00:00Z");
    private final Interval interval2 = Intervals.of((String)"2015-02-01T01:00:00Z/2015-02-01T02:00:00Z");
    volatile Long sum;

    @Parameterized.Parameters
    public static List<CostBalancerStrategy[]> factoryClasses() {
        return Arrays.asList({new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)1, (String)"CostBalancerStrategyBenchmark-%d")))}, {new CostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)4, (String)"CostBalancerStrategyBenchmark-%d")))});
    }

    public CostBalancerStrategyBenchmark(CostBalancerStrategy costBalancerStrategy) {
        this.strategy = costBalancerStrategy;
    }

    @BeforeClass
    public static void setup() {
        serverHolderList = CostBalancerStrategyTest.setupDummyCluster(5, 20000);
    }

    @AfterClass
    public static void tearDown() {
        serverHolderList = null;
    }

    @Test
    @BenchmarkOptions(warmupRounds=10, benchmarkRounds=1000)
    public void testBenchmark() {
        DataSegment segment = CostBalancerStrategyTest.getSegment(1000, "testds", this.interval1);
        this.selected = this.strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
    }

    @BenchmarkOptions(warmupRounds=1000, benchmarkRounds=1000000)
    @Test
    public void testJodaGap() {
        long diff = 0L;
        for (int i = 0; i < 1000; ++i) {
            diff += this.interval1.gap((ReadableInterval)this.interval2).toDurationMillis();
        }
        this.sum = diff;
    }
}

