/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ImmutableDruidServerTests;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.DiskNormalizedCostBalancerStrategy;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class DiskNormalizedCostBalancerStrategyTest {
    private static final Interval DAY = Intervals.of((String)"2015-01-01T00/2015-01-01T01");

    public static List<ServerHolder> setupDummyCluster(int serverCount, int maxSegments) {
        List<DataSegment> segments;
        ArrayList<ServerHolder> serverHolderList = new ArrayList<ServerHolder>();
        for (int i = 0; i < serverCount; ++i) {
            LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
            segments = IntStream.range(0, maxSegments).mapToObj(j -> DiskNormalizedCostBalancerStrategyTest.getSegment(j)).collect(Collectors.toList());
            ImmutableDruidDataSource dataSource = new ImmutableDruidDataSource("DUMMY", Collections.emptyMap(), segments);
            serverHolderList.add(new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("DruidServer_Name_" + i, "localhost", null, 10000000L, ServerType.HISTORICAL, "hot", 1), 3000L, ImmutableMap.of((Object)"DUMMY", (Object)dataSource), segments.size()), (LoadQueuePeon)fromPeon));
        }
        LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
        ImmutableDruidServer druidServer = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        EasyMock.expect((Object)druidServer.getName()).andReturn((Object)"BEST_SERVER").anyTimes();
        EasyMock.expect((Object)druidServer.getCurrSize()).andReturn((Object)3000L).anyTimes();
        EasyMock.expect((Object)druidServer.getMaxSize()).andReturn((Object)100000000L).anyTimes();
        EasyMock.expect((Object)druidServer.getSegment((SegmentId)EasyMock.anyObject())).andReturn(null).anyTimes();
        segments = new ArrayList();
        for (int j2 = 0; j2 < maxSegments; ++j2) {
            DataSegment segment = DiskNormalizedCostBalancerStrategyTest.getSegment(j2);
            segments.add(segment);
            EasyMock.expect((Object)druidServer.getSegment(segment.getId())).andReturn((Object)segment).anyTimes();
        }
        ImmutableDruidServerTests.expectSegments(druidServer, segments);
        EasyMock.replay((Object[])new Object[]{druidServer});
        serverHolderList.add(new ServerHolder(druidServer, (LoadQueuePeon)fromPeon));
        return serverHolderList;
    }

    public static DataSegment getSegment(int index) {
        return DiskNormalizedCostBalancerStrategyTest.getSegment(index, "DUMMY", DAY);
    }

    public static DataSegment getSegment(int index, String dataSource, Interval interval) {
        DataSegment segment = new DataSegment(dataSource, interval, String.valueOf(index), new ConcurrentHashMap(), new ArrayList(), new ArrayList(), null, Integer.valueOf(0), (long)index * 100L);
        return segment;
    }

    @Test
    public void testNormalizedCostBalancerMultiThreadedStrategy() {
        List<ServerHolder> serverHolderList = DiskNormalizedCostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = DiskNormalizedCostBalancerStrategyTest.getSegment(1000);
        DiskNormalizedCostBalancerStrategy strategy = new DiskNormalizedCostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)4, (String)"DiskNormalizedCostBalancerStrategyTest-%d")));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }

    @Test
    public void testNormalizedCostBalancerSingleThreadStrategy() {
        List<ServerHolder> serverHolderList = DiskNormalizedCostBalancerStrategyTest.setupDummyCluster(10, 20);
        DataSegment segment = DiskNormalizedCostBalancerStrategyTest.getSegment(1000);
        DiskNormalizedCostBalancerStrategy strategy = new DiskNormalizedCostBalancerStrategy(MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)1, (String)"DiskNormalizedCostBalancerStrategyTest-%d")));
        ServerHolder holder = strategy.findNewSegmentHomeReplicator(segment, serverHolderList);
        Assert.assertNotNull((String)"Should be able to find a place for new segment!!", (Object)holder);
        Assert.assertEquals((String)"Best Server should be BEST_SERVER", (Object)"BEST_SERVER", (Object)holder.getServer().getName());
    }
}

