/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.List;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.EmitClusterStatsAndMetrics;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EmitClusterStatsAndMetricsTest {
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Mock
    private DruidCoordinator mockDruidCoordinator;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    CoordinatorStats mockCoordinatorStats;
    @Mock
    DruidCluster mockDruidCluster;
    @Mock
    MetadataRuleManager mockMetadataRuleManager;

    @Test
    public void testRunOnlyEmitStatsForHistoricalDuties() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.mockCoordinatorStats);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getDruidCluster()).thenReturn((Object)this.mockDruidCluster);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getDatabaseRuleManager()).thenReturn((Object)this.mockMetadataRuleManager);
        Mockito.when((Object)this.mockDruidCoordinator.computeNumsUnavailableUsedSegmentsPerDataSource()).thenReturn((Object)Object2IntMaps.emptyMap());
        Mockito.when((Object)this.mockDruidCoordinator.computeUnderReplicationCountsPerDataSourcePerTier()).thenReturn((Object)ImmutableMap.of());
        EmitClusterStatsAndMetrics duty = new EmitClusterStatsAndMetrics(this.mockDruidCoordinator, "HistoricalManagementDuties", false);
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter, (VerificationMode)Mockito.atLeastOnce())).emit((ServiceEventBuilder)argumentCaptor.capture());
        List emittedEvents = argumentCaptor.getAllValues();
        boolean foundCompactMetric = false;
        boolean foundHistoricalDutyMetric = false;
        for (ServiceEventBuilder eventBuilder : emittedEvents) {
            ServiceMetricEvent serviceMetricEvent = (ServiceMetricEvent)eventBuilder.build("x", "x");
            String metric = serviceMetricEvent.getMetric();
            if ("segment/overShadowed/count".equals(metric)) {
                foundHistoricalDutyMetric = true;
            } else if ("compact/task/count".equals(metric)) {
                foundCompactMetric = true;
            }
            String dutyGroup = (String)serviceMetricEvent.getUserDims().get("dutyGroup");
            Assert.assertNotNull((Object)dutyGroup);
            Assert.assertEquals((Object)"HistoricalManagementDuties", (Object)dutyGroup);
        }
        Assert.assertTrue((boolean)foundHistoricalDutyMetric);
        Assert.assertFalse((boolean)foundCompactMetric);
    }

    @Test
    public void testRunEmitStatsForCompactionWhenHaveCompactSegmentDuty() {
        String groupName = "blah";
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(ServiceEventBuilder.class);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getCoordinatorStats()).thenReturn((Object)this.mockCoordinatorStats);
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getDruidCluster()).thenReturn((Object)this.mockDruidCluster);
        EmitClusterStatsAndMetrics duty = new EmitClusterStatsAndMetrics(this.mockDruidCoordinator, groupName, true);
        duty.run(this.mockDruidCoordinatorRuntimeParams);
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter, (VerificationMode)Mockito.atLeastOnce())).emit((ServiceEventBuilder)argumentCaptor.capture());
        List emittedEvents = argumentCaptor.getAllValues();
        boolean foundCompactMetric = false;
        boolean foundHistoricalDutyMetric = false;
        for (ServiceEventBuilder eventBuilder : emittedEvents) {
            ServiceMetricEvent serviceMetricEvent = (ServiceMetricEvent)eventBuilder.build("x", "x");
            String metric = serviceMetricEvent.getMetric();
            if ("segment/overShadowed/count".equals(metric)) {
                foundHistoricalDutyMetric = true;
            } else if ("compact/task/count".equals(metric)) {
                foundCompactMetric = true;
            }
            String dutyGroup = (String)serviceMetricEvent.getUserDims().get("dutyGroup");
            Assert.assertNotNull((Object)dutyGroup);
            Assert.assertEquals((Object)groupName, (Object)dutyGroup);
        }
        Assert.assertFalse((boolean)foundHistoricalDutyMetric);
        Assert.assertTrue((boolean)foundCompactMetric);
    }
}

