/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.audit.AuditManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillAuditLog;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillAuditLogTest {
    @Mock
    private AuditManager mockAuditManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillAuditLog killAuditLog;

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration(Long.MAX_VALUE)).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killAuditLog = new KillAuditLog(this.mockAuditManager, (DruidCoordinatorConfig)druidCoordinatorConfig);
        this.killAuditLog.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockAuditManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT6S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.killAuditLog = new KillAuditLog(this.mockAuditManager, (DruidCoordinatorConfig)druidCoordinatorConfig);
        this.killAuditLog.run(this.mockDruidCoordinatorRuntimeParams);
        ((AuditManager)Mockito.verify((Object)this.mockAuditManager)).removeAuditLogsOlderThan(ArgumentMatchers.anyLong());
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5s")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT3S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("coordinator audit kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.killAuditLog = new KillAuditLog(this.mockAuditManager, (DruidCoordinatorConfig)druidCoordinatorConfig);
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig.Builder().withMetadataStoreManagementPeriod(new Duration((Object)"PT5S")).withCoordianatorAuditKillPeriod(new Duration((Object)"PT6S")).withCoordinatorAuditKillDurationToRetain(new Duration((Object)"PT-1S")).withCoordinatorKillMaxSegments(10).withCoordinatorKillIgnoreDurationToRetain(false).build();
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("coordinator audit kill retainDuration must be >= 0");
        this.killAuditLog = new KillAuditLog(this.mockAuditManager, (DruidCoordinatorConfig)druidCoordinatorConfig);
    }
}

